/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.integration.crafttweaker;

import com.mrcrayfish.furniture.api.RecipeData;
import com.mrcrayfish.furniture.api.Recipes;
import com.mrcrayfish.furniture.integration.crafttweaker.CraftTweakerIntegration;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenDoc;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.IngredientAny;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.mc1120.item.MCItemStack;
import javax.annotation.Nonnull;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.cfm.MineBay")
public class MineBay {
    @ZenMethod
    @ZenDoc(value="Remove matching trades.")
    public static void remove(@Optional IIngredient item) {
        if (item == null) {
            item = IngredientAny.INSTANCE;
        }
        IIngredient finalItem = item;
        CraftTweakerIntegration.defer("Remove trade(s) matching " + item + " from MineBay", () -> {
            if (!Recipes.localMineBayRecipes.removeIf(data -> {
                if (finalItem.matchesExact((IItemStack)new MCItemStack(data.getInput()))) {
                    CraftTweakerAPI.logInfo((String)("MineBay: Removed trade " + data));
                    return true;
                }
                return false;
            })) {
                CraftTweakerAPI.logError((String)("MineBay: No trades matched " + finalItem));
            }
        });
    }

    @ZenMethod
    @ZenDoc(value="Add a trade.")
    public static void addTrade(@Nonnull IItemStack item, @Nonnull IItemStack currency) {
        if (item == null) {
            throw new IllegalArgumentException("item cannot be null");
        }
        if (currency == null) {
            throw new IllegalArgumentException("currency cannot be null");
        }
        RecipeData data = new RecipeData();
        data.setInput(CraftTweakerMC.getItemStack((IItemStack)item));
        data.setCurrency(CraftTweakerMC.getItemStack((IItemStack)currency.withAmount(1)));
        data.setPrice(currency.getAmount());
        CraftTweakerIntegration.defer("Add trade " + data + " to MineBay", () -> {
            if (data.getPrice() < 1 || data.getPrice() > 64) {
                CraftTweakerAPI.logError((String)"MineBay: Invalid trade price. Must be from 1 to 64.");
                return;
            }
            Recipes.localMineBayRecipes.add(data);
            CraftTweakerAPI.logInfo((String)("MineBay: Added trade " + data));
        });
    }
}

