/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.mffs.api;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class PointXYZ {
    public BlockPos pos;
    public int dimensionId;

    public PointXYZ(BlockPos pos) {
        this(pos, Integer.MAX_VALUE);
    }

    public PointXYZ(BlockPos pos, World worldObj) {
        this(pos, worldObj.field_73011_w.getDimension());
    }

    public PointXYZ(double x, double y, double z, World world) {
        this(new BlockPos(x, y, z), world);
    }

    public PointXYZ(double x, double y, double z, int dimensionId) {
        this(new BlockPos(x, y, z), dimensionId);
    }

    public PointXYZ(double x, double y, double z) {
        this(new BlockPos(x, y, z));
    }

    public PointXYZ(BlockPos pos, int dimensionId) {
        this.pos = pos;
        this.dimensionId = dimensionId;
    }

    public PointXYZ(NBTTagCompound nbt) {
        this(new BlockPos(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z")), nbt.func_74762_e("dim"));
    }

    public NBTTagCompound asNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("x", this.pos.func_177958_n());
        nbt.func_74768_a("y", this.pos.func_177956_o());
        nbt.func_74768_a("z", this.pos.func_177952_p());
        nbt.func_74768_a("dim", this.dimensionId);
        return nbt;
    }

    public World getPointWorld() {
        if (this.dimensionId != Integer.MAX_VALUE) {
            return DimensionManager.getWorld((int)this.dimensionId);
        }
        return null;
    }

    public static double distance(PointXYZ png1, PointXYZ png2) {
        if (png1.dimensionId == png2.dimensionId) {
            int dx = png1.pos.func_177958_n() - png2.pos.func_177958_n();
            int dy = png1.pos.func_177956_o() - png2.pos.func_177956_o();
            int dz = png1.pos.func_177952_p() - png2.pos.func_177952_p();
            return Math.sqrt(dx * dx + dy * dy + dz * dz);
        }
        return 2.147483647E9;
    }

    public boolean equals(Object pnt2) {
        if (pnt2 instanceof PointXYZ) {
            PointXYZ p = (PointXYZ)pnt2;
            return this.pos.equals((Object)p.pos) && this.dimensionId == p.dimensionId;
        }
        return false;
    }

    public int hashCode() {
        return ("X: " + this.pos.func_177958_n() + " Y: " + this.pos.func_177956_o() + " Z: " + this.pos.func_177952_p() + "D: " + this.dimensionId).hashCode();
    }

    public String toString() {
        return "X: " + this.pos.func_177958_n() + " Y: " + this.pos.func_177956_o() + " Z: " + this.pos.func_177952_p();
    }
}

