/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.totemexpansion.handler.action.impl;

import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import party.lemons.totemexpansion.handler.PlayerData;
import party.lemons.totemexpansion.handler.action.ActionState;
import party.lemons.totemexpansion.handler.action.Actions;
import party.lemons.totemexpansion.handler.action.PlayerAction;

public abstract class ActionRecall
extends PlayerAction {
    protected final float SPEED = 0.15f;
    protected final float MAX_Y = 600.0f;
    protected final int PARTICLE_AMOUNT = 10;
    protected int direction = 0;

    public ActionRecall(int direction, String id) {
        super(id);
        this.direction = direction;
    }

    @Override
    public boolean onTakeDamage(EntityPlayer player, DamageSource source, ActionState state) {
        return false;
    }

    @Override
    public void onActionUpdate(EntityPlayer player, ActionState state) {
        PlayerData data = (PlayerData)player.getCapability(PlayerData.CAPABILITY, null);
        this.recallGetHomePosition(player, data, player.field_70170_p);
        this.recallUpdate(player, data, (float)this.direction * 0.15f);
        NBTTagCompound stateTags = state.getTagCompound();
        BlockPos pos = NBTUtil.func_186861_c((NBTTagCompound)stateTags.func_74775_l("spawnpos"));
        if (this.shouldSwitch(player, state, pos)) {
            this.recallResetAtPosition(player, data, this.getResetPosition(player, pos), this.getNextState(state));
        }
    }

    public abstract boolean shouldSwitch(EntityPlayer var1, ActionState var2, BlockPos var3);

    public abstract BlockPos getResetPosition(EntityPlayer var1, BlockPos var2);

    public abstract ActionState getNextState(ActionState var1);

    private BlockPos recallGetHomePosition(EntityPlayer player, PlayerData data, World world) {
        BlockPos spawnPos;
        block6: {
            BlockPos bedLocation;
            boolean hasBed;
            NBTTagCompound stateTags;
            ActionState state;
            block8: {
                block7: {
                    block5: {
                        state = data.getActionState();
                        stateTags = state.getTagCompound();
                        if (!stateTags.func_74764_b("recallPos")) break block5;
                        NBTTagCompound posTag = stateTags.func_74775_l("spawnpos");
                        spawnPos = NBTUtil.func_186861_c((NBTTagCompound)posTag);
                        break block6;
                    }
                    hasBed = true;
                    bedLocation = player.func_180470_cg();
                    if (bedLocation == null) break block7;
                    if (EntityPlayer.func_180467_a((World)world, (BlockPos)bedLocation, (boolean)false) != null) break block8;
                }
                hasBed = false;
            }
            if (!hasBed) {
                BlockPos blockpos = world.field_73011_w.getRandomizedSpawnPoint();
                spawnPos = world.func_175672_r(blockpos);
            } else {
                spawnPos = EntityPlayer.func_180467_a((World)world, (BlockPos)bedLocation, (boolean)false);
            }
            NBTTagCompound posTag = NBTUtil.func_186859_a((BlockPos)spawnPos);
            stateTags.func_74782_a("spawnpos", (NBTBase)posTag);
            state.setTagCompound(stateTags);
        }
        return spawnPos;
    }

    private void recallUpdate(EntityPlayer player, PlayerData data, float speed) {
        ActionState state = data.getActionState();
        NBTTagCompound stateTags = state.getTagCompound();
        float spd = Math.abs(speed);
        if (stateTags.func_74764_b("SPEED")) {
            spd = stateTags.func_74760_g("SPEED") + Math.abs(speed);
        }
        player.field_70163_u += (double)(Math.signum(speed) * spd);
        player.field_70125_A = 90.0f;
        if (!player.field_70170_p.field_72995_K) {
            ((EntityPlayerMP)player).field_71135_a.func_147364_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, 90.0f);
        } else {
            World world = player.field_70170_p;
            Random rand = world.field_73012_v;
            for (int i = 0; i < 10; ++i) {
                float posX = (float)(player.field_70165_t - 0.5 + (double)rand.nextFloat());
                float posZ = (float)(player.field_70161_v - 0.5 + (double)rand.nextFloat());
                float posY = (float)(player.field_70163_u - (double)(rand.nextFloat() * 2.0f));
                float vX = rand.nextFloat() / 5.0f;
                float vZ = rand.nextFloat() / 5.0f;
                float vY = -0.25f;
                world.func_175688_a(EnumParticleTypes.CLOUD, (double)posX, (double)posY, (double)posZ, (double)vX, (double)vY, (double)vZ, new int[0]);
            }
        }
        stateTags.func_74776_a("SPEED", spd);
        state.setTagCompound(stateTags);
        player.field_71075_bZ.field_75100_b = true;
        player.field_71075_bZ.field_75101_c = true;
    }

    private void recallResetAtPosition(EntityPlayer player, PlayerData data, BlockPos position, ActionState newState) {
        player.field_70125_A = 90.0f;
        if (!player.field_70170_p.field_72995_K) {
            ((EntityPlayerMP)player).field_71135_a.func_147364_a((double)position.func_177958_n() + 0.5, (double)position.func_177984_a().func_177956_o(), (double)position.func_177952_p() + 0.5, player.field_70177_z, 90.0f);
        }
        data.setActionState(player, newState);
        player.field_71075_bZ.field_75100_b = false;
        if (!player.func_184812_l_()) {
            player.field_71075_bZ.field_75101_c = false;
        }
    }

    public static class RecallDown
    extends ActionRecall {
        public RecallDown() {
            super(-1, "totemexpansion_recall_down");
        }

        @Override
        public boolean shouldSwitch(EntityPlayer player, ActionState state, BlockPos spawnPos) {
            return player.field_70163_u <= (double)spawnPos.func_177977_b().func_177956_o();
        }

        @Override
        public BlockPos getResetPosition(EntityPlayer player, BlockPos spawnPos) {
            return spawnPos;
        }

        @Override
        public ActionState getNextState(ActionState currentState) {
            return new ActionState(PlayerAction.NONE);
        }
    }

    public static class RecallUp
    extends ActionRecall {
        public RecallUp() {
            super(1, "totemexpansion_recall_up");
        }

        @Override
        public boolean shouldSwitch(EntityPlayer player, ActionState state, BlockPos spawnPos) {
            return player.field_70163_u >= 600.0;
        }

        @Override
        public BlockPos getResetPosition(EntityPlayer player, BlockPos spawnPos) {
            return new BlockPos((double)spawnPos.func_177958_n(), player.field_70163_u, (double)spawnPos.func_177952_p());
        }

        @Override
        public ActionState getNextState(ActionState currentState) {
            NBTTagCompound currentTags = currentState.getTagCompound();
            currentTags.func_74776_a("SPEED", 0.0f);
            ActionState nextState = new ActionState(Actions.RECALL_DOWN, currentTags);
            return nextState;
        }
    }
}

