/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.totemexpansion.misc;

import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import party.lemons.totemexpansion.config.ModConfig;
import party.lemons.totemexpansion.item.ItemTotemHead;
import party.lemons.totemexpansion.item.ModItems;
import party.lemons.totemexpansion.misc.TotemUtil;

@Mod.EventBusSubscriber(modid="totemexpansion")
public class ModVillage {
    @GameRegistry.ObjectHolder(value="totemexpansion:witchdoctor")
    public static VillagerRegistry.VillagerProfession WITCH_DOCTOR = null;

    @SubscribeEvent
    public static void onRegisterVillage(RegistryEvent.Register<VillagerRegistry.VillagerProfession> event) {
        if (ModConfig.VILLAGER_ENABLED) {
            VillagerRegistry.VillagerProfession proff = new VillagerRegistry.VillagerProfession("totemexpansion:witchdoctor", "totemexpansion:textures/entity/villager/witch_doctor.png", "totemexpansion:textures/entity/villager/witch_doctor_zombie.png");
            event.getRegistry().register((IForgeRegistryEntry)proff);
            VillagerRegistry.VillagerCareer career = new VillagerRegistry.VillagerCareer(proff, "witch_doctor");
            ModVillage.addTrade(career, ModItems.TOTEM_BASE, new EntityVillager.PriceInfo(1, 5));
            for (Item head : TotemUtil.getListOfTotemHeads()) {
                ModVillage.addHeadTrade(career, (ItemTotemHead)head);
            }
            ModVillage.addSkullTrade(career, 0, new EntityVillager.PriceInfo(15, 39));
            ModVillage.addSkullTrade(career, 2, new EntityVillager.PriceInfo(15, 39));
            ModVillage.addSkullTrade(career, 4, new EntityVillager.PriceInfo(15, 39));
        }
        if (ModConfig.VILLAGE_HOUSE_ENABLED) {
            VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new VillageCreationHandler());
            MapGenStructureIO.func_143031_a(WitchDoctorHouse.class, (String)"totemexpansion:witchdoctor");
        }
    }

    public static void addTrade(VillagerRegistry.VillagerCareer career, Item item, EntityVillager.PriceInfo info) {
        for (String s : ModConfig.TRADE_BLACKLIST_HEADS) {
            if (!s.equalsIgnoreCase(item.getRegistryName().toString())) continue;
            return;
        }
        career.addTrade(1, new EntityVillager.ITradeList[]{new EntityVillager.ListItemForEmeralds(item, info)});
    }

    public static void addHeadTrade(VillagerRegistry.VillagerCareer carrer, ItemTotemHead head) {
        for (String s : ModConfig.TRADE_BLACKLIST_HEADS) {
            if (!s.equalsIgnoreCase(head.getRegistryName().toString())) continue;
            return;
        }
        carrer.addTrade(1, new EntityVillager.ITradeList[]{new EntityVillager.ListItemForEmeralds((Item)head, TotemUtil.getTotemPrice(head))});
    }

    public static void addSkullTrade(VillagerRegistry.VillagerCareer career, int meta, EntityVillager.PriceInfo info) {
        for (int i : ModConfig.TRADE_BLACKLIST_SKULLS) {
            if (i != meta) continue;
            return;
        }
        career.addTrade(1, new EntityVillager.ITradeList[]{new EntityVillager.ListItemForEmeralds(new ItemStack(Items.field_151144_bL, 1, meta), info)});
    }

    public static class WitchDoctorHouse
    extends StructureVillagePieces.Village {
        public WitchDoctorHouse() {
        }

        public WitchDoctorHouse(StructureVillagePieces.Start start, int type, Random rand, StructureBoundingBox p_i45571_4_, EnumFacing facing) {
            super(start, type);
            this.func_186164_a(facing);
            this.field_74887_e = p_i45571_4_;
        }

        public static WitchDoctorHouse createPiece(StructureVillagePieces.Start start, List<StructureComponent> p_175850_1_, Random rand, int p_175850_3_, int p_175850_4_, int p_175850_5_, EnumFacing facing, int p_175850_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)p_175850_3_, (int)p_175850_4_, (int)p_175850_5_, (int)0, (int)0, (int)0, (int)9, (int)9, (int)6, (EnumFacing)facing);
            return WitchDoctorHouse.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a(p_175850_1_, (StructureBoundingBox)structureboundingbox) == null ? new WitchDoctorHouse(start, p_175850_7_, rand, structureboundingbox, facing) : null;
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.func_74889_b(worldIn, structureBoundingBoxIn);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 9 - 1, 0);
            }
            IBlockState iblockstate = Blocks.field_150417_aV.func_176223_P();
            IBlockState iblockstate1 = Blocks.field_150487_bG.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH);
            IBlockState iblockstate2 = Blocks.field_150487_bG.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH);
            IBlockState iblockstate3 = Blocks.field_150487_bG.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST);
            IBlockState iblockstate4 = Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.SPRUCE);
            IBlockState iblockstate5 = Blocks.field_150487_bG.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 1, 7, 5, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 0, 0, 8, 0, 5, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 5, 0, 8, 5, 5, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 6, 1, 8, 6, 4, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 7, 2, 8, 7, 3, iblockstate, iblockstate, false);
            for (int i = -1; i <= 2; ++i) {
                for (int j = 0; j <= 8; ++j) {
                    this.func_175811_a(worldIn, iblockstate1, j, 6 + i, i, structureBoundingBoxIn);
                    this.func_175811_a(worldIn, iblockstate2, j, 6 + i, 5 - i, structureBoundingBoxIn);
                }
            }
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 1, 0, 0, 1, 5, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 1, 5, 8, 1, 5, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 8, 1, 0, 8, 1, 4, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 2, 1, 0, 7, 1, 0, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 2, 0, 0, 4, 0, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 2, 5, 0, 4, 5, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 8, 2, 5, 8, 4, 5, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 8, 2, 0, 8, 4, 0, iblockstate, iblockstate, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 0, 2, 1, 0, 4, 4, iblockstate4, iblockstate4, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 2, 5, 7, 4, 5, iblockstate4, iblockstate4, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 8, 2, 1, 8, 4, 4, iblockstate4, iblockstate4, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 2, 0, 7, 4, 0, iblockstate4, iblockstate4, false);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 4, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 5, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 6, 2, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 4, 3, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 5, 3, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 6, 3, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 0, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 0, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 0, 3, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 0, 3, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 8, 2, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 8, 2, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 8, 3, 2, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 8, 3, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 2, 2, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 3, 2, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 5, 2, 5, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150410_aZ.func_176223_P(), 6, 2, 5, structureBoundingBoxIn);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 4, 1, 7, 4, 1, iblockstate4, iblockstate4, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 4, 4, 7, 4, 4, iblockstate4, iblockstate4, false);
            this.func_175804_a(worldIn, structureBoundingBoxIn, 1, 3, 4, 7, 3, 4, Blocks.field_150342_X.func_176223_P(), Blocks.field_150342_X.func_176223_P(), false);
            this.func_175811_a(worldIn, iblockstate4, 7, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate3, 7, 1, 3, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 6, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 5, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 4, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, iblockstate1, 3, 1, 4, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150462_ai.func_176223_P(), 7, 1, 1, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 1, 1, 0, structureBoundingBoxIn);
            this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), 1, 2, 0, structureBoundingBoxIn);
            this.func_189927_a(worldIn, structureBoundingBoxIn, randomIn, 1, 1, 0, EnumFacing.NORTH);
            if (this.func_175807_a(worldIn, 1, 0, -1, structureBoundingBoxIn).func_185904_a() == Material.field_151579_a && this.func_175807_a(worldIn, 1, -1, -1, structureBoundingBoxIn).func_185904_a() != Material.field_151579_a) {
                this.func_175811_a(worldIn, iblockstate5, 1, 0, -1, structureBoundingBoxIn);
                if (this.func_175807_a(worldIn, 1, -1, -1, structureBoundingBoxIn).func_177230_c() == Blocks.field_185774_da) {
                    this.func_175811_a(worldIn, Blocks.field_150349_c.func_176223_P(), 1, -1, -1, structureBoundingBoxIn);
                }
            }
            for (int l = 0; l < 6; ++l) {
                for (int k = 0; k < 9; ++k) {
                    this.func_74871_b(worldIn, k, 9, l, structureBoundingBoxIn);
                    this.func_175808_b(worldIn, iblockstate, k, -1, l, structureBoundingBoxIn);
                }
            }
            this.func_74893_a(worldIn, structureBoundingBoxIn, 2, 1, 2, 1);
            return true;
        }

        protected VillagerRegistry.VillagerProfession chooseForgeProfession(int count, VillagerRegistry.VillagerProfession prof) {
            if (ModConfig.VILLAGER_ENABLED) {
                return WITCH_DOCTOR;
            }
            return super.chooseForgeProfession(count, prof);
        }
    }

    private static class VillageCreationHandler
    implements VillagerRegistry.IVillageCreationHandler {
        private VillageCreationHandler() {
        }

        public StructureVillagePieces.PieceWeight getVillagePieceWeight(Random random, int i) {
            return new StructureVillagePieces.PieceWeight(WitchDoctorHouse.class, 3, 1);
        }

        public Class<?> getComponentClass() {
            return WitchDoctorHouse.class;
        }

        public StructureVillagePieces.Village buildComponent(StructureVillagePieces.PieceWeight villagePiece, StructureVillagePieces.Start startPiece, List<StructureComponent> pieces, Random random, int p1, int p2, int p3, EnumFacing facing, int p5) {
            return WitchDoctorHouse.createPiece(startPiece, pieces, random, p1, p2, p3, facing, p5);
        }
    }
}

