/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.totemexpansion.misc;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;
import party.lemons.totemexpansion.config.ModConfig;
import party.lemons.totemexpansion.item.ItemTotemBase;
import party.lemons.totemexpansion.item.ItemTotemHead;

public class TotemUtil {
    private static List<Item> headCacheList = null;

    private TotemUtil() {
    }

    public static void updateOreCache() {
        ModConfig.ORES.clear();
        for (String s : ModConfig.TOTEM_OF_SPELUNKING_ORES_DICT) {
            NonNullList blocks = OreDictionary.getOres((String)s);
            for (ItemStack stack : blocks) {
                if (!(stack.func_77973_b() instanceof ItemBlock)) continue;
                ItemBlock ib = (ItemBlock)stack.func_77973_b();
                ModConfig.ORES.add(ib.func_179223_d());
            }
        }
    }

    public static Item randomTotemHead(Random r) {
        List<Item> totems = TotemUtil.getListOfTotemHeads();
        totems.removeIf(t -> TotemUtil.isTotemOnDropBlacklist(t));
        Item it = totems.get(r.nextInt(totems.size()));
        return it;
    }

    public static boolean isTotemBlacklisted(Item item) {
        if (item instanceof ItemTotemBase) {
            for (String s : ModConfig.TOTEM_BLACKLIST) {
                if (!s.equalsIgnoreCase(item.getRegistryName().toString())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isTotemOnDropBlacklist(Item i) {
        for (String s : ModConfig.TOTEM_HEAD_DROP_BLACKLIST) {
            if (!s.equalsIgnoreCase(i.getRegistryName().toString())) continue;
            return true;
        }
        return false;
    }

    public static List<Item> getListOfTotemHeads() {
        if (headCacheList == null) {
            headCacheList = new ArrayList<Item>();
            for (Item item : ForgeRegistries.ITEMS) {
                if (!(item instanceof ItemTotemHead) || !((ItemTotemHead)item).doesDrop()) continue;
                headCacheList.add(item);
            }
        }
        return headCacheList;
    }

    public static EntityVillager.PriceInfo getTotemPrice(ItemTotemHead head) {
        int min = (int)((float)ModConfig.VILLAGER_HEAD_MIN * head.getCostFactor());
        int max = (int)((float)ModConfig.VILLAGER_HEAD_MAX * head.getCostFactor());
        EntityVillager.PriceInfo info = new EntityVillager.PriceInfo(min, max);
        return info;
    }
}

