/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.blankplanet;

import com.google.common.collect.ObjectArrays;
import com.mjr.blankplanet.CommonProxy;
import com.mjr.blankplanet.TeleportBlock;
import com.mjr.blankplanet.handlers.ServerHandler;
import com.mjr.blankplanet.handlers.capabilities.CapabilityStatsHandler;
import com.mjr.blankplanet.planet.BlankPlanetEvents;
import com.mjr.blankplanet.planet.TeleportTypeBlankPlanet;
import com.mjr.blankplanet.planet.WorldProviderBlankPlanet;
import com.mjr.blankplanet.planet.worldGen.BlankPlanetBiomes;
import com.mjr.blankplanet.util.ClientUtilities;
import com.mjr.mjrlegendslib.itemBlock.ItemBlockDefault;
import com.mjr.mjrlegendslib.util.MCUtilities;
import com.mjr.mjrlegendslib.util.MessageUtilities;
import com.mjr.mjrlegendslib.util.RegisterUtilities;
import com.mjr.mjrlegendslib.world.biomes.BiomeGenBase;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(modid="blankplanet", name="BlankPlanet", version="1.12.2-0.3", dependencies="required-after:forge@[14.23.1.2555,);required-after:mjrlegendslib@[1.12.2-1.0.5,);required-after:galacticraftcore;required-after:galacticraftplanets;", certificateFingerprint="b02331787272ec3515ebe63ecdeea0d746653468", acceptedMinecraftVersions="[1.12.2]")
public class BlankPlanet {
    @SidedProxy(clientSide="com.mjr.blankplanet.ClientProxy", serverSide="com.mjr.blankplanet.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="blankplanet")
    public static BlankPlanet instance;
    public static CreativeTabs BlocksTab;
    public static List<Item> itemList;
    public static List<Block> blocksList;
    public static List<BiomeGenBase> biomesList;
    public static Planet blankPlanet;
    public static Block teleport;
    public static int dimensionid;
    public static int biomeid;
    public static String biomename;
    public static boolean makelandingplatform;
    public static int spawnX;
    public static int spawnY;
    public static int spawnZ;
    public static int xpAmount;
    public static boolean reqiureXp;
    public static boolean clearinv;
    public static int rocketTier;
    public static boolean breathable;
    public static float gravity;
    public static float fallDamage;
    public static float windLevel;
    public static float thermal;
    public static float soundvol;
    public static float star;
    public static double solar;
    public static double fuel;
    public static long daylength;
    public static boolean onlyDay;
    public static boolean onlyNight;
    public static boolean teleportOnDeath;
    public static int spawnOnDealth;
    public static boolean teleportOnJoin;
    public static boolean teleportOnJoinEvery;
    public static int spawnWorld;
    public static boolean spawnParachest;
    public static final String CATEGORY_SPAWN = "advanced spawn options";
    public static final String CATEGORY_DIMENSION = "dimension options";
    public static final String CATEGORY_WORLD = "world options";
    public static DimensionType blackHole;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) throws NoSuchMethodException {
        Configuration config = new Configuration(new File("config/BlankPlanet.cfg"));
        config.load();
        config.renameProperty("general", "SpawnX", "Teleporter SpawnX");
        config.renameProperty("general", "SpawnY", "Teleporter SpawnY");
        config.renameProperty("general", "SpawnY", "Teleporter SpawnY");
        config.renameProperty("general", "Clear inventory when teleport", "Clear inventory when using teleporter");
        dimensionid = config.get(CATEGORY_DIMENSION, "Dimension id", "-99").getInt();
        biomeid = config.get(CATEGORY_DIMENSION, "Biome id", "199").getInt();
        biomename = config.get(CATEGORY_DIMENSION, "Biome name", "BlankPlanet").getString();
        makelandingplatform = config.get(CATEGORY_DIMENSION, "Make Landing Platforms", true).getBoolean(true);
        rocketTier = config.get(CATEGORY_WORLD, "Rocket reqiured", "3").getInt();
        breathable = config.get(CATEGORY_WORLD, "Breathable Atmosphere", false).getBoolean(false);
        gravity = (float)config.get(CATEGORY_WORLD, "Gravity", "0.058").getDouble();
        daylength = config.get(CATEGORY_WORLD, "Day Length", "24000").getInt();
        solar = config.get(CATEGORY_WORLD, "Solar Energy Multiplier", "8.0").getDouble();
        fuel = config.get(CATEGORY_WORLD, "Fuel Usage Multiplier", "1.0").getDouble();
        fallDamage = (float)config.get(CATEGORY_WORLD, "Fall Damage Multiplier", "0.3").getDouble();
        windLevel = (float)config.get(CATEGORY_WORLD, "Wind Level", "0.0").getDouble();
        thermal = (float)config.get(CATEGORY_WORLD, "Thermal Level Multiplier", "0.0").getDouble();
        soundvol = (float)config.get(CATEGORY_WORLD, "Sound Vol Reduction", "10.0").getDouble();
        star = (float)config.get(CATEGORY_WORLD, "Star Brightness", "1.0").getDouble();
        onlyDay = config.get(CATEGORY_WORLD, "Always Day Time", false).getBoolean(false);
        onlyNight = config.get(CATEGORY_WORLD, "Always Night Time", false, "WILL GET IGNORED IF 'Always Daytime' IS ENABLED").getBoolean(false);
        spawnX = config.get("general", "Teleporter SpawnX", "0").getInt();
        spawnY = config.get("general", "Teleporter SpawnY", "100").getInt();
        spawnZ = config.get("general", "Teleporter SpawnZ", "0").getInt();
        reqiureXp = config.get("general", "Teleporter reqiures Xp", false).getBoolean(false);
        xpAmount = config.get("general", "Teleporter Xp amount", "1").getInt();
        spawnParachest = config.get("general", "Spawn Parachest on Teleport", false).getBoolean(false);
        teleportOnDeath = config.get(CATEGORY_SPAWN, "Teleport Player on Death (skip bed spawns)", false).getBoolean(false);
        spawnOnDealth = config.get(CATEGORY_SPAWN, "Number ID of Dimesnion for 'Teleport Player on Death' option", "" + dimensionid).getInt();
        teleportOnJoin = config.get(CATEGORY_SPAWN, "Teleport Player only when they first join the world", false).getBoolean(false);
        teleportOnJoinEvery = config.get(CATEGORY_SPAWN, "Teleport Player on everytime they join world", false).getBoolean(false);
        spawnWorld = config.get(CATEGORY_SPAWN, "Number ID of Dimesnion for 'First/Everytime join world options'", "" + dimensionid).getInt();
        config.save();
        RegisterUtilities.registerEventHandler((Object)new BlankPlanetEvents());
        RegisterUtilities.registerEventHandler((Object)new ServerHandler());
        blankPlanet = new Planet("BlackHole").setParentSolarSystem(GalacticraftCore.solarSystemSol);
        blankPlanet.setTierRequired(rocketTier);
        blankPlanet.setRingColorRGB(0.1f, 0.9f, 0.6f);
        blankPlanet.setPhaseShift(0.8f);
        blankPlanet.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(5.0f, 5.0f));
        blankPlanet.setRelativeOrbitTime(166.84119f);
        blankPlanet.setBodyIcon(new ResourceLocation("blankplanet", "textures/gui/celestialbodies/blankplanet.png"));
        blankPlanet.setDimensionInfo(dimensionid, WorldProviderBlankPlanet.class);
        GalaxyRegistry.registerPlanet((Planet)blankPlanet);
        GalacticraftRegistry.registerTeleportType(WorldProviderBlankPlanet.class, (ITeleportType)new TeleportTypeBlankPlanet());
        GalacticraftRegistry.registerRocketGui(WorldProviderBlankPlanet.class, (ResourceLocation)new ResourceLocation("blankplanet", "textures/gui/rocket_gui.png"));
        proxy.preInit(event);
        BlankPlanet.registerBlock(teleport, ItemBlockDefault.class, teleport.func_149739_a().substring(5), new Object[0]);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (MCUtilities.isClient()) {
            ClientUtilities.registerBlockJson("blankplanet:", teleport, 0, teleport.func_149739_a().substring(5));
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        CapabilityStatsHandler.register();
        proxy.postInit(event);
    }

    public static void registerBiomes() {
        BlankPlanetBiomes.blankplanet.setRegistryName("blankplanet:blank_planet");
        biomesList.add(BlankPlanetBiomes.blankplanet);
    }

    public static void registerBlock(Block block, Class<? extends ItemBlock> itemclass, String name, Object ... itemCtorArgs) throws NoSuchMethodException {
        if (block.getRegistryName() == null) {
            block.setRegistryName(name);
        }
        blocksList.add(block);
        if (itemclass != null) {
            ItemBlock item = null;
            Class[] ctorArgClasses = new Class[itemCtorArgs.length + 1];
            ctorArgClasses[0] = Block.class;
            for (int idx = 1; idx < ctorArgClasses.length; ++idx) {
                ctorArgClasses[idx] = itemCtorArgs[idx - 1].getClass();
            }
            try {
                Constructor<? extends ItemBlock> constructor = itemclass.getConstructor(ctorArgClasses);
                item = constructor.newInstance(ObjectArrays.concat((Object)block, (Object[])itemCtorArgs));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            itemList.add((Item)item);
            if (item.getRegistryName() == null) {
                item.setRegistryName(name);
            }
        }
    }

    public static void registerItem(Item item, String name) {
        if (item.getRegistryName() == null) {
            item.setRegistryName(name);
        }
        itemList.add(item);
    }

    @Mod.EventHandler
    public void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        MessageUtilities.fatalErrorMessageToLog((String)"blankplanet", (String)("Invalid fingerprint detected! The file " + event.getSource().getName() + " may have been tampered with. This version will NOT be supported!"));
    }

    static {
        BlocksTab = new CreativeTabs("BlankPlanetTab"){

            public ItemStack func_78016_d() {
                return new ItemStack(Item.func_150898_a((Block)GCBlocks.solarPanel));
            }
        };
        itemList = new ArrayList<Item>();
        blocksList = new ArrayList<Block>();
        biomesList = new ArrayList<BiomeGenBase>();
        teleport = new TeleportBlock(Material.field_151576_e).func_149663_c("teleport");
        blackHole = DimensionType.register((String)"blankPlanet", (String)"BlankPlanet", (int)dimensionid, WorldProviderBlankPlanet.class, (boolean)false);
    }

    @Mod.EventBusSubscriber(modid="blankplanet")
    public static class RegistrationHandler {
        @SubscribeEvent
        public static void registerBlocksEvent(RegistryEvent.Register<Block> event) {
            for (Block block : blocksList) {
                event.getRegistry().register((IForgeRegistryEntry)block);
            }
        }

        @SubscribeEvent
        public static void registerItemsEvent(RegistryEvent.Register<Item> event) {
            for (Item item : itemList) {
                event.getRegistry().register((IForgeRegistryEntry)item);
            }
        }

        @SubscribeEvent
        public static void registerBiomesEvent(RegistryEvent.Register<Biome> event) {
            BlankPlanet.registerBiomes();
            for (BiomeGenBase biome : biomesList) {
                event.getRegistry().register((IForgeRegistryEntry)biome);
                if (ConfigManagerCore.disableBiomeTypeRegistrations) continue;
                biome.registerTypes();
            }
        }
    }
}

