/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.blankplanet.handlers;

import com.mjr.blankplanet.BlankPlanet;
import com.mjr.blankplanet.handlers.capabilities.CapabilityProviderStats;
import com.mjr.blankplanet.handlers.capabilities.CapabilityStatsHandler;
import com.mjr.blankplanet.handlers.capabilities.IStatsCapability;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class ServerHandler {
    @SubscribeEvent
    public void onAttachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayerMP) {
            event.addCapability(CapabilityStatsHandler.BP_PLAYER_PROP, (ICapabilityProvider)new CapabilityProviderStats((EntityPlayerMP)event.getObject()));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayer) {
            if (BlankPlanet.teleportOnJoin) {
                IStatsCapability stats = (IStatsCapability)event.player.getCapability(CapabilityStatsHandler.BP_STATS_CAPABILITY, null);
                if (!stats.getFirstSpawn()) {
                    this.tptoworld((EntityPlayerMP)event.player, BlankPlanet.spawnWorld);
                    stats.setFirstSpawn(true);
                }
            } else if (BlankPlanet.teleportOnJoinEvery) {
                this.tptoworld((EntityPlayerMP)event.player, BlankPlanet.spawnWorld);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (event.player instanceof EntityPlayer && BlankPlanet.teleportOnDeath) {
            this.tptoworld((EntityPlayerMP)event.player, BlankPlanet.spawnOnDealth);
        }
    }

    private void tptoworld(EntityPlayerMP pl, int id) {
        WorldServer world = (WorldServer)pl.field_70170_p;
        WorldUtil.transferEntityToDimension((Entity)pl, (int)id, (WorldServer)world);
    }
}

