/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.blankplanet.planet.worldGen;

import com.mjr.mjrlegendslib.world.BiomeDecoratorBase;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.prefab.core.BlockMetaPair;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.MapGenBaseMeta;
import micdoodle8.mods.galacticraft.core.perlin.generator.Gradient;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.ChunkGeneratorOverworld;

public abstract class ChunkProviderNoBedRock
extends ChunkGeneratorOverworld {
    protected final Random field_185990_i;
    private final Gradient noiseGen1;
    private final Gradient noiseGen2;
    private final Gradient noiseGen3;
    private final Gradient noiseGen4;
    private final Gradient noiseGen5;
    private final Gradient noiseGen6;
    private final Gradient noiseGen7;
    protected final World worldObj;
    private Biome[] biomesForGeneration = this.getBiomesForGeneration();
    private final double TERRAIN_HEIGHT_MOD = this.getHeightModifier();
    private final double SMALL_FEATURE_HEIGHT_MOD = this.getSmallFeatureHeightModifier();
    private final double MOUNTAIN_HEIGHT_MOD = this.getMountainHeightModifier();
    private final double VALLEY_HEIGHT_MOD = this.getValleyHeightModifier();
    private final int MID_HEIGHT = this.getSeaLevel();
    private static final int CHUNK_SIZE_X = 16;
    private static final int CHUNK_SIZE_Y = 256;
    private static final int CHUNK_SIZE_Z = 16;
    private static final double MAIN_FEATURE_FILTER_MOD = 4.0;
    private static final double LARGE_FEATURE_FILTER_MOD = 8.0;
    private static final double SMALL_FEATURE_FILTER_MOD = 8.0;
    private List<MapGenBaseMeta> worldGenerators;

    public ChunkProviderNoBedRock(World par1World, long seed, boolean mapFeaturesEnabled) {
        super(par1World, seed, mapFeaturesEnabled, "");
        this.worldObj = par1World;
        this.field_185990_i = new Random(seed);
        this.noiseGen1 = new Gradient(this.field_185990_i.nextLong(), 4, 0.25f);
        this.noiseGen2 = new Gradient(this.field_185990_i.nextLong(), 4, 0.25f);
        this.noiseGen3 = new Gradient(this.field_185990_i.nextLong(), 4, 0.25f);
        this.noiseGen4 = new Gradient(this.field_185990_i.nextLong(), 2, 0.25f);
        this.noiseGen5 = new Gradient(this.field_185990_i.nextLong(), 1, 0.25f);
        this.noiseGen6 = new Gradient(this.field_185990_i.nextLong(), 1, 0.25f);
        this.noiseGen7 = new Gradient(this.field_185990_i.nextLong(), 1, 0.25f);
    }

    public void generateTerrain(int chunkX, int chunkZ, ChunkPrimer primer) {
        this.noiseGen1.setFrequency(0.015f);
        this.noiseGen2.setFrequency(0.01f);
        this.noiseGen3.setFrequency(0.01f);
        this.noiseGen4.setFrequency(0.01f);
        this.noiseGen5.setFrequency(0.01f);
        this.noiseGen6.setFrequency(0.001f);
        this.noiseGen7.setFrequency(0.005f);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                double baseHeight = (double)this.noiseGen1.getNoise((float)(chunkX * 16 + x), (float)(chunkZ * 16 + z)) * this.TERRAIN_HEIGHT_MOD;
                double smallHillHeight = (double)this.noiseGen2.getNoise((float)(chunkX * 16 + x), (float)(chunkZ * 16 + z)) * this.SMALL_FEATURE_HEIGHT_MOD;
                double mountainHeight = Math.abs(this.noiseGen3.getNoise((float)(chunkX * 16 + x), (float)(chunkZ * 16 + z)));
                double valleyHeight = Math.abs(this.noiseGen4.getNoise((float)(chunkX * 16 + x), (float)(chunkZ * 16 + z)));
                double featureFilter = (double)this.noiseGen5.getNoise((float)(chunkX * 16 + x), (float)(chunkZ * 16 + z)) * 4.0;
                double largeFilter = (double)this.noiseGen6.getNoise((float)(chunkX * 16 + x), (float)(chunkZ * 16 + z)) * 8.0;
                double smallFilter = (double)this.noiseGen7.getNoise((float)(chunkX * 16 + x), (float)(chunkZ * 16 + z)) * 8.0 - 0.5;
                mountainHeight = this.lerp(smallHillHeight, mountainHeight * this.MOUNTAIN_HEIGHT_MOD, this.fade(this.clamp(mountainHeight * 2.0, 0.0, 1.0)));
                valleyHeight = this.lerp(smallHillHeight, valleyHeight * this.VALLEY_HEIGHT_MOD - this.VALLEY_HEIGHT_MOD + 9.0, this.fade(this.clamp((valleyHeight + 2.0) * 4.0, 0.0, 1.0)));
                double yDev = this.lerp(valleyHeight, mountainHeight, this.fade(largeFilter));
                yDev = this.lerp(smallHillHeight, yDev, smallFilter);
                yDev = this.lerp(baseHeight, yDev, featureFilter);
                for (int y = 0; y < 256; ++y) {
                    if (!((double)y < (double)this.MID_HEIGHT + yDev)) continue;
                    primer.func_177855_a(x, y, z, this.getStoneBlock().getBlock().func_176203_a((int)this.getStoneBlock().getMetadata()));
                }
            }
        }
    }

    private double lerp(double d1, double d2, double t) {
        if (t < 0.0) {
            return d1;
        }
        if (t > 1.0) {
            return d2;
        }
        return d1 + (d2 - d1) * t;
    }

    private double fade(double n) {
        return n * n * n * (n * (n * 6.0 - 15.0) + 10.0);
    }

    private double clamp(double x, double min, double max) {
        if (x < min) {
            return min;
        }
        if (x > max) {
            return max;
        }
        return x;
    }

    public void func_185977_a(int x, int z, ChunkPrimer primer, Biome[] biomesIn) {
        int var5 = 20;
        float var6 = 0.03125f;
        this.noiseGen4.setFrequency(0.0625f);
        for (int var8 = 0; var8 < 16; ++var8) {
            for (int var9 = 0; var9 < 16; ++var9) {
                int var12 = (int)((double)this.noiseGen4.getNoise((float)(x * 16 + var8), (float)(z * 16 + var9)) / 3.0 + 3.0 + this.field_185990_i.nextDouble() * 0.25);
                int var13 = -1;
                Block var14 = this.getGrassBlock().getBlock();
                byte var14m = this.getGrassBlock().getMetadata();
                Block var15 = this.getDirtBlock().getBlock();
                byte var15m = this.getDirtBlock().getMetadata();
                for (int var16 = 255; var16 >= 0; --var16) {
                    if (var16 <= 0 + this.field_185990_i.nextInt(5)) {
                        primer.func_177855_a(var8, var16, var9, Blocks.field_150350_a.func_176223_P());
                        continue;
                    }
                    Block var18 = primer.func_177856_a(var8, var16, var9).func_177230_c();
                    if (Blocks.field_150350_a == var18) {
                        var13 = -1;
                        continue;
                    }
                    if (var18 != this.getStoneBlock().getBlock()) continue;
                    if (var13 == -1) {
                        if (var12 <= 0) {
                            var14 = Blocks.field_150350_a;
                            var14m = 0;
                            var15 = this.getStoneBlock().getBlock();
                            var15m = this.getStoneBlock().getMetadata();
                        } else if (var16 >= 36 && var16 <= 21) {
                            var14 = this.getGrassBlock().getBlock();
                            var14m = this.getGrassBlock().getMetadata();
                            var14 = this.getDirtBlock().getBlock();
                            var14m = this.getDirtBlock().getMetadata();
                        }
                        var13 = var12;
                        if (var16 >= 19) {
                            primer.func_177855_a(var8, var16, var9, var14.func_176203_a((int)var14m));
                            continue;
                        }
                        primer.func_177855_a(var8, var16, var9, var15.func_176203_a((int)var15m));
                        continue;
                    }
                    if (var13 <= 0) continue;
                    --var13;
                    primer.func_177855_a(var8, var16, var9, var15.func_176203_a((int)var15m));
                }
            }
        }
    }

    public Chunk func_185932_a(int x, int z) {
        ChunkPrimer primer = new ChunkPrimer();
        this.field_185990_i.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        this.generateTerrain(x, z, primer);
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76933_b(this.biomesForGeneration, x * 16, z * 16, 16, 16);
        this.func_185977_a(x, z, primer, this.biomesForGeneration);
        if (this.worldGenerators == null) {
            this.worldGenerators = this.getWorldGenerators();
        }
        for (MapGenBaseMeta generator : this.worldGenerators) {
            generator.generate(this.worldObj, x, z, primer);
        }
        this.onChunkProvide(x, z, primer);
        Chunk var4 = new Chunk(this.worldObj, primer, x, z);
        byte[] var5 = var4.func_76605_m();
        for (int var6 = 0; var6 < var5.length; ++var6) {
            var5[var6] = (byte)Biome.func_185362_a((Biome)this.biomesForGeneration[var6]);
        }
        var4.func_76603_b();
        return var4;
    }

    public void decoratePlanet(World par1World, Random par2Random, BlockPos pos) {
        this.getBiomeGenerator().func_180292_a(par1World, par2Random, null, pos);
    }

    public void func_185931_b(int x, int z) {
        BlockFalling.field_149832_M = true;
        int var4 = x * 16;
        int var5 = z * 16;
        this.worldObj.func_180494_b(new BlockPos(var4 + 16, 0, var5 + 16));
        this.field_185990_i.setSeed(this.worldObj.func_72905_C());
        long var7 = this.field_185990_i.nextLong() / 2L * 2L + 1L;
        long var9 = this.field_185990_i.nextLong() / 2L * 2L + 1L;
        this.field_185990_i.setSeed((long)x * var7 + (long)z * var9 ^ this.worldObj.func_72905_C());
        this.decoratePlanet(this.worldObj, this.field_185990_i, new BlockPos(var4, 0, var5));
        this.onPopulate(x, z);
        BlockFalling.field_149832_M = false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        Biome biomegenbase = this.worldObj.func_180494_b(pos);
        return biomegenbase.func_76747_a(creatureType);
    }

    protected abstract BiomeDecoratorBase getBiomeGenerator();

    protected abstract Biome[] getBiomesForGeneration();

    protected abstract int getSeaLevel();

    protected abstract List<MapGenBaseMeta> getWorldGenerators();

    protected abstract BlockMetaPair getGrassBlock();

    protected abstract BlockMetaPair getDirtBlock();

    protected abstract BlockMetaPair getStoneBlock();

    public abstract double getHeightModifier();

    public abstract double getSmallFeatureHeightModifier();

    public abstract double getMountainHeightModifier();

    public abstract double getValleyHeightModifier();

    public abstract void onChunkProvide(int var1, int var2, ChunkPrimer var3);

    public abstract void onPopulate(int var1, int var2);
}

