/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.blankplanet.util;

import com.mjr.blankplanet.BlankPlanet;
import java.util.ArrayList;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.core.Constants;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class RegisterHelper {
    private static int id = 0;

    public static void registerExtraPlanetsNonMobEntity(Class<? extends Entity> var0, String var1, int trackingDistance, int updateFreq, boolean sendVel) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("blankplanet", var1), var0, (String)var1, (int)id++, (Object)BlankPlanet.instance, (int)trackingDistance, (int)updateFreq, (boolean)sendVel);
    }

    public static void registerExtraPlanetsMobEntity(Class<? extends Entity> entityClass, String name, int back, int fore) {
        RegisterHelper.registerExtraPlanetsNonMobEntity(entityClass, name, 80, 3, true);
        EntityRegistry.registerEgg((ResourceLocation)new ResourceLocation("blankplanet", name), (int)back, (int)fore);
    }

    public static void setHarvestLevel(Block block, String toolClass, int level, int meta) {
        block.setHarvestLevel(toolClass, level, block.func_176203_a(meta));
    }

    public static Planet registerUnreachablePlanet(String name, SolarSystem system) {
        ArrayList cBodyList = new ArrayList();
        cBodyList.addAll(GalaxyRegistry.getRegisteredPlanets().values());
        for (CelestialBody body : cBodyList) {
            if (!(body instanceof Planet) || !name.equals(body.getName()) || ((Planet)body).getParentSolarSystem() != system) continue;
            return null;
        }
        Planet planet = new Planet(name).setParentSolarSystem(system);
        planet.setBodyIcon(new ResourceLocation(Constants.ASSET_PREFIX, "textures/gui/celestialbodies/" + name + ".png"));
        GalaxyRegistry.registerPlanet((Planet)planet);
        return planet;
    }

    public static Moon registerUnreachableMoon(String name, Planet parent) {
        ArrayList cBodyList = new ArrayList();
        cBodyList.addAll(GalaxyRegistry.getRegisteredMoons().values());
        for (CelestialBody body : cBodyList) {
            if (!(body instanceof Moon) || !name.equals(body.getName()) || ((Moon)body).getParentPlanet() != parent) continue;
            return null;
        }
        Moon moon = new Moon(name).setParentPlanet(parent);
        if (name.equalsIgnoreCase("callisto") || name.equalsIgnoreCase("europa") || name.equalsIgnoreCase("io") || name.equalsIgnoreCase("ganymede")) {
            moon.setBodyIcon(new ResourceLocation(Constants.ASSET_PREFIX, "textures/gui/celestialbodies/" + name + ".png"));
        } else {
            moon.setBodyIcon(new ResourceLocation("blankplanet", "textures/gui/celestialbodies/" + name + ".png"));
        }
        GalaxyRegistry.registerMoon((Moon)moon);
        return moon;
    }
}

