/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.api.tileentity;

import fluxnetworks.api.ConnectionType;
import fluxnetworks.api.Coord4D;
import fluxnetworks.api.INetworkConnector;
import fluxnetworks.api.network.IFluxNetwork;
import fluxnetworks.api.network.ITransferHandler;
import fluxnetworks.common.core.FluxGuiStack;
import fluxnetworks.common.core.NBTType;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public interface IFluxConnector
extends INetworkConnector {
    public NBTTagCompound writeCustomNBT(NBTTagCompound var1, NBTType var2);

    public void readCustomNBT(NBTTagCompound var1, NBTType var2);

    public int getPriority();

    public int getActualPriority();

    public UUID getConnectionOwner();

    public ConnectionType getConnectionType();

    public boolean canAccess(EntityPlayer var1);

    public long getCurrentLimit();

    public long getActualLimit();

    default public long getMaxTransferLimit() {
        return Long.MAX_VALUE;
    }

    public boolean isActive();

    public boolean isChunkLoaded();

    public boolean isForcedLoading();

    public void connect(IFluxNetwork var1);

    public void disconnect(IFluxNetwork var1);

    public ITransferHandler getTransferHandler();

    public World getDimension();

    public Coord4D getCoords();

    public int getFolderID();

    public String getCustomName();

    public boolean getDisableLimit();

    public boolean getSurgeMode();

    default public long getBuffer() {
        return this.getTransferHandler().getEnergyStored();
    }

    default public long getChange() {
        return this.getTransferHandler().getChange();
    }

    default public void setChunkLoaded(boolean chunkLoaded) {
    }

    default public ItemStack getDisplayStack() {
        switch (this.getConnectionType()) {
            case POINT: {
                return FluxGuiStack.FLUX_POINT;
            }
            case PLUG: {
                return FluxGuiStack.FLUX_PLUG;
            }
            case CONTROLLER: {
                return FluxGuiStack.FLUX_CONTROLLER;
            }
        }
        return ItemStack.field_190927_a;
    }
}

