/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.client;

import com.google.common.collect.Lists;
import fluxnetworks.api.FluxConfigurationType;
import fluxnetworks.client.gui.basic.GuiFluxCore;
import fluxnetworks.common.block.BlockFluxCore;
import fluxnetworks.common.connection.NetworkSettings;
import fluxnetworks.common.core.FluxUtils;
import fluxnetworks.common.data.FluxNetworkData;
import fluxnetworks.common.handler.PacketHandler;
import fluxnetworks.common.item.ItemConfigurator;
import fluxnetworks.common.network.PacketColorRequest;
import fluxnetworks.common.tileentity.TileFluxCore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class FluxColorHandler
implements IBlockColor,
IItemColor {
    public static final FluxColorHandler INSTANCE = new FluxColorHandler();
    public static final int DEFAULT_COLOR = FluxUtils.getIntFromColor(41, 94, 138);
    public static final int NO_NETWORK_COLOR = FluxUtils.getIntFromColor(178, 178, 178);
    public static final Map<Integer, Integer> colorCache = new HashMap<Integer, Integer>();
    public static final Map<Integer, String> nameCache = new HashMap<Integer, String>();
    private static List<Integer> requests = new ArrayList<Integer>();
    private static List<Integer> sent_requests = new ArrayList<Integer>();
    public static int tickCount;

    public static void reset() {
        colorCache.clear();
        nameCache.clear();
        requests.clear();
    }

    public static void loadColorCache(int id, int color) {
        if (id != -1) {
            colorCache.put(id, color);
        }
    }

    public static void loadNameCache(int id, String name) {
        if (id != -1) {
            nameCache.put(id, name);
        }
    }

    public static void placeRequest(int id) {
        if (id != -1 && !requests.contains(id) && !sent_requests.contains(id)) {
            requests.add(id);
        }
    }

    public static int getOrRequestNetworkColor(int id) {
        if (id == -1) {
            return NO_NETWORK_COLOR;
        }
        Integer cached = colorCache.get(id);
        if (cached != null) {
            return cached;
        }
        FluxColorHandler.placeRequest(id);
        return NO_NETWORK_COLOR;
    }

    public static String getOrRequestNetworkName(int id) {
        if (id == -1) {
            return "NONE";
        }
        String cached = nameCache.get(id);
        if (cached != null) {
            return cached;
        }
        FluxColorHandler.placeRequest(id);
        return "WAITING FOR SERVER";
    }

    public static void sendRequests() {
        if (!requests.isEmpty() && ++tickCount > 40) {
            tickCount = 0;
            PacketHandler.network.sendToServer((IMessage)new PacketColorRequest.ColorRequestMessage(Lists.newArrayList(requests)));
            sent_requests.addAll(requests);
            requests.clear();
        }
    }

    public static void receiveCache(Map<Integer, Tuple<Integer, String>> cache) {
        cache.forEach((ID, DETAILS) -> {
            FluxColorHandler.loadColorCache(ID, (Integer)DETAILS.func_76341_a());
            FluxColorHandler.loadNameCache(ID, (String)DETAILS.func_76340_b());
            sent_requests.remove(ID);
            requests.remove(ID);
        });
    }

    public int func_186720_a(IBlockState state, @Nullable IBlockAccess world, @Nullable BlockPos pos, int tintIndex) {
        if (tintIndex == 1 && pos != null && world != null) {
            TileEntity tile = world.func_175625_s(pos);
            if (!((Boolean)state.func_177229_b((IProperty)BlockFluxCore.CONNECTED)).booleanValue()) {
                return NO_NETWORK_COLOR;
            }
            if (tile instanceof TileFluxCore) {
                TileFluxCore t = (TileFluxCore)tile;
                return FluxUtils.getBrighterColor(t.color, 1.2);
            }
            return DEFAULT_COLOR;
        }
        return -1;
    }

    public int func_186726_a(ItemStack stack, int tintIndex) {
        if (tintIndex == 1) {
            GuiScreen screen;
            if (stack.func_77942_o() && stack.func_77978_p().func_74767_n("GuiColor") && (screen = Minecraft.func_71410_x().field_71462_r) instanceof GuiFluxCore) {
                GuiFluxCore guiFluxCore = (GuiFluxCore)screen;
                return guiFluxCore.network.isInvalid() ? NO_NETWORK_COLOR : guiFluxCore.network.getSetting(NetworkSettings.NETWORK_COLOR) | 0xFF000000;
            }
            NBTTagCompound tag = stack.func_179543_a("FluxData");
            if (tag != null) {
                return FluxColorHandler.getOrRequestNetworkColor(tag.func_74762_e(FluxNetworkData.NETWORK_ID));
            }
            return NO_NETWORK_COLOR;
        }
        return -1;
    }

    public static int colorMultiplierForConfigurator(ItemStack stack, int tintIndex) {
        if (tintIndex == 1) {
            NBTTagCompound tag;
            GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
            if (screen instanceof GuiFluxCore) {
                GuiFluxCore guiFluxCore = (GuiFluxCore)screen;
                if (guiFluxCore.connector instanceof ItemConfigurator.NetworkConnector) {
                    return guiFluxCore.network.getSetting(NetworkSettings.NETWORK_COLOR);
                }
            }
            if ((tag = stack.func_179543_a("Configs")) != null) {
                return FluxColorHandler.getOrRequestNetworkColor(tag.func_74762_e(FluxConfigurationType.NETWORK.getNBTName()));
            }
            return NO_NETWORK_COLOR;
        }
        return -1;
    }
}

