/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.client.gui.basic;

import com.google.common.collect.Lists;
import fluxnetworks.FluxNetworks;
import fluxnetworks.FluxTranslate;
import fluxnetworks.api.AccessPermission;
import fluxnetworks.api.ConnectionType;
import fluxnetworks.api.FeedbackInfo;
import fluxnetworks.api.INetworkConnector;
import fluxnetworks.api.network.IFluxNetwork;
import fluxnetworks.api.tileentity.IFluxConnector;
import fluxnetworks.client.gui.basic.GuiButtonCore;
import fluxnetworks.client.gui.basic.GuiPopUpHost;
import fluxnetworks.client.gui.button.NormalButton;
import fluxnetworks.client.gui.button.SlidedSwitchButton;
import fluxnetworks.client.gui.button.TextboxButton;
import fluxnetworks.common.connection.FluxNetworkCache;
import fluxnetworks.common.connection.NetworkSettings;
import fluxnetworks.common.core.FluxUtils;
import fluxnetworks.common.handler.PacketHandler;
import fluxnetworks.common.item.ItemAdminConfigurator;
import fluxnetworks.common.item.ItemConfigurator;
import fluxnetworks.common.network.PacketSetConfiguratorNetwork;
import fluxnetworks.common.network.PacketTile;
import fluxnetworks.common.network.PacketTileHandler;
import fluxnetworks.common.network.PacketTileType;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class GuiFluxCore
extends GuiPopUpHost {
    public List<List<? extends GuiButtonCore>> buttonLists = Lists.newArrayList();
    protected List<NormalButton> buttons = Lists.newArrayList();
    protected List<TextboxButton> textBoxes = Lists.newArrayList();
    protected List<SlidedSwitchButton> switches = Lists.newArrayList();
    public IFluxNetwork network;
    public AccessPermission accessPermission = AccessPermission.NONE;
    protected boolean networkValid;
    private int timer1;

    public GuiFluxCore(EntityPlayer player, INetworkConnector connector) {
        super(player, connector);
        this.network = FluxNetworkCache.instance.getClientNetwork(connector.getNetworkID());
        this.networkValid = !this.network.isInvalid();
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.buttonLists.clear();
        this.buttons.clear();
        this.switches.clear();
        this.textBoxes.clear();
        this.buttonLists.add(this.buttons);
        this.buttonLists.add(this.switches);
    }

    @Override
    protected void drawForegroundLayer(int mouseX, int mouseY) {
        super.drawForegroundLayer(mouseX, mouseY);
        this.textBoxes.forEach(TextboxButton::drawTextBox);
        this.buttonLists.forEach(list -> list.forEach(b -> b.drawButton(this.field_146297_k, mouseX, mouseY, this.field_147003_i, this.field_147009_r)));
    }

    @Override
    protected void drawBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        super.drawBackgroundLayer(partialTicks, mouseX, mouseY);
        this.buttonLists.forEach(list -> list.forEach(b -> b.updateButton(partialTicks, mouseX, mouseY)));
    }

    @Override
    public void mouseMainClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.mouseMainClicked(mouseX, mouseY, mouseButton);
        block0: for (List<? extends GuiButtonCore> list : this.buttonLists) {
            for (GuiButtonCore guiButtonCore : list) {
                if (!guiButtonCore.clickable || !guiButtonCore.isMouseHovered(this.field_146297_k, mouseX - this.field_147003_i, mouseY - this.field_147009_r)) continue;
                this.onButtonClicked(guiButtonCore, mouseX - this.field_147003_i, mouseY - this.field_147009_r, mouseButton);
                break block0;
            }
        }
        this.textBoxes.forEach(b -> b.mouseClicked(mouseX - this.field_147003_i, mouseY - this.field_147009_r, mouseButton));
    }

    public void onButtonClicked(GuiButtonCore button, int mouseX, int mouseY, int mouseButton) {
    }

    @Override
    protected void keyTypedMain(char c, int k) throws IOException {
        for (TextboxButton text : this.textBoxes) {
            if (!text.isFocused()) continue;
            text.textboxKeyTyped(c, k);
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.timer1 == 0) {
            this.network = FluxNetworkCache.instance.getClientNetwork(this.connector.getNetworkID());
            this.networkValid = !this.network.isInvalid();
        }
        ++this.timer1;
        this.timer1 %= 20;
    }

    public void func_146281_b() {
        super.func_146281_b();
        FluxNetworks.proxy.setFeedback(FeedbackInfo.NONE, false);
        FluxNetworks.proxy.setFeedback(FeedbackInfo.NONE, true);
    }

    @Override
    protected void drawFluxDefaultBackground() {
        GlStateManager.func_179094_E();
        this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND);
        this.func_73729_b(this.field_146294_l / 2 - 128, this.field_146295_m / 2 - 128, 0, 0, 256, 256);
        float f = (float)(this.network.getSetting(NetworkSettings.NETWORK_COLOR) >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(this.network.getSetting(NetworkSettings.NETWORK_COLOR) >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(this.network.getSetting(NetworkSettings.NETWORK_COLOR) & 0xFF) / 255.0f;
        GlStateManager.func_179124_c((float)f, (float)f1, (float)f2);
        this.field_146297_k.func_110434_K().func_110577_a(FRAME);
        this.func_73729_b(this.field_146294_l / 2 - 128, this.field_146295_m / 2 - 128, 0, 0, 256, 256);
        GlStateManager.func_179121_F();
    }

    protected void renderTransfer(IFluxConnector fluxConnector, int color, int x, int y) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146289_q.func_78276_b(FluxUtils.getTransferInfo(fluxConnector.getConnectionType(), this.network.getSetting(NetworkSettings.NETWORK_ENERGY), fluxConnector.getTransferHandler().getChange()), x, y, color);
        this.field_146289_q.func_78276_b((fluxConnector.getConnectionType().isStorage() ? FluxTranslate.ENERGY.t() : FluxTranslate.BUFFER.t()) + ": " + TextFormatting.BLUE + FluxUtils.format(fluxConnector.getTransferHandler().getEnergyStored(), FluxUtils.TypeNumberFormat.COMMAS, this.network.getSetting(NetworkSettings.NETWORK_ENERGY), false), x, y + 10, 0xFFFFFF);
        this.renderItemStack(fluxConnector.getDisplayStack(), x - 20, y + 1);
        GlStateManager.func_179121_F();
    }

    protected List<String> getFluxInfo(IFluxConnector flux) {
        ArrayList list = Lists.newArrayList();
        list.add(TextFormatting.BOLD + flux.getCustomName());
        NBTTagCompound tag = flux.getDisplayStack().func_179543_a("FluxData");
        if (flux.isChunkLoaded()) {
            if (flux.isForcedLoading()) {
                list.add(TextFormatting.AQUA + FluxTranslate.FORCED_LOADING.t());
            }
            list.add(FluxUtils.getTransferInfo(flux.getConnectionType(), this.network.getSetting(NetworkSettings.NETWORK_ENERGY), flux.getChange()));
            if (flux.getConnectionType() == ConnectionType.STORAGE) {
                list.add(FluxTranslate.ENERGY_STORED.t() + ": " + TextFormatting.BLUE + NumberFormat.getInstance().format(flux.getBuffer()) + "RF");
            } else {
                list.add(FluxTranslate.INTERNAL_BUFFER.t() + ": " + TextFormatting.BLUE + NumberFormat.getInstance().format(flux.getBuffer()) + "RF");
            }
        } else {
            list.add(TextFormatting.RED + FluxTranslate.CHUNK_UNLOADED.t());
            if (tag != null) {
                if (tag.func_74764_b("energy")) {
                    list.add(FluxTranslate.ENERGY_STORED.t() + ": " + TextFormatting.BLUE + NumberFormat.getInstance().format(tag.func_74762_e("energy")) + "RF");
                } else {
                    list.add(FluxTranslate.INTERNAL_BUFFER.t() + ": " + TextFormatting.BLUE + NumberFormat.getInstance().format(tag.func_74763_f("buffer")) + "RF");
                }
            }
        }
        list.add(FluxTranslate.TRANSFER_LIMIT.t() + ": " + TextFormatting.GREEN + (flux.getDisableLimit() ? FluxTranslate.UNLIMITED.t() : Long.valueOf(flux.getCurrentLimit())));
        list.add(FluxTranslate.PRIORITY.t() + ": " + TextFormatting.GREEN + (flux.getSurgeMode() ? FluxTranslate.SURGE.t() : Integer.valueOf(flux.getPriority())));
        list.add(TextFormatting.ITALIC + flux.getCoords().getStringInfo());
        return list;
    }

    public void onSuperAdminChanged() {
    }

    public void setConnectedNetwork(int networkID, String password) {
        if (this.connector instanceof IFluxConnector) {
            PacketHandler.network.sendToServer((IMessage)new PacketTile.TileMessage(PacketTileType.SET_NETWORK, PacketTileHandler.getSetNetworkPacket(networkID, password), ((IFluxConnector)this.connector).getCoords().getPos(), ((IFluxConnector)this.connector).getCoords().getDimension()));
        }
        if (this.connector instanceof ItemAdminConfigurator.AdminConnector) {
            FluxNetworks.proxy.admin_viewing_network_id = networkID;
            FluxNetworks.proxy.admin_viewing_network = FluxNetworkCache.instance.getClientNetwork(networkID);
        }
        if (this.connector instanceof ItemConfigurator.NetworkConnector) {
            PacketHandler.network.sendToServer((IMessage)new PacketSetConfiguratorNetwork.SetConfiguratorNetworkMessage(networkID, password));
        }
    }
}

