/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.client.gui.tab;

import fluxnetworks.FluxNetworks;
import fluxnetworks.FluxTranslate;
import fluxnetworks.api.Coord4D;
import fluxnetworks.api.EnumNavigationTabs;
import fluxnetworks.api.FeedbackInfo;
import fluxnetworks.api.INetworkConnector;
import fluxnetworks.api.tileentity.IFluxConnector;
import fluxnetworks.client.gui.basic.GuiButtonCore;
import fluxnetworks.client.gui.basic.GuiDraw;
import fluxnetworks.client.gui.basic.GuiTabPages;
import fluxnetworks.client.gui.button.BatchEditButton;
import fluxnetworks.client.gui.popups.GuiPopConnectionEdit;
import fluxnetworks.client.gui.tab.GuiTabSelection;
import fluxnetworks.common.connection.NetworkSettings;
import fluxnetworks.common.core.FluxUtils;
import fluxnetworks.common.core.NBTType;
import fluxnetworks.common.handler.PacketHandler;
import fluxnetworks.common.network.PacketBatchEditing;
import fluxnetworks.common.network.PacketConnectionUpdateRequest;
import fluxnetworks.common.network.PacketNetworkUpdateRequest;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiTabConnections
extends GuiTabPages<IFluxConnector> {
    private List<BatchEditButton> editButtons = new ArrayList<BatchEditButton>();
    public List<IFluxConnector> batchConnections = new ArrayList<IFluxConnector>();
    public IFluxConnector singleConnection;
    public BatchEditButton clear;
    public BatchEditButton edit;
    public BatchEditButton disconnect;
    private int timer = 3;

    public GuiTabConnections(EntityPlayer player, INetworkConnector connector) {
        super(player, connector);
        this.gridStartX = 15;
        this.gridStartY = 22;
        this.gridHeight = 19;
        this.gridPerPage = 7;
        this.elementHeight = 18;
        this.elementWidth = 146;
        PacketHandler.network.sendToServer((IMessage)new PacketNetworkUpdateRequest.UpdateRequestMessage(this.network.getNetworkID(), NBTType.NETWORK_CONNECTIONS));
    }

    @Override
    public EnumNavigationTabs getNavigationTab() {
        return EnumNavigationTabs.TAB_CONNECTION;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.configureNavigationButtons(EnumNavigationTabs.TAB_CONNECTION, this.navigationTabs);
        this.editButtons.clear();
        this.buttonLists.add(this.editButtons);
        if (this.networkValid) {
            this.clear = new BatchEditButton(118, 8, 0, FluxTranslate.BATCH_CLEAR_BUTTON.t()).setUnclickable();
            this.edit = new BatchEditButton(132, 8, 1, FluxTranslate.BATCH_EDIT_BUTTON.t()).setUnclickable();
            this.disconnect = new BatchEditButton(146, 8, 2, FluxTranslate.BATCH_DISCONNECT_BUTTON.t()).setUnclickable();
            this.editButtons.add(this.clear);
            this.editButtons.add(this.edit);
            this.editButtons.add(this.disconnect);
        }
    }

    @Override
    protected void onElementClicked(IFluxConnector element, int mouseButton) {
        if (mouseButton == 0 && this.batchConnections.size() == 0 && element.isChunkLoaded()) {
            this.singleConnection = element;
            this.openPopUp(new GuiPopConnectionEdit(this, false, this.player, this.connector));
        }
        if (mouseButton == 1 || mouseButton == 0 && this.batchConnections.size() > 0) {
            if (this.batchConnections.contains(element)) {
                this.batchConnections.remove(element);
                if (this.batchConnections.size() <= 0) {
                    this.clear.clickable = false;
                    this.edit.clickable = false;
                    this.disconnect.clickable = false;
                }
            } else if (element.isChunkLoaded()) {
                this.batchConnections.add(element);
                this.clear.clickable = true;
                this.edit.clickable = true;
                this.disconnect.clickable = true;
            }
        }
    }

    @Override
    protected void drawForegroundLayer(int mouseX, int mouseY) {
        if (this.networkValid) {
            if (this.batchConnections.size() > 0) {
                this.field_146289_q.func_78276_b(FluxTranslate.SELECTED.t() + ": " + TextFormatting.AQUA + this.batchConnections.size(), 20, 10, 0xFFFFFF);
            } else {
                this.field_146289_q.func_78276_b(FluxTranslate.SORT_BY.t() + ": " + TextFormatting.AQUA + FluxTranslate.SORTING_SMART.t(), 19, 10, 0xFFFFFF);
            }
            super.drawForegroundLayer(mouseX, mouseY);
            if (!this.hasActivePopup()) {
                this.func_73732_a(this.field_146289_q, TextFormatting.RED + FluxNetworks.proxy.getFeedback(false).getInfo(), 88, 165, 0xFFFFFF);
            }
        } else {
            super.drawForegroundLayer(mouseX, mouseY);
            this.renderNavigationPrompt(FluxTranslate.ERROR_NO_SELECTED.t(), FluxTranslate.TAB_SELECTION.t());
        }
    }

    @Override
    public void renderElement(IFluxConnector element, int x, int y) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(GuiDraw.GUI_BAR);
        int fontColor = 0xFFFFFF;
        int color = element.getConnectionType().color;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        if (this.batchConnections.size() > 0) {
            if (this.batchConnections.contains(element)) {
                GuiTabConnections.func_73734_a((int)(x - 5), (int)(y + 1), (int)(x - 3), (int)(y + this.elementHeight - 1), (int)-855638017);
                GuiTabConnections.func_73734_a((int)(x + this.elementWidth + 3), (int)(y + 1), (int)(x + this.elementWidth + 5), (int)(y + this.elementHeight - 1), (int)-855638017);
                GlStateManager.func_179124_c((float)f, (float)f1, (float)f2);
                this.func_73729_b(x, y, 0, 32, this.elementWidth, this.elementHeight);
            } else {
                GuiTabConnections.func_73734_a((int)(x - 5), (int)(y + 1), (int)(x - 3), (int)(y + this.elementHeight - 1), (int)-1436524448);
                GuiTabConnections.func_73734_a((int)(x + this.elementWidth + 3), (int)(y + 1), (int)(x + this.elementWidth + 5), (int)(y + this.elementHeight - 1), (int)-1436524448);
                GlStateManager.func_179124_c((float)(f * 0.5f), (float)(f1 * 0.5f), (float)(f2 * 0.5f));
                this.func_73729_b(x, y, 0, 32, this.elementWidth, this.elementHeight);
                fontColor = 0xD0D0D0;
            }
        } else {
            GlStateManager.func_179124_c((float)f, (float)f1, (float)f2);
            this.func_73729_b(x, y, 0, 32, this.elementWidth, this.elementHeight);
        }
        this.renderItemStack(element.getDisplayStack(), x + 2, y + 1);
        if (element.isChunkLoaded()) {
            this.field_146289_q.func_78276_b(element.getCustomName(), x + 21, y + 2, fontColor);
            GlStateManager.func_179139_a((double)0.625, (double)0.625, (double)0.625);
            this.field_146289_q.func_78276_b(FluxUtils.getTransferInfo(element.getConnectionType(), this.network.getSetting(NetworkSettings.NETWORK_ENERGY), element.getChange()), (int)((double)(x + 21) * 1.6), (int)((double)(y + 11) * 1.6), fontColor);
            GlStateManager.func_179139_a((double)1.6, (double)1.6, (double)1.6);
        } else {
            this.field_146289_q.func_78276_b(element.getCustomName(), x + 21, y + 5, 0x808080);
        }
        GlStateManager.func_179121_F();
    }

    @Override
    public void renderElementTooltip(IFluxConnector element, int mouseX, int mouseY) {
        if (!this.hasActivePopup()) {
            GlStateManager.func_179094_E();
            this.drawHoverTooltip(this.getFluxInfo(element), mouseX + 4, mouseY - 16);
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public void onButtonClicked(GuiButtonCore button, int mouseX, int mouseY, int mouseButton) {
        super.onButtonClicked(button, mouseX, mouseY, mouseButton);
        if (button instanceof BatchEditButton) {
            switch (button.id) {
                case 0: {
                    this.batchConnections.clear();
                    this.clear.clickable = false;
                    this.edit.clickable = false;
                    this.disconnect.clickable = false;
                    break;
                }
                case 1: {
                    this.openPopUp(new GuiPopConnectionEdit(this, true, this.player, this.connector));
                    break;
                }
                case 2: {
                    List<Coord4D> list = this.batchConnections.stream().map(IFluxConnector::getCoords).collect(Collectors.toList());
                    boolean[] b = new boolean[]{false, false, false, false, false, false, true};
                    PacketHandler.network.sendToServer((IMessage)new PacketBatchEditing.BatchEditingMessage(this.network.getNetworkID(), list, new NBTTagCompound(), b));
                }
            }
        }
    }

    @Override
    public void func_73876_c() {
        if (!this.networkValid) {
            return;
        }
        if (this.timer == 4) {
            this.refreshPages(this.network.getSetting(NetworkSettings.ALL_CONNECTORS));
        }
        if (this.timer % 5 == 0) {
            PacketHandler.network.sendToServer((IMessage)new PacketConnectionUpdateRequest.ConnectionRequestMessage(this.network.getNetworkID(), this.current.stream().map(IFluxConnector::getCoords).collect(Collectors.toList())));
        }
        ++this.timer;
        this.timer %= 20;
        if (FluxNetworks.proxy.getFeedback(true) == FeedbackInfo.SUCCESS) {
            this.closePopUp();
            this.batchConnections.clear();
            this.clear.clickable = false;
            this.edit.clickable = false;
            this.disconnect.clickable = false;
            this.refreshPages(this.network.getSetting(NetworkSettings.ALL_CONNECTORS));
        }
        if (FluxNetworks.proxy.getFeedback(true) == FeedbackInfo.SUCCESS_2) {
            this.closePopUp();
            this.elements.removeAll(this.batchConnections);
            this.batchConnections.clear();
            this.clear.clickable = false;
            this.edit.clickable = false;
            this.disconnect.clickable = false;
            this.refreshPages(this.network.getSetting(NetworkSettings.ALL_CONNECTORS));
            if (this.connector instanceof IFluxConnector && this.elements.stream().noneMatch(f -> f.getCoords().equals(((IFluxConnector)this.connector).getCoords()))) {
                FMLCommonHandler.instance().showGuiScreen((Object)new GuiTabSelection(this.player, this.connector));
            }
            this.page = Math.min(this.page, this.pages);
        }
    }

    @Override
    protected void sortGrids(GuiTabPages.SortType sortType) {
        this.elements.sort(Comparator.comparing(IFluxConnector::isChunkLoaded).reversed().thenComparing(f -> f.getConnectionType().isStorage()).thenComparing(f -> f.getConnectionType().canAddEnergy()).thenComparing(f -> f.getConnectionType().canRemoveEnergy()).thenComparing(p -> -p.getPriority()));
        this.refreshCurrentPageInternal();
    }
}

