/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.client.gui.tab;

import com.google.common.collect.Lists;
import fluxnetworks.FluxTranslate;
import fluxnetworks.api.EnergyType;
import fluxnetworks.api.EnumNavigationTabs;
import fluxnetworks.api.INetworkConnector;
import fluxnetworks.api.SecurityType;
import fluxnetworks.client.gui.basic.GuiButtonCore;
import fluxnetworks.client.gui.basic.GuiTabCore;
import fluxnetworks.client.gui.button.ColorButton;
import fluxnetworks.client.gui.button.TextboxButton;
import fluxnetworks.client.gui.popups.GuiPopCore;
import fluxnetworks.client.gui.popups.GuiPopCustomColour;
import fluxnetworks.common.core.FluxUtils;
import java.io.IOException;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.TextFormatting;

public abstract class GuiTabEditAbstract
extends GuiTabCore {
    protected List<ColorButton> colorButtons = Lists.newArrayList();
    protected SecurityType securityType;
    public EnergyType energyType;
    public ColorButton color;
    public TextboxButton name;
    public TextboxButton password;

    public GuiTabEditAbstract(EntityPlayer player, INetworkConnector connector) {
        super(player, connector);
    }

    public abstract void onEditSettingsChanged();

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.colorButtons.clear();
        this.buttonLists.add(this.colorButtons);
        this.configureNavigationButtons(this.getNavigationTab(), this.navigationTabs);
        if (this.networkValid || this.getNavigationTab() == EnumNavigationTabs.TAB_CREATE) {
            int l = this.field_146289_q.func_78256_a(FluxTranslate.NETWORK_NAME.t());
            this.name = TextboxButton.create(this, "", 1, this.field_146289_q, 20 + l, 28, 140 - l, 12);
            this.name.setMaxStringLength(24);
            l = this.field_146289_q.func_78256_a(FluxTranslate.NETWORK_PASSWORD.t());
            this.password = TextboxButton.create(this, "", 2, this.field_146289_q, 20 + l, 62, 140 - l, 12).setTextInvisible();
            this.password.setMaxStringLength(16);
            this.textBoxes.add(this.name);
            this.textBoxes.add(this.password);
        }
    }

    @Override
    protected void drawForegroundLayer(int mouseX, int mouseY) {
        super.drawForegroundLayer(mouseX, mouseY);
        if (this.getNavigationTab() == EnumNavigationTabs.TAB_CREATE || this.networkValid) {
            this.func_73732_a(this.field_146289_q, this.getNavigationTab().getTranslatedName(), 88, 10, 0xB4B4B4);
            this.field_146289_q.func_78276_b(FluxTranslate.NETWORK_NAME.t() + ":", 14, 30, 0x606060);
            this.field_146289_q.func_78276_b(FluxTranslate.NETWORK_SECURITY.t() + ": " + TextFormatting.AQUA + this.securityType.getName(), 14, 50, 0x606060);
            if (this.securityType == SecurityType.ENCRYPTED) {
                this.field_146289_q.func_78276_b(FluxTranslate.NETWORK_PASSWORD.t() + ": ", 14, 64, 0x606060);
            }
            this.field_146289_q.func_78276_b(FluxTranslate.NETWORK_ENERGY.t() + ": " + TextFormatting.AQUA + this.energyType.getName(), 14, 78, 0x606060);
            this.field_146289_q.func_78276_b(FluxTranslate.NETWORK_COLOR.t() + ":", 14, 97, 0x606060);
        }
    }

    @Override
    public void mouseMainClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.mouseMainClicked(mouseX, mouseY, mouseButton);
        if (mouseButton == 0) {
            if (mouseX > this.field_147003_i + 50 && mouseX < this.field_147003_i + 150 && mouseY > this.field_147009_r + 48 && mouseY < this.getGuiTop() + 60) {
                this.securityType = (SecurityType)FluxUtils.incrementEnum((Enum)this.securityType, (Enum[])SecurityType.values());
                this.password.setText("");
                this.password.setVisible(!this.password.getVisible());
                this.onEditSettingsChanged();
            }
            if (mouseX > this.field_147003_i + 50 && mouseX < this.field_147003_i + 150 && mouseY > this.field_147009_r + 76 && mouseY < this.getGuiTop() + 88) {
                this.energyType = (EnergyType)FluxUtils.incrementEnum((Enum)this.energyType, (Enum[])EnergyType.values());
                this.onEditSettingsChanged();
            }
        }
    }

    @Override
    public void onButtonClicked(GuiButtonCore button, int mouseX, int mouseY, int mouseButton) {
        super.onButtonClicked(button, mouseX, mouseY, mouseButton);
        if (button instanceof ColorButton) {
            this.color.selected = false;
            this.color = (ColorButton)button;
            this.color.selected = true;
            this.onEditSettingsChanged();
            if (mouseButton == 1) {
                this.openPopUp(new GuiPopCustomColour(this, this.color.color, this.player, this.connector));
            }
        }
    }

    @Override
    public void onPopUpClose(GuiPopCore popUp) {
        super.onPopUpClose(popUp);
        if (popUp instanceof GuiPopCustomColour) {
            this.color.color = ((GuiPopCustomColour)popUp).currentColour;
        }
    }

    @Override
    protected void keyTypedMain(char c, int k) throws IOException {
        super.keyTypedMain(c, k);
        this.onEditSettingsChanged();
    }
}

