/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.client.gui.tab;

import fluxnetworks.FluxNetworks;
import fluxnetworks.FluxTranslate;
import fluxnetworks.api.EnumNavigationTabs;
import fluxnetworks.api.FeedbackInfo;
import fluxnetworks.api.INetworkConnector;
import fluxnetworks.client.gui.basic.GuiDraw;
import fluxnetworks.client.gui.basic.GuiTabPages;
import fluxnetworks.client.gui.popups.GuiPopUserEdit;
import fluxnetworks.common.connection.NetworkMember;
import fluxnetworks.common.connection.NetworkSettings;
import fluxnetworks.common.core.NBTType;
import fluxnetworks.common.handler.PacketHandler;
import fluxnetworks.common.network.PacketNetworkUpdateRequest;
import fluxnetworks.common.network.PacketPermissionRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Optional;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiTabMembers
extends GuiTabPages<NetworkMember> {
    public NetworkMember selectedPlayer;
    private int timer;

    public GuiTabMembers(EntityPlayer player, INetworkConnector connector) {
        super(player, connector);
        this.gridStartX = 15;
        this.gridStartY = 22;
        this.gridHeight = 13;
        this.gridPerPage = 10;
        this.elementHeight = 12;
        this.elementWidth = 146;
        PacketHandler.network.sendToServer((IMessage)new PacketNetworkUpdateRequest.UpdateRequestMessage(this.network.getNetworkID(), NBTType.NETWORK_PLAYERS));
    }

    @Override
    public EnumNavigationTabs getNavigationTab() {
        return EnumNavigationTabs.TAB_MEMBER;
    }

    @Override
    protected void drawForegroundLayer(int mouseX, int mouseY) {
        if (this.networkValid) {
            String str2 = this.accessPermission.getName();
            this.field_146289_q.func_78276_b(str2, 158 - this.field_146289_q.func_78256_a(str2), 10, 0xFFFFFF);
            this.field_146289_q.func_78276_b(FluxTranslate.SORT_BY.t() + ": " + TextFormatting.AQUA + FluxTranslate.SORTING_SMART.t(), 19, 10, 0xFFFFFF);
            super.drawForegroundLayer(mouseX, mouseY);
        } else {
            super.drawForegroundLayer(mouseX, mouseY);
            this.renderNavigationPrompt(FluxTranslate.ERROR_NO_SELECTED.t(), FluxTranslate.TAB_SELECTION.t());
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.configureNavigationButtons(EnumNavigationTabs.TAB_MEMBER, this.navigationTabs);
    }

    @Override
    protected void onElementClicked(NetworkMember element, int mouseButton) {
        if (mouseButton == 0) {
            this.selectedPlayer = element;
            this.openPopUp(new GuiPopUserEdit(this, this.player, this.connector));
        }
    }

    @Override
    public void renderElement(NetworkMember element, int x, int y) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        int color = element.getAccessPermission().color;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)f, (float)f1, (float)f2, (float)0.8f);
        this.field_146297_k.func_110434_K().func_110577_a(GuiDraw.GUI_BAR);
        this.func_73729_b(x, y, 0, 16, this.elementWidth, this.elementHeight);
        if (element.getPlayerUUID().equals(this.player.func_110124_au())) {
            GuiTabMembers.func_73734_a((int)(x - 4), (int)(y + 1), (int)(x - 2), (int)(y + this.elementHeight - 1), (int)-855638017);
            GuiTabMembers.func_73734_a((int)(x + this.elementWidth + 2), (int)(y + 1), (int)(x + this.elementWidth + 4), (int)(y + this.elementHeight - 1), (int)-855638017);
        }
        this.field_146289_q.func_78276_b(TextFormatting.WHITE + element.getCachedName(), x + 4, y + 2, 0xFFFFFF);
        String p = element.getAccessPermission().getName();
        this.field_146289_q.func_78276_b(p, x + 142 - this.field_146289_q.func_78256_a(p), y + 2, 0xFFFFFF);
        GlStateManager.func_179121_F();
    }

    @Override
    public void renderElementTooltip(NetworkMember element, int mouseX, int mouseY) {
        if (this.hasActivePopup()) {
            return;
        }
        GlStateManager.func_179094_E();
        ArrayList<String> strings = new ArrayList<String>();
        strings.add(FluxTranslate.USERNAME.t() + ": " + TextFormatting.AQUA + element.getCachedName());
        String permission = element.getAccessPermission().getName() + (element.getPlayerUUID().equals(this.player.func_110124_au()) ? " (" + FluxTranslate.YOU.t() + ")" : "");
        strings.add(FluxTranslate.ACCESS.t() + ": " + TextFormatting.RESET + permission);
        this.drawHoverTooltip(strings, mouseX + 4, mouseY - 8);
        GlStateManager.func_179121_F();
    }

    @Override
    public void mouseMainClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.mouseMainClicked(mouseX, mouseY, mouseButton);
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        if (this.timer == 0) {
            PacketHandler.network.sendToServer((IMessage)new PacketPermissionRequest.PermissionRequestMessage(this.network.getNetworkID(), this.player.func_110124_au()));
        }
        if (this.timer % 2 == 0) {
            this.refreshPages(this.network.getSetting(NetworkSettings.NETWORK_PLAYERS));
            if (FluxNetworks.proxy.getFeedback(true) == FeedbackInfo.SUCCESS) {
                if (this.hasActivePopup()) {
                    Optional<NetworkMember> n = this.elements.stream().filter(f -> f.getPlayerUUID().equals(this.selectedPlayer.getPlayerUUID())).findFirst();
                    if (n.isPresent()) {
                        this.selectedPlayer = n.get();
                        this.openPopUp(new GuiPopUserEdit(this, this.player, this.connector));
                    } else {
                        this.closePopUp();
                    }
                }
                FluxNetworks.proxy.setFeedback(FeedbackInfo.NONE, true);
            }
        }
        ++this.timer;
        this.timer %= 40;
    }

    @Override
    protected void sortGrids(GuiTabPages.SortType sortType) {
        this.elements.sort(Comparator.comparing(NetworkMember::getAccessPermission).thenComparing(NetworkMember::getCachedName));
        this.refreshCurrentPageInternal();
    }
}

