/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.client.gui.tab;

import fluxnetworks.FluxNetworks;
import fluxnetworks.FluxTranslate;
import fluxnetworks.api.EnumNavigationTabs;
import fluxnetworks.api.FeedbackInfo;
import fluxnetworks.api.INetworkConnector;
import fluxnetworks.api.network.IFluxNetwork;
import fluxnetworks.client.gui.basic.GuiDraw;
import fluxnetworks.client.gui.basic.GuiTabPages;
import fluxnetworks.client.gui.popups.GuiPopNetworkPassword;
import fluxnetworks.common.connection.FluxNetworkCache;
import fluxnetworks.common.connection.NetworkSettings;
import fluxnetworks.common.core.FluxUtils;
import fluxnetworks.common.item.ItemConfigurator;
import java.io.IOException;
import java.util.Comparator;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.TextFormatting;

public class GuiTabSelection
extends GuiTabPages<IFluxNetwork> {
    public IFluxNetwork selectedNetwork;
    protected int timer2;

    public GuiTabSelection(EntityPlayer player, INetworkConnector connector) {
        super(player, connector);
        this.gridStartX = 15;
        this.gridStartY = 22;
        this.gridHeight = 13;
        this.gridPerPage = 10;
        this.elementHeight = 12;
        this.elementWidth = 146;
    }

    @Override
    public EnumNavigationTabs getNavigationTab() {
        return EnumNavigationTabs.TAB_SELECTION;
    }

    @Override
    protected void drawForegroundLayer(int mouseX, int mouseY) {
        super.drawForegroundLayer(mouseX, mouseY);
        if (this.elements.size() == 0) {
            this.renderNavigationPrompt(FluxTranslate.ERROR_NO_NETWORK.t(), FluxTranslate.TAB_CREATE.t());
        } else {
            String amount = FluxTranslate.TOTAL.t() + ": " + this.elements.size();
            this.field_146289_q.func_78276_b(amount, 158 - this.field_146289_q.func_78256_a(amount), 10, 0xFFFFFF);
            this.field_146289_q.func_78276_b(FluxTranslate.SORT_BY.t() + ": " + TextFormatting.AQUA + this.sortType.getTranslatedName(), 19, 10, 0xFFFFFF);
            if (!this.hasActivePopup()) {
                this.func_73732_a(this.field_146289_q, TextFormatting.RED + FluxNetworks.proxy.getFeedback(false).getInfo(), 88, 150, 0xFFFFFF);
            }
        }
    }

    @Override
    protected void onElementClicked(IFluxNetwork element, int mouseButton) {
        if (mouseButton == 0) {
            this.selectedNetwork = element;
            this.setConnectedNetwork(element.getNetworkID(), "");
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.configureNavigationButtons(EnumNavigationTabs.TAB_SELECTION, this.navigationTabs);
    }

    @Override
    public void renderElement(IFluxNetwork element, int x, int y) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(GuiDraw.GUI_BAR);
        int color = element.getSetting(NetworkSettings.NETWORK_COLOR);
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        boolean selected = this.connector.getNetworkID() == element.getNetworkID();
        boolean isEncrypted = element.getSetting(NetworkSettings.NETWORK_SECURITY).isEncrypted();
        if (isEncrypted) {
            if (selected) {
                this.func_73729_b(x + 131, y, 159, 16, 16, this.elementHeight);
            } else {
                this.func_73729_b(x + 131, y, 175, 16, 16, this.elementHeight);
            }
        }
        String text = element.getSetting(NetworkSettings.NETWORK_NAME);
        if (selected) {
            GlStateManager.func_179124_c((float)f, (float)f1, (float)f2);
            this.func_73729_b(x, y, 0, 16, this.elementWidth, this.elementHeight);
            this.field_146297_k.field_71466_p.func_78276_b(text, x + 4, y + 2, 0xFFFFFF);
        } else {
            GlStateManager.func_179124_c((float)(f * 0.75f), (float)(f1 * 0.75f), (float)(f2 * 0.75f));
            this.func_73729_b(x, y, 0, 16, this.elementWidth, this.elementHeight);
            this.field_146297_k.field_71466_p.func_78276_b(text, x + 4, y + 2, 0x404040);
        }
        GlStateManager.func_179121_F();
    }

    @Override
    public void renderElementTooltip(IFluxNetwork element, int mouseX, int mouseY) {
        if (this.hasActivePopup()) {
            return;
        }
    }

    @Override
    public void mouseMainClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.mouseMainClicked(mouseX, mouseY, mouseButton);
        if (mouseButton == 0 && mouseX > this.field_147003_i + 45 && mouseX < this.field_147003_i + 75 && mouseY > this.field_147009_r + 10 && mouseY < this.getGuiTop() + 17) {
            this.sortType = (GuiTabPages.SortType)FluxUtils.incrementEnum((Enum)this.sortType, (Enum[])GuiTabPages.SortType.values());
            this.sortGrids(this.sortType);
        }
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        if (this.timer2 == 0) {
            this.refreshPages(FluxNetworkCache.instance.getAllClientNetworks());
        }
        if (FluxNetworks.proxy.getFeedback(true) == FeedbackInfo.SUCCESS) {
            this.closePopUp();
            if (this.connector instanceof ItemConfigurator.NetworkConnector) {
                ItemConfigurator.NetworkConnector networkConnector = (ItemConfigurator.NetworkConnector)this.connector;
                networkConnector.network = this.selectedNetwork;
                networkConnector.networkID = this.selectedNetwork.getNetworkID();
                this.network = this.selectedNetwork;
                boolean bl = this.networkValid = !this.selectedNetwork.isInvalid();
            }
        }
        if (FluxNetworks.proxy.getFeedback(true) == FeedbackInfo.PASSWORD_REQUIRE) {
            this.openPopUp(new GuiPopNetworkPassword(this, this.player, this.connector));
            FluxNetworks.proxy.setFeedback(FeedbackInfo.NONE, true);
        }
        ++this.timer2;
        this.timer2 %= 10;
    }

    @Override
    protected void sortGrids(GuiTabPages.SortType sortType) {
        switch (sortType) {
            case ID: {
                this.elements.sort(Comparator.comparing(IFluxNetwork::getNetworkID));
                this.refreshCurrentPageInternal();
                break;
            }
            case NAME: {
                this.elements.sort(Comparator.comparing(IFluxNetwork::getNetworkName));
                this.refreshCurrentPageInternal();
            }
        }
    }
}

