/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.client.gui.tab;

import fluxnetworks.FluxNetworks;
import fluxnetworks.FluxTranslate;
import fluxnetworks.api.EnumNavigationTabs;
import fluxnetworks.api.FeedbackInfo;
import fluxnetworks.api.INetworkConnector;
import fluxnetworks.api.NetworkColor;
import fluxnetworks.client.gui.basic.GuiButtonCore;
import fluxnetworks.client.gui.button.ColorButton;
import fluxnetworks.client.gui.button.NormalButton;
import fluxnetworks.client.gui.tab.GuiTabEditAbstract;
import fluxnetworks.common.connection.NetworkSettings;
import fluxnetworks.common.handler.PacketHandler;
import fluxnetworks.common.network.PacketGeneral;
import fluxnetworks.common.network.PacketGeneralHandler;
import fluxnetworks.common.network.PacketGeneralType;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiTabSettings
extends GuiTabEditAbstract {
    public NormalButton apply;
    public NormalButton delete;
    public int deleteCount;

    public GuiTabSettings(EntityPlayer player, INetworkConnector connector) {
        super(player, connector);
        if (this.networkValid) {
            this.securityType = this.network.getSetting(NetworkSettings.NETWORK_SECURITY);
            this.energyType = this.network.getSetting(NetworkSettings.NETWORK_ENERGY);
        }
    }

    @Override
    public EnumNavigationTabs getNavigationTab() {
        return EnumNavigationTabs.TAB_SETTING;
    }

    @Override
    protected void drawForegroundLayer(int mouseX, int mouseY) {
        super.drawForegroundLayer(mouseX, mouseY);
        if (this.getNavigationTab() == EnumNavigationTabs.TAB_CREATE || this.networkValid) {
            if (mouseX > 30 + this.field_147003_i && mouseX < 66 + this.field_147003_i && mouseY > 140 + this.field_147009_r && mouseY < 152 + this.field_147009_r) {
                if (this.delete.clickable) {
                    this.func_73732_a(this.field_146289_q, TextFormatting.BOLD + FluxTranslate.DELETE_NETWORK.t(), 48, 128, 0xFF0000);
                } else {
                    this.func_73732_a(this.field_146289_q, FluxTranslate.DOUBLE_SHIFT.t(), 48, 128, 0xFFFFFF);
                }
            }
            this.func_73732_a(this.field_146289_q, TextFormatting.RED + FluxNetworks.proxy.getFeedback(false).getInfo(), 88, 156, 0xFFFFFF);
        } else {
            this.renderNavigationPrompt(FluxTranslate.ERROR_NO_SELECTED.t(), FluxTranslate.TAB_SELECTION.t());
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.networkValid) {
            this.name.setText(this.network.getNetworkName());
            this.password.setText(this.network.getSetting(NetworkSettings.NETWORK_PASSWORD));
            this.password.setVisible(this.network.getSetting(NetworkSettings.NETWORK_SECURITY).isEncrypted());
            this.apply = new NormalButton(FluxTranslate.APPLY.t(), 112, 140, 36, 12, 3).setUnclickable();
            this.buttons.add(this.apply);
            this.delete = new NormalButton(FluxTranslate.DELETE.t(), 30, 140, 36, 12, 4).setUnclickable();
            this.buttons.add(this.delete);
            int i = 0;
            boolean colorSet = false;
            for (NetworkColor color : NetworkColor.values()) {
                ColorButton b = new ColorButton(48 + (i >= 7 ? i - 7 : i) * 16, 96 + (i >= 7 ? 1 : 0) * 16, color.color);
                this.colorButtons.add(b);
                if (!colorSet && color.color == this.network.getSetting(NetworkSettings.NETWORK_COLOR)) {
                    this.color = b;
                    this.color.selected = true;
                    colorSet = true;
                }
                ++i;
            }
            if (!colorSet) {
                ColorButton c = new ColorButton(this.field_146294_l / 2 - 56, this.field_146295_m / 2 + 29, this.network.getSetting(NetworkSettings.NETWORK_COLOR));
                this.colorButtons.add(c);
                this.color = c;
                this.color.selected = true;
            }
        }
    }

    @Override
    public void onEditSettingsChanged() {
        if (this.networkValid) {
            this.apply.clickable = (!this.securityType.isEncrypted() || this.password.getText().length() != 0) && this.name.getText().length() != 0;
        }
    }

    @Override
    public void onButtonClicked(GuiButtonCore button, int mouseX, int mouseY, int mouseButton) {
        super.onButtonClicked(button, mouseX, mouseY, mouseButton);
        if (this.networkValid && button instanceof NormalButton) {
            switch (button.id) {
                case 3: {
                    PacketHandler.network.sendToServer((IMessage)new PacketGeneral.GeneralMessage(PacketGeneralType.EDIT_NETWORK, PacketGeneralHandler.getNetworkEditPacket(this.network.getNetworkID(), this.name.getText(), this.color.color, this.securityType, this.energyType, this.password.getText())));
                    break;
                }
                case 4: {
                    PacketHandler.network.sendToServer((IMessage)new PacketGeneral.GeneralMessage(PacketGeneralType.DELETE_NETWORK, PacketGeneralHandler.getDeleteNetworkPacket(this.connector.getNetworkID())));
                }
            }
        }
    }

    @Override
    protected void keyTypedMain(char c, int k) throws IOException {
        super.keyTypedMain(c, k);
        if (this.delete != null) {
            if (k == 42) {
                ++this.deleteCount;
                if (this.deleteCount > 1) {
                    this.delete.clickable = true;
                }
            } else {
                this.deleteCount = 0;
                this.delete.clickable = false;
            }
        }
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        if (FluxNetworks.proxy.getFeedback(true) == FeedbackInfo.SUCCESS) {
            GuiTabSettings.switchTab(EnumNavigationTabs.TAB_HOME, this.player, this.connector);
            FluxNetworks.proxy.setFeedback(FeedbackInfo.NONE, true);
        }
        if (FluxNetworks.proxy.getFeedback(true) == FeedbackInfo.SUCCESS_2) {
            this.apply.clickable = false;
            FluxNetworks.proxy.setFeedback(FeedbackInfo.NONE, true);
        }
    }
}

