/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.common;

import com.google.common.collect.Lists;
import fluxnetworks.FluxConfig;
import fluxnetworks.FluxNetworks;
import fluxnetworks.api.FeedbackInfo;
import fluxnetworks.api.network.IFluxNetwork;
import fluxnetworks.common.capabilities.DefaultSuperAdmin;
import fluxnetworks.common.connection.FluxNetworkCache;
import fluxnetworks.common.connection.FluxNetworkInvalid;
import fluxnetworks.common.core.EntityFireItem;
import fluxnetworks.common.core.NBTType;
import fluxnetworks.common.data.FluxChunkManager;
import fluxnetworks.common.event.FluxConnectionEvent;
import fluxnetworks.common.handler.CapabilityHandler;
import fluxnetworks.common.handler.PacketHandler;
import fluxnetworks.common.handler.TileEntityHandler;
import fluxnetworks.common.integration.MekanismIntegration;
import fluxnetworks.common.integration.TOPIntegration;
import fluxnetworks.common.integration.oc.OCIntegration;
import fluxnetworks.common.network.PacketNetworkUpdate;
import fluxnetworks.common.network.PacketSuperAdmin;
import fluxnetworks.common.registry.RegistryBlocks;
import fluxnetworks.common.registry.RegistryItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class CommonProxy {
    public boolean baublesLoaded;
    public boolean ocLoaded;
    public int admin_viewing_network_id = -1;
    public boolean detailed_network_view;
    public IFluxNetwork admin_viewing_network = FluxNetworkInvalid.instance;
    public static CreativeTabs creativeTabs = new CreativeTabs("fluxnetworks"){

        public ItemStack func_78016_d() {
            return new ItemStack(RegistryBlocks.FLUX_PLUG);
        }
    };

    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        PacketHandler.registerMessages();
        TileEntityHandler.registerEnergyHandler();
        FluxConfig.init(event.getModConfigurationDirectory());
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("fluxnetworks", "Flux"), EntityFireItem.class, (String)"Flux", (int)0, (Object)FluxNetworks.instance, (int)64, (int)10, (boolean)true);
        if (Loader.isModLoaded((String)"mekanism")) {
            MekanismIntegration.preInit();
        }
        this.ocLoaded = Loader.isModLoaded((String)"opencomputers");
        this.baublesLoaded = Loader.isModLoaded((String)"baubles");
    }

    public void init(FMLInitializationEvent event) {
        DefaultSuperAdmin.register();
        FMLInterModComms.sendMessage((String)"carryon", (String)"blacklistBlock", (String)"fluxnetworks:*");
        FMLInterModComms.sendFunctionMessage((String)"theoneprobe", (String)"getTheOneProbe", (String)TOPIntegration.class.getName());
        if (this.ocLoaded) {
            OCIntegration.init();
        }
    }

    public void postInit(FMLPostInitializationEvent event) {
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)FluxNetworks.instance, FluxChunkManager::callback);
        MinecraftForge.EVENT_BUS.register((Object)new CapabilityHandler());
    }

    public void onServerStarted() {
    }

    public void onServerStopped() {
        FluxNetworkCache.instance.clearNetworks();
        FluxChunkManager.clear();
    }

    public void registerItemModel(Item item, int meta, String variant) {
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.LeftClickBlock event) {
        if (event.getSide().isServer()) {
            BlockPos pos;
            if (!FluxConfig.enableFluxRecipe) {
                return;
            }
            World world = event.getWorld();
            if (world.func_180495_p(pos = event.getPos()).func_177230_c().equals(Blocks.field_150343_Z) && world.func_180495_p(pos.func_177979_c(2)).func_177230_c().equals(Blocks.field_150357_h)) {
                List entities = world.func_72872_a(EntityItem.class, new AxisAlignedBB(pos.func_177977_b()));
                if (entities.isEmpty()) {
                    return;
                }
                ArrayList s = Lists.newArrayList();
                AtomicInteger count = new AtomicInteger();
                entities.forEach(e -> {
                    if (e.func_92059_d().func_77973_b().equals(Items.field_151137_ax)) {
                        s.add(e);
                        count.addAndGet(e.func_92059_d().func_190916_E());
                    }
                });
                if (s.isEmpty()) {
                    return;
                }
                ItemStack stack = new ItemStack(RegistryItems.FLUX, count.getAndIncrement());
                s.forEach(Entity::func_70106_y);
                world.func_175698_g(pos);
                world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, stack));
                world.func_175656_a(pos.func_177977_b(), Blocks.field_150343_Z.func_176223_P());
                world.func_184133_a(null, pos, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            for (IFluxNetwork network : FluxNetworkCache.instance.getAllNetworks()) {
                network.onStartServerTick();
            }
        }
        if (event.phase == TickEvent.Phase.END) {
            for (IFluxNetwork network : FluxNetworkCache.instance.getAllNetworks()) {
                network.onEndServerTick();
            }
        }
    }

    @SubscribeEvent
    public void onPlayerJoined(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        if (!player.field_70170_p.field_72995_K) {
            PacketHandler.network.sendTo((IMessage)new PacketNetworkUpdate.NetworkUpdateMessage(FluxNetworkCache.instance.getAllNetworks(), NBTType.NETWORK_GENERAL), (EntityPlayerMP)player);
            PacketHandler.network.sendTo((IMessage)new PacketSuperAdmin.SuperAdminMessage(DefaultSuperAdmin.isPlayerSuperAdmin(player)), (EntityPlayerMP)player);
        }
    }

    @SubscribeEvent
    public void onFluxConnected(FluxConnectionEvent.Connected event) {
        if (!event.flux.getDimension().field_72995_K) {
            event.flux.connect(event.network);
        }
    }

    @SubscribeEvent
    public void onFluxDisconnect(FluxConnectionEvent.Disconnected event) {
        if (!event.flux.getDimension().field_72995_K) {
            event.flux.disconnect(event.network);
        }
    }

    public FeedbackInfo getFeedback(boolean operation) {
        return null;
    }

    public void setFeedback(FeedbackInfo info, boolean operation) {
    }

    public void receiveColorCache(Map<Integer, Tuple<Integer, String>> cache) {
    }

    public EntityPlayer getPlayer(MessageContext ctx) {
        return ctx.getServerHandler().field_147369_b;
    }
}

