/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.common.connection;

import fluxnetworks.api.ConnectionType;
import fluxnetworks.api.Coord4D;
import fluxnetworks.api.network.IFluxNetwork;
import fluxnetworks.api.network.ITransferHandler;
import fluxnetworks.api.tileentity.IFluxConnector;
import fluxnetworks.common.connection.FluxNetworkInvalid;
import fluxnetworks.common.core.NBTType;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class FluxLiteConnector
implements IFluxConnector {
    public int networkID;
    public int priority;
    public UUID playerUUID;
    public ConnectionType connectionType;
    public long limit;
    public Coord4D coord4D;
    public int folderID;
    public String customName;
    public boolean surgeMode;
    public boolean disableLimit;
    public boolean isChunkLoaded;
    public boolean chunkLoading;
    public long buffer;
    public long change;
    public ItemStack stack;

    public FluxLiteConnector(IFluxConnector tile) {
        this.networkID = tile.getNetworkID();
        this.priority = tile.getActualPriority();
        this.playerUUID = tile.getConnectionOwner();
        this.connectionType = tile.getConnectionType();
        this.limit = tile.getActualLimit();
        this.coord4D = tile.getCoords();
        this.folderID = tile.getFolderID();
        this.customName = tile.getCustomName();
        this.surgeMode = tile.getSurgeMode();
        this.disableLimit = tile.getDisableLimit();
        this.isChunkLoaded = tile.isChunkLoaded();
        this.buffer = tile.getTransferHandler().getBuffer();
        this.change = tile.getTransferHandler().getChange();
        this.chunkLoading = tile.isForcedLoading();
        this.stack = tile.getDisplayStack();
    }

    public FluxLiteConnector(NBTTagCompound tag) {
        this.readCustomNBT(tag, NBTType.ALL_SAVE);
    }

    public static NBTTagCompound writeCustomNBT(IFluxConnector tile, NBTTagCompound tag) {
        tile.getCoords().write(tag);
        tag.func_74768_a("type", tile.getConnectionType().ordinal());
        tag.func_74768_a("n_id", tile.getNetworkID());
        tag.func_74768_a("priority", tile.getActualPriority());
        tag.func_74768_a("folder_id", tile.getFolderID());
        tag.func_74772_a("limit", tile.getActualLimit());
        tag.func_74778_a("name", tile.getCustomName());
        tag.func_74757_a("dLimit", tile.getDisableLimit());
        tag.func_74757_a("surge", tile.getSurgeMode());
        tag.func_74757_a("isChunkLoaded", tile.isChunkLoaded());
        tag.func_74772_a("buffer", tile.getBuffer());
        tag.func_74772_a("change", tile.getChange());
        tag.func_74757_a("forcedChunk", tile.isForcedLoading());
        tile.getDisplayStack().func_77955_b(tag);
        return tag;
    }

    @Override
    public NBTTagCompound writeCustomNBT(NBTTagCompound tag, NBTType type) {
        this.coord4D.write(tag);
        tag.func_74768_a("type", this.connectionType.ordinal());
        tag.func_74768_a("n_id", this.networkID);
        tag.func_74768_a("priority", this.priority);
        tag.func_74768_a("folder_id", this.folderID);
        tag.func_74772_a("limit", this.limit);
        tag.func_74778_a("name", this.customName);
        tag.func_74757_a("dLimit", this.disableLimit);
        tag.func_74757_a("surge", this.surgeMode);
        tag.func_74757_a("isChunkLoaded", this.isChunkLoaded);
        tag.func_74772_a("buffer", this.buffer);
        tag.func_74772_a("change", this.change);
        tag.func_74757_a("forcedChunk", this.chunkLoading);
        this.stack.func_77955_b(tag);
        return tag;
    }

    @Override
    public void readCustomNBT(NBTTagCompound tag, NBTType type) {
        this.coord4D = new Coord4D(tag);
        this.connectionType = ConnectionType.values()[tag.func_74762_e("type")];
        this.networkID = tag.func_74762_e("n_id");
        this.priority = tag.func_74762_e("priority");
        this.folderID = tag.func_74762_e("folder_id");
        this.limit = tag.func_74763_f("limit");
        this.customName = tag.func_74779_i("name");
        this.disableLimit = tag.func_74767_n("dLimit");
        this.surgeMode = tag.func_74767_n("surge");
        this.isChunkLoaded = tag.func_74767_n("isChunkLoaded");
        this.buffer = tag.func_74763_f("buffer");
        this.change = tag.func_74763_f("change");
        this.chunkLoading = tag.func_74767_n("forcedChunk");
        this.stack = new ItemStack(tag);
    }

    @Override
    public int getNetworkID() {
        return this.networkID;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public int getActualPriority() {
        return this.priority;
    }

    @Override
    public IFluxNetwork getNetwork() {
        return FluxNetworkInvalid.instance;
    }

    @Override
    public void open(EntityPlayer player) {
    }

    @Override
    public void close(EntityPlayer player) {
    }

    @Override
    public UUID getConnectionOwner() {
        return this.playerUUID;
    }

    @Override
    public ConnectionType getConnectionType() {
        return this.connectionType;
    }

    @Override
    public boolean canAccess(EntityPlayer player) {
        return false;
    }

    @Override
    public boolean isChunkLoaded() {
        return this.isChunkLoaded;
    }

    @Override
    public boolean isForcedLoading() {
        return this.chunkLoading;
    }

    @Override
    public void connect(IFluxNetwork network) {
    }

    @Override
    public void disconnect(IFluxNetwork network) {
    }

    @Override
    public ITransferHandler getTransferHandler() {
        return null;
    }

    @Override
    public World getDimension() {
        return null;
    }

    @Override
    public long getCurrentLimit() {
        return this.limit;
    }

    @Override
    public long getActualLimit() {
        return this.limit;
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    public Coord4D getCoords() {
        return this.coord4D;
    }

    @Override
    public int getFolderID() {
        return this.folderID;
    }

    @Override
    public String getCustomName() {
        return this.customName;
    }

    @Override
    public boolean getDisableLimit() {
        return this.disableLimit;
    }

    @Override
    public boolean getSurgeMode() {
        return this.surgeMode;
    }

    @Override
    public ItemStack getDisplayStack() {
        return this.stack;
    }

    @Override
    public long getBuffer() {
        return this.buffer;
    }

    @Override
    public long getChange() {
        return this.change;
    }

    @Override
    public void setChunkLoaded(boolean chunkLoaded) {
        this.isChunkLoaded = chunkLoaded;
    }
}

