/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.common.connection;

import fluxnetworks.api.EnergyType;
import fluxnetworks.api.SecurityType;
import fluxnetworks.api.network.FluxType;
import fluxnetworks.api.network.IFluxNetwork;
import fluxnetworks.api.tileentity.IFluxConnector;
import fluxnetworks.common.connection.FluxLiteConnector;
import fluxnetworks.common.connection.NetworkMember;
import fluxnetworks.common.connection.NetworkSettings;
import fluxnetworks.common.connection.NetworkStatistics;
import fluxnetworks.common.core.CustomValue;
import fluxnetworks.common.core.ICustomValue;
import fluxnetworks.common.core.NBTType;
import fluxnetworks.common.data.FluxNetworkData;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;

public abstract class FluxNetworkBase
implements IFluxNetwork {
    public ICustomValue<Integer> network_id = new CustomValue<Integer>();
    public ICustomValue<String> network_name = new CustomValue<String>();
    public ICustomValue<UUID> network_owner = new CustomValue<UUID>();
    public ICustomValue<SecurityType> network_security = new CustomValue<SecurityType>();
    public ICustomValue<String> network_password = new CustomValue<String>();
    public ICustomValue<Integer> network_color = new CustomValue<Integer>();
    public ICustomValue<EnergyType> network_energy = new CustomValue<EnergyType>();
    public ICustomValue<Integer> network_wireless = new CustomValue<Integer>(0);
    public ICustomValue<NetworkStatistics> network_stats = new CustomValue<NetworkStatistics>(new NetworkStatistics(this));
    public ICustomValue<List<IFluxConnector>> all_connectors = new CustomValue(new ArrayList());
    public ICustomValue<List<NetworkMember>> network_players = new CustomValue(new ArrayList());

    public FluxNetworkBase() {
    }

    public FluxNetworkBase(int id, String name, SecurityType security, int color, UUID owner, EnergyType energy, String password) {
        this.network_id.setValue(id);
        this.network_name.setValue(name);
        this.network_security.setValue(security);
        this.network_color.setValue(color);
        this.network_owner.setValue(owner);
        this.network_energy.setValue(energy);
        this.network_password.setValue(password);
    }

    @Override
    public <T> T getSetting(NetworkSettings<T> setting) {
        return setting.getValue(this).getValue();
    }

    @Override
    public <T> void setSetting(NetworkSettings<T> settings, T value) {
        settings.getValue(this).setValue(value);
    }

    @Override
    public void readNetworkNBT(NBTTagCompound nbt, NBTType type) {
        if (type == NBTType.NETWORK_GENERAL || type == NBTType.ALL_SAVE) {
            this.network_id.setValue(nbt.func_74762_e(FluxNetworkData.NETWORK_ID));
            this.network_name.setValue(nbt.func_74779_i(FluxNetworkData.NETWORK_NAME));
            this.network_owner.setValue(nbt.func_186857_a(FluxNetworkData.OWNER_UUID));
            this.network_security.setValue(SecurityType.values()[nbt.func_74762_e(FluxNetworkData.SECURITY_TYPE)]);
            this.network_password.setValue(nbt.func_74779_i(FluxNetworkData.NETWORK_PASSWORD));
            this.network_color.setValue(nbt.func_74762_e(FluxNetworkData.NETWORK_COLOR));
            this.network_energy.setValue(EnergyType.values()[nbt.func_74762_e(FluxNetworkData.ENERGY_TYPE)]);
            this.network_wireless.setValue(nbt.func_74762_e(FluxNetworkData.WIRELESS_MODE));
            if (type == NBTType.ALL_SAVE) {
                FluxNetworkData.readPlayers(this, nbt);
                FluxNetworkData.readConnections(this, nbt);
            }
        }
        if (type == NBTType.NETWORK_PLAYERS) {
            FluxNetworkData.readPlayers(this, nbt);
        }
        if (type == NBTType.NETWORK_CONNECTIONS) {
            FluxNetworkData.readAllConnections(this, nbt);
        }
        if (type == NBTType.NETWORK_STATISTICS) {
            this.network_stats.getValue().readNBT(nbt);
        }
    }

    @Override
    public NBTTagCompound writeNetworkNBT(NBTTagCompound nbt, NBTType type) {
        if (type == NBTType.NETWORK_GENERAL || type == NBTType.ALL_SAVE) {
            nbt.func_74768_a(FluxNetworkData.NETWORK_ID, this.network_id.getValue().intValue());
            nbt.func_74778_a(FluxNetworkData.NETWORK_NAME, this.network_name.getValue());
            nbt.func_186854_a(FluxNetworkData.OWNER_UUID, this.network_owner.getValue());
            nbt.func_74768_a(FluxNetworkData.SECURITY_TYPE, this.network_security.getValue().ordinal());
            nbt.func_74778_a(FluxNetworkData.NETWORK_PASSWORD, this.network_password.getValue());
            nbt.func_74768_a(FluxNetworkData.NETWORK_COLOR, this.network_color.getValue().intValue());
            nbt.func_74768_a(FluxNetworkData.ENERGY_TYPE, this.network_energy.getValue().ordinal());
            nbt.func_74768_a(FluxNetworkData.WIRELESS_MODE, this.network_wireless.getValue().intValue());
            if (type == NBTType.ALL_SAVE) {
                FluxNetworkData.writePlayers(this, nbt);
                FluxNetworkData.writeConnections(this, nbt);
            }
        }
        if (type == NBTType.NETWORK_PLAYERS) {
            FluxNetworkData.writeAllPlayers(this, nbt);
        }
        if (type == NBTType.NETWORK_CONNECTIONS) {
            this.all_connectors.getValue().removeIf(IFluxConnector::isChunkLoaded);
            List<IFluxConnector> connectors = this.getConnections(FluxType.flux);
            connectors.forEach(f -> this.all_connectors.getValue().add(new FluxLiteConnector((IFluxConnector)f)));
            FluxNetworkData.writeAllConnections(this, nbt);
        }
        if (type == NBTType.NETWORK_STATISTICS) {
            this.network_stats.getValue().writeNBT(nbt);
        }
        if (type == NBTType.NETWORK_CLEAR) {
            nbt.func_74757_a("clear", true);
        }
        return nbt;
    }
}

