/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.common.connection;

import com.mojang.authlib.GameProfile;
import fluxnetworks.FluxConfig;
import fluxnetworks.api.AccessPermission;
import fluxnetworks.api.Coord4D;
import fluxnetworks.api.EnergyType;
import fluxnetworks.api.SecurityType;
import fluxnetworks.api.network.IFluxNetwork;
import fluxnetworks.api.tileentity.IFluxConnector;
import fluxnetworks.common.connection.FluxLiteNetwork;
import fluxnetworks.common.connection.FluxNetworkInvalid;
import fluxnetworks.common.connection.FluxNetworkServer;
import fluxnetworks.common.connection.NetworkMember;
import fluxnetworks.common.connection.NetworkSettings;
import fluxnetworks.common.core.NBTType;
import fluxnetworks.common.data.FluxNetworkData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class FluxNetworkCache {
    public static FluxNetworkCache instance = new FluxNetworkCache();
    public Map<Integer, IFluxNetwork> networks = new HashMap<Integer, IFluxNetwork>();
    public boolean superAdminClient = false;

    public void clearNetworks() {
        FluxNetworkData.clear();
    }

    public void clearClientCache() {
        this.networks.clear();
        this.superAdminClient = false;
    }

    public boolean hasSpaceLeft(EntityPlayer player) {
        if (FluxConfig.maximumPerPlayer == -1) {
            return true;
        }
        UUID uuid = EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH());
        List created = this.getAllNetworks().stream().filter(s -> s.getSetting(NetworkSettings.NETWORK_OWNER).equals(uuid)).collect(Collectors.toList());
        return created.size() < FluxConfig.maximumPerPlayer;
    }

    public IFluxNetwork createdNetwork(EntityPlayer player, String name, int color, SecurityType securityType, EnergyType energyType, String password) {
        UUID uuid = EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH());
        NetworkMember owner = NetworkMember.createNetworkMember(player, AccessPermission.OWNER);
        FluxNetworkServer network = new FluxNetworkServer(this.getUniqueID(), name, securityType, color, uuid, energyType, password);
        network.getSetting(NetworkSettings.NETWORK_PLAYERS).add(owner);
        FluxNetworkData.get().addNetwork(network);
        return network;
    }

    private int getUniqueID() {
        return FluxNetworkData.get().uniqueID++;
    }

    public void updateClientFromPacket(Map<Integer, NBTTagCompound> serverSideNetworks, NBTType type) {
        serverSideNetworks.forEach((i, n) -> {
            IFluxNetwork network = this.networks.get(i);
            if (type == NBTType.NETWORK_CLEAR && network != null) {
                this.networks.remove(i);
                return;
            }
            if (network == null) {
                network = new FluxLiteNetwork();
                network.readNetworkNBT((NBTTagCompound)n, type);
                this.networks.put((Integer)i, network);
            } else {
                network.readNetworkNBT((NBTTagCompound)n, type);
            }
        });
    }

    public void updateClientConnections(int networkID, List<NBTTagCompound> tags) {
        IFluxNetwork network = this.networks.get(networkID);
        if (network != null) {
            List<IFluxConnector> connectors = network.getSetting(NetworkSettings.ALL_CONNECTORS);
            tags.forEach(t -> {
                Coord4D coord4D = new Coord4D((NBTTagCompound)t);
                connectors.stream().filter(f -> f.getCoords().equals(coord4D)).findFirst().ifPresent(f -> f.readCustomNBT((NBTTagCompound)t, NBTType.DEFAULT));
            });
        }
    }

    public IFluxNetwork getNetwork(int id) {
        return FluxNetworkData.get().networks.getOrDefault(id, FluxNetworkInvalid.instance);
    }

    public List<IFluxNetwork> getAllNetworks() {
        return new ArrayList<IFluxNetwork>(FluxNetworkData.get().networks.values());
    }

    public IFluxNetwork getClientNetwork(int id) {
        return this.networks.getOrDefault(id, FluxNetworkInvalid.instance);
    }

    public List<IFluxNetwork> getAllClientNetworks() {
        return new ArrayList<IFluxNetwork>(this.networks.values());
    }
}

