/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.common.data;

import com.google.common.collect.Lists;
import fluxnetworks.FluxNetworks;
import fluxnetworks.api.AccessPermission;
import fluxnetworks.api.Capabilities;
import fluxnetworks.api.EnergyType;
import fluxnetworks.api.SecurityType;
import fluxnetworks.api.network.IFluxNetwork;
import fluxnetworks.api.network.ISuperAdmin;
import fluxnetworks.api.tileentity.IFluxConnector;
import fluxnetworks.common.connection.FluxLiteConnector;
import fluxnetworks.common.connection.FluxNetworkBase;
import fluxnetworks.common.connection.FluxNetworkCache;
import fluxnetworks.common.connection.FluxNetworkServer;
import fluxnetworks.common.connection.NetworkMember;
import fluxnetworks.common.connection.NetworkSettings;
import fluxnetworks.common.core.NBTType;
import fluxnetworks.common.handler.PacketHandler;
import fluxnetworks.common.network.PacketNetworkUpdate;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.io.FileUtils;

public class FluxNetworkData
extends WorldSavedData {
    private static final String NETWORK_DATA = "fluxnetworksdata";
    private static FluxNetworkData data;
    public static String NETWORKS;
    public static String LOADED_CHUNKS;
    public static String UNIQUE_ID;
    public static String NETWORK_ID;
    public static String NETWORK_NAME;
    public static String NETWORK_COLOR;
    public static String NETWORK_PASSWORD;
    public static String SECURITY_TYPE;
    public static String ENERGY_TYPE;
    public static String OWNER_UUID;
    public static String WIRELESS_MODE;
    public static String PLAYER_LIST;
    public static String NETWORK_FOLDERS;
    public static String UNLOADED_CONNECTIONS;
    public static String OLD_NETWORK_ID;
    public static String OLD_NETWORK_NAME;
    public static String OLD_NETWORK_COLOR;
    public static String OLD_NETWORK_ACCESS;
    public Map<Integer, IFluxNetwork> networks = new HashMap<Integer, IFluxNetwork>();
    public Map<Integer, List<ChunkPos>> loadedChunks = new HashMap<Integer, List<ChunkPos>>();
    public int uniqueID = 1;

    public FluxNetworkData(String name) {
        super(name);
    }

    public FluxNetworkData() {
        this(NETWORK_DATA);
    }

    public static void clear() {
        if (data != null) {
            data = null;
            FluxNetworks.logger.info("FluxNetworkData has been unloaded");
        }
    }

    public boolean func_76188_b() {
        return true;
    }

    public static FluxNetworkData get() {
        if (data == null) {
            FluxNetworkData.loadData();
        }
        return data;
    }

    private static void loadData() {
        WorldServer world = DimensionManager.getWorld((int)0);
        MapStorage mapStorage = world.func_175693_T();
        FluxNetworkData savedData = (FluxNetworkData)mapStorage.func_75742_a(FluxNetworkData.class, NETWORK_DATA);
        if (savedData == null) {
            File oldFile = new File(world.func_72860_G().func_75765_b(), "data/sonar.flux.networks.configurations.dat");
            if (oldFile.exists()) {
                try {
                    FileUtils.copyFile((File)oldFile, (File)new File(oldFile.getParent(), "fluxnetworksdata.dat"));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                FluxNetworks.logger.info("Old FluxNetworkData found");
                savedData = (FluxNetworkData)mapStorage.func_75742_a(FluxNetworkData.class, NETWORK_DATA);
            } else {
                savedData = new FluxNetworkData(NETWORK_DATA);
                mapStorage.func_75745_a(NETWORK_DATA, (WorldSavedData)savedData);
                FluxNetworks.logger.info("No FluxNetworkData found");
            }
        }
        data = savedData;
        FluxNetworks.logger.info("FluxNetworkData has been successfully loaded");
    }

    public void addNetwork(IFluxNetwork network) {
        this.networks.putIfAbsent(network.getNetworkID(), network);
        PacketHandler.network.sendToAll((IMessage)new PacketNetworkUpdate.NetworkUpdateMessage(Lists.newArrayList((Object[])new IFluxNetwork[]{network}), NBTType.NETWORK_GENERAL));
    }

    public void removeNetwork(IFluxNetwork network) {
        PacketHandler.network.sendToAll((IMessage)new PacketNetworkUpdate.NetworkUpdateMessage(Lists.newArrayList((Object[])new IFluxNetwork[]{network}), NBTType.NETWORK_CLEAR));
        network.onRemoved();
        this.networks.remove(network.getNetworkID());
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.uniqueID = nbt.func_74762_e(UNIQUE_ID);
        if (nbt.func_74764_b(NETWORKS)) {
            NBTTagList list = nbt.func_150295_c(NETWORKS, 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound tag = list.func_150305_b(i);
                FluxNetworkServer network = new FluxNetworkServer();
                if (tag.func_74764_b(OLD_NETWORK_ID)) {
                    FluxNetworkData.readOldData(network, tag);
                } else {
                    network.readNetworkNBT(tag, NBTType.ALL_SAVE);
                }
                this.addNetwork(network);
            }
        }
        this.readChunks(nbt);
        data = this;
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        compound.func_74768_a(UNIQUE_ID, this.uniqueID);
        NBTTagList list = new NBTTagList();
        for (IFluxNetwork network : FluxNetworkCache.instance.getAllNetworks()) {
            NBTTagCompound tag = new NBTTagCompound();
            network.writeNetworkNBT(tag, NBTType.ALL_SAVE);
            list.func_74742_a((NBTBase)tag);
        }
        compound.func_74782_a(NETWORKS, (NBTBase)list);
        NBTTagCompound tag = new NBTTagCompound();
        this.loadedChunks.forEach((dim, pos) -> this.writeChunks((int)dim, (List<ChunkPos>)pos, tag));
        compound.func_74782_a(LOADED_CHUNKS, (NBTBase)tag);
        return compound;
    }

    public static void readPlayers(IFluxNetwork network, @Nonnull NBTTagCompound nbt) {
        if (!nbt.func_74764_b(PLAYER_LIST)) {
            return;
        }
        ArrayList<NetworkMember> a = new ArrayList<NetworkMember>();
        NBTTagList list = nbt.func_150295_c(PLAYER_LIST, 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound c = list.func_150305_b(i);
            a.add(new NetworkMember(c));
        }
        network.setSetting(NetworkSettings.NETWORK_PLAYERS, a);
    }

    public static NBTTagCompound writePlayers(IFluxNetwork network, @Nonnull NBTTagCompound nbt) {
        List<NetworkMember> a = network.getSetting(NetworkSettings.NETWORK_PLAYERS);
        if (!a.isEmpty()) {
            NBTTagList list = new NBTTagList();
            a.forEach(s -> list.func_74742_a((NBTBase)s.writeNetworkNBT(new NBTTagCompound())));
            nbt.func_74782_a(PLAYER_LIST, (NBTBase)list);
        }
        return nbt;
    }

    public static void writeAllPlayers(IFluxNetwork network, @Nonnull NBTTagCompound nbt) {
        List players;
        List<NetworkMember> a = network.getSetting(NetworkSettings.NETWORK_PLAYERS);
        NBTTagList list = new NBTTagList();
        if (!a.isEmpty()) {
            a.forEach(s -> list.func_74742_a((NBTBase)s.writeNetworkNBT(new NBTTagCompound())));
        }
        if (!(players = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()).isEmpty()) {
            players.stream().filter(p -> a.stream().noneMatch(s -> s.getPlayerUUID().equals(p.func_110124_au()))).forEach(s -> list.func_74742_a((NBTBase)NetworkMember.createNetworkMember((EntityPlayer)s, FluxNetworkData.getPermission((EntityPlayer)s)).writeNetworkNBT(new NBTTagCompound())));
        }
        nbt.func_74782_a(PLAYER_LIST, (NBTBase)list);
    }

    private static AccessPermission getPermission(EntityPlayer player) {
        ISuperAdmin superAdmin = (ISuperAdmin)player.getCapability(Capabilities.SUPER_ADMIN, null);
        return superAdmin != null && superAdmin.getPermission() ? AccessPermission.SUPER_ADMIN : AccessPermission.NONE;
    }

    public static void readConnections(IFluxNetwork network, @Nonnull NBTTagCompound nbt) {
        if (!nbt.func_74764_b(UNLOADED_CONNECTIONS)) {
            return;
        }
        ArrayList<FluxLiteConnector> a = new ArrayList<FluxLiteConnector>();
        NBTTagList list = nbt.func_150295_c(UNLOADED_CONNECTIONS, 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            a.add(new FluxLiteConnector(list.func_150305_b(i)));
        }
        network.getSetting(NetworkSettings.ALL_CONNECTORS).addAll(a);
    }

    public static NBTTagCompound writeConnections(IFluxNetwork network, @Nonnull NBTTagCompound nbt) {
        List<IFluxConnector> a = network.getSetting(NetworkSettings.ALL_CONNECTORS);
        if (!a.isEmpty()) {
            NBTTagList list = new NBTTagList();
            a.forEach(s -> {
                if (!s.isChunkLoaded()) {
                    list.func_74742_a((NBTBase)s.writeCustomNBT(new NBTTagCompound(), NBTType.DEFAULT));
                }
            });
            nbt.func_74782_a(UNLOADED_CONNECTIONS, (NBTBase)list);
        }
        return nbt;
    }

    public static void readAllConnections(IFluxNetwork network, @Nonnull NBTTagCompound nbt) {
        if (!nbt.func_74764_b(UNLOADED_CONNECTIONS)) {
            return;
        }
        ArrayList<FluxLiteConnector> a = new ArrayList<FluxLiteConnector>();
        NBTTagList list = nbt.func_150295_c(UNLOADED_CONNECTIONS, 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            a.add(new FluxLiteConnector(list.func_150305_b(i)));
        }
        network.setSetting(NetworkSettings.ALL_CONNECTORS, a);
    }

    public static NBTTagCompound writeAllConnections(IFluxNetwork network, @Nonnull NBTTagCompound nbt) {
        List<IFluxConnector> a = network.getSetting(NetworkSettings.ALL_CONNECTORS);
        if (!a.isEmpty()) {
            NBTTagList list = new NBTTagList();
            a.forEach(s -> list.func_74742_a((NBTBase)s.writeCustomNBT(new NBTTagCompound(), NBTType.DEFAULT)));
            nbt.func_74782_a(UNLOADED_CONNECTIONS, (NBTBase)list);
        }
        return nbt;
    }

    private void readChunks(NBTTagCompound nbt) {
        if (!nbt.func_74764_b(LOADED_CHUNKS)) {
            return;
        }
        NBTTagCompound tags = nbt.func_74775_l(LOADED_CHUNKS);
        for (String key : tags.func_150296_c()) {
            NBTTagList list = tags.func_150295_c(key, 10);
            List pos = this.loadedChunks.computeIfAbsent(Integer.valueOf(key), l -> new ArrayList());
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound tag = list.func_150305_b(i);
                pos.add(new ChunkPos(tag.func_74762_e("x"), tag.func_74762_e("z")));
            }
        }
    }

    private NBTTagCompound writeChunks(int dim, List<ChunkPos> pos, NBTTagCompound nbt) {
        if (!pos.isEmpty()) {
            NBTTagList list = new NBTTagList();
            pos.forEach(p -> {
                NBTTagCompound t = new NBTTagCompound();
                t.func_74768_a("x", p.field_77276_a);
                t.func_74768_a("z", p.field_77275_b);
                list.func_74742_a((NBTBase)t);
            });
            nbt.func_74782_a(String.valueOf(dim), (NBTBase)list);
        }
        return nbt;
    }

    private static void readOldData(FluxNetworkBase network, NBTTagCompound nbt) {
        network.network_id.setValue(nbt.func_74762_e(OLD_NETWORK_ID));
        network.network_name.setValue(nbt.func_74779_i(OLD_NETWORK_NAME));
        NBTTagCompound color = nbt.func_74775_l(OLD_NETWORK_COLOR);
        network.network_color.setValue(color.func_74762_e("red") << 16 | color.func_74762_e("green") << 8 | color.func_74762_e("blue"));
        network.network_owner.setValue(nbt.func_186857_a(OWNER_UUID));
        int c = nbt.func_74762_e(OLD_NETWORK_ACCESS);
        network.network_security.setValue(c > 0 ? SecurityType.ENCRYPTED : SecurityType.PUBLIC);
        network.network_password.setValue(String.valueOf((int)(Math.random() * 1000000.0)));
        network.network_energy.setValue(EnergyType.RF);
        FluxNetworkData.readPlayers(network, nbt);
        FluxNetworkData.readConnections(network, nbt);
    }

    static {
        NETWORKS = "networks";
        LOADED_CHUNKS = "loadedChunks";
        UNIQUE_ID = "uniqueID";
        NETWORK_ID = "networkID";
        NETWORK_NAME = "networkName";
        NETWORK_COLOR = "networkColor";
        NETWORK_PASSWORD = "networkPassword";
        SECURITY_TYPE = "networkSecurity";
        ENERGY_TYPE = "networkEnergy";
        OWNER_UUID = "ownerUUID";
        WIRELESS_MODE = "wirelessMode";
        PLAYER_LIST = "playerList";
        NETWORK_FOLDERS = "folders";
        UNLOADED_CONNECTIONS = "unloaded";
        OLD_NETWORK_ID = "id";
        OLD_NETWORK_NAME = "name";
        OLD_NETWORK_COLOR = "colour";
        OLD_NETWORK_ACCESS = "access";
    }
}

