/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.common.item;

import fluxnetworks.FluxNetworks;
import fluxnetworks.FluxTranslate;
import fluxnetworks.api.FluxConfigurationType;
import fluxnetworks.api.INetworkConnector;
import fluxnetworks.api.network.IFluxNetwork;
import fluxnetworks.client.FluxColorHandler;
import fluxnetworks.common.connection.FluxNetworkCache;
import fluxnetworks.common.item.ItemCore;
import fluxnetworks.common.tileentity.TileFluxCore;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemConfigurator
extends ItemCore {
    public ItemConfigurator() {
        super("FluxConfigurator");
    }

    public ItemConfigurator(String name) {
        super(name);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileFluxCore) {
            TileFluxCore fluxCore = (TileFluxCore)tile;
            if (!fluxCore.canAccess(player)) {
                TextComponentTranslation textComponents = new TextComponentTranslation("info.fluxnetworks.denied.access", new Object[0]);
                textComponents.func_150256_b().func_150227_a(Boolean.valueOf(true));
                textComponents.func_150256_b().func_150238_a(TextFormatting.DARK_RED);
                player.func_146105_b((ITextComponent)textComponents, true);
                return EnumActionResult.FAIL;
            }
            ItemStack stack = player.func_184586_b(hand);
            if (player.func_70093_af()) {
                stack.func_77983_a("Configs", (NBTBase)fluxCore.copyConfiguration(new NBTTagCompound()));
                player.func_145747_a((ITextComponent)new TextComponentString("Copied Configuration"));
            } else {
                NBTTagCompound configs = stack.func_190925_c("Configs");
                if (!configs.func_82582_d()) {
                    fluxCore.pasteConfiguration(configs);
                    player.func_145747_a((ITextComponent)new TextComponentString("Pasted Configuration"));
                }
            }
            return EnumActionResult.SUCCESS;
        }
        player.openGui((Object)FluxNetworks.instance, 1, worldIn, 0, 0, 0);
        return EnumActionResult.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (!worldIn.field_72995_K) {
            playerIn.openGui((Object)FluxNetworks.instance, 1, worldIn, 0, 0, 0);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        NBTTagCompound tag = stack.func_179543_a("Configs");
        if (tag != null) {
            tooltip.add(FluxTranslate.NETWORK_FULL_NAME.t() + ": " + TextFormatting.WHITE + FluxColorHandler.getOrRequestNetworkName(tag.func_74762_e(FluxConfigurationType.NETWORK.getNBTName())));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public static NetworkConnector getNetworkConnector(ItemStack stack, World world) {
        NBTTagCompound tag = stack.func_179543_a("Configs");
        int networkID = tag != null ? tag.func_74762_e(FluxConfigurationType.NETWORK.getNBTName()) : -1;
        IFluxNetwork network = world.field_72995_K ? FluxNetworkCache.instance.getClientNetwork(networkID) : FluxNetworkCache.instance.getNetwork(networkID);
        return new NetworkConnector(stack, networkID, network);
    }

    public static class NetworkConnector
    implements INetworkConnector {
        public ItemStack stack;
        public int networkID;
        public IFluxNetwork network;

        public NetworkConnector(ItemStack stack, int networkID, IFluxNetwork network) {
            this.stack = stack;
            this.networkID = networkID;
            this.network = network;
        }

        @Override
        public int getNetworkID() {
            return this.networkID;
        }

        @Override
        public IFluxNetwork getNetwork() {
            return this.network;
        }

        @Override
        public void open(EntityPlayer player) {
        }

        @Override
        public void close(EntityPlayer player) {
        }
    }
}

