/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.common.network;

import fluxnetworks.FluxConfig;
import fluxnetworks.api.Coord4D;
import fluxnetworks.api.FeedbackInfo;
import fluxnetworks.api.network.FluxType;
import fluxnetworks.api.network.IFluxNetwork;
import fluxnetworks.common.connection.FluxNetworkCache;
import fluxnetworks.common.core.FluxUtils;
import fluxnetworks.common.data.FluxChunkManager;
import fluxnetworks.common.handler.PacketHandler;
import fluxnetworks.common.item.ItemFluxConnector;
import fluxnetworks.common.network.PacketFeedback;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketBatchEditing
implements IMessageHandler<BatchEditingMessage, IMessage> {
    public IMessage onMessage(BatchEditingMessage message, MessageContext ctx) {
        IFluxNetwork network;
        EntityPlayer player = PacketHandler.getPlayer(ctx);
        if (player != null && !(network = FluxNetworkCache.instance.getNetwork(message.networkID)).isInvalid()) {
            if (network.getMemberPermission(player).canEdit()) {
                boolean editName = message.editions[0];
                boolean editPriority = message.editions[1];
                boolean editLimit = message.editions[2];
                boolean editSurge = message.editions[3];
                boolean editUnlimited = message.editions[4];
                boolean editChunkLoad = message.editions[5];
                boolean disconnect = message.editions[6];
                String name = message.tag.func_74779_i(ItemFluxConnector.CUSTOM_NAME);
                int priority = message.tag.func_74762_e(ItemFluxConnector.PRIORITY);
                long limit = message.tag.func_74763_f(ItemFluxConnector.LIMIT);
                boolean surge = message.tag.func_74767_n(ItemFluxConnector.SURGE_MODE);
                boolean unlimited = message.tag.func_74767_n(ItemFluxConnector.DISABLE_LIMIT);
                boolean load = message.tag.func_74767_n("chunkLoad");
                List onlineConnectors = network.getConnections(FluxType.flux);
                AtomicBoolean reject = new AtomicBoolean(false);
                PacketHandler.handlePacket(() -> {
                    message.coord4DS.forEach(c -> onlineConnectors.stream().filter(f -> f.getCoords().equals(c)).findFirst().ifPresent(f -> {
                        if (disconnect) {
                            FluxUtils.removeConnection(f, false);
                            f.disconnect(network);
                        } else {
                            if (editName) {
                                f.customName = name;
                            }
                            if (editPriority) {
                                f.priority = priority;
                            }
                            if (editLimit) {
                                f.limit = Math.min(limit, f.getMaxTransferLimit());
                            }
                            if (editSurge) {
                                f.surgeMode = surge;
                            }
                            if (editUnlimited) {
                                f.disableLimit = unlimited;
                            }
                            if (editChunkLoad) {
                                if (FluxConfig.enableChunkLoading) {
                                    if (load) {
                                        if (f.getConnectionType().isStorage()) {
                                            reject.set(true);
                                            return;
                                        }
                                        if (!f.chunkLoading) {
                                            f.chunkLoading = FluxChunkManager.forceChunk(f.func_145831_w(), new ChunkPos(f.func_174877_v()));
                                            if (!f.chunkLoading) {
                                                reject.set(true);
                                            }
                                        }
                                    } else {
                                        FluxChunkManager.releaseChunk(f.func_145831_w(), new ChunkPos(f.func_174877_v()));
                                        f.chunkLoading = false;
                                    }
                                } else {
                                    f.chunkLoading = false;
                                }
                            }
                            f.sendPackets();
                        }
                    }));
                    if (reject.get()) {
                        PacketHandler.network.sendTo((IMessage)new PacketFeedback.FeedbackMessage(FeedbackInfo.REJECT_SOME), (EntityPlayerMP)player);
                    }
                }, ctx.netHandler);
                return disconnect ? new PacketFeedback.FeedbackMessage(FeedbackInfo.SUCCESS_2) : new PacketFeedback.FeedbackMessage(FeedbackInfo.SUCCESS);
            }
            return new PacketFeedback.FeedbackMessage(FeedbackInfo.NO_ADMIN);
        }
        return null;
    }

    public static class BatchEditingMessage
    implements IMessage {
        public int networkID;
        public List<Coord4D> coord4DS = new ArrayList<Coord4D>();
        public NBTTagCompound tag;
        public boolean[] editions = new boolean[7];

        public BatchEditingMessage() {
        }

        public BatchEditingMessage(int networkID, List<Coord4D> coord4DS, NBTTagCompound tag, boolean[] editions) {
            this.networkID = networkID;
            this.coord4DS = coord4DS;
            this.tag = tag;
            this.editions = editions;
        }

        public void fromBytes(ByteBuf buf) {
            this.networkID = buf.readInt();
            for (int i = 0; i < 7; ++i) {
                this.editions[i] = buf.readBoolean();
            }
            this.tag = ByteBufUtils.readTag((ByteBuf)buf);
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                this.coord4DS.add(new Coord4D(buf));
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.networkID);
            boolean[] blArray = this.editions;
            int n = blArray.length;
            for (int i = 0; i < n; ++i) {
                Boolean b = blArray[i];
                buf.writeBoolean(b.booleanValue());
            }
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tag);
            buf.writeInt(this.coord4DS.size());
            this.coord4DS.forEach(c -> c.write(buf));
        }
    }
}

