/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.common.network;

import fluxnetworks.api.AccessPermission;
import fluxnetworks.api.network.IFluxNetwork;
import fluxnetworks.common.connection.FluxNetworkCache;
import fluxnetworks.common.network.PacketGUIPermission;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketPermissionRequest
implements IMessageHandler<PermissionRequestMessage, IMessage> {
    public IMessage onMessage(PermissionRequestMessage message, MessageContext ctx) {
        IFluxNetwork network = FluxNetworkCache.instance.getNetwork(message.networkID);
        EntityPlayerMP player = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(message.uuid);
        return new PacketGUIPermission.GUIPermissionMessage(network.isInvalid() || player == null ? AccessPermission.NONE : network.getMemberPermission((EntityPlayer)player));
    }

    public static class PermissionRequestMessage
    implements IMessage {
        public int networkID;
        public UUID uuid;

        public PermissionRequestMessage() {
        }

        public PermissionRequestMessage(int networkID, UUID uuid) {
            this.networkID = networkID;
            this.uuid = uuid;
        }

        public void fromBytes(ByteBuf buf) {
            this.networkID = buf.readInt();
            this.uuid = new UUID(buf.readLong(), buf.readLong());
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.networkID);
            buf.writeLong(this.uuid.getMostSignificantBits());
            buf.writeLong(this.uuid.getLeastSignificantBits());
        }
    }
}

