/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.common.network;

import com.mojang.authlib.GameProfile;
import fluxnetworks.FluxConfig;
import fluxnetworks.api.FeedbackInfo;
import fluxnetworks.api.network.FluxType;
import fluxnetworks.api.network.IFluxNetwork;
import fluxnetworks.common.connection.FluxNetworkCache;
import fluxnetworks.common.connection.NetworkSettings;
import fluxnetworks.common.data.FluxChunkManager;
import fluxnetworks.common.data.FluxNetworkData;
import fluxnetworks.common.network.PacketFeedback;
import fluxnetworks.common.tileentity.TileFluxCore;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketTileHandler {
    public static NBTTagCompound getSetNetworkPacket(int id, String password) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a(FluxNetworkData.NETWORK_ID, id);
        tag.func_74778_a(FluxNetworkData.NETWORK_PASSWORD, password);
        return tag;
    }

    public static IMessage handleSetNetworkPacket(TileFluxCore tile, EntityPlayer player, NBTTagCompound tag) {
        int id = tag.func_74762_e(FluxNetworkData.NETWORK_ID);
        String pass = tag.func_74779_i(FluxNetworkData.NETWORK_PASSWORD);
        if (tile.getNetworkID() == id) {
            return null;
        }
        IFluxNetwork network = FluxNetworkCache.instance.getNetwork(id);
        if (!network.isInvalid()) {
            if (tile.getConnectionType().isController() && network.getConnections(FluxType.controller).size() > 0) {
                return new PacketFeedback.FeedbackMessage(FeedbackInfo.HAS_CONTROLLER);
            }
            if (!network.getMemberPermission(player).canAccess()) {
                if (pass.isEmpty()) {
                    return new PacketFeedback.FeedbackMessage(FeedbackInfo.PASSWORD_REQUIRE);
                }
                if (!pass.equals(network.getSetting(NetworkSettings.NETWORK_PASSWORD))) {
                    return new PacketFeedback.FeedbackMessage(FeedbackInfo.REJECT);
                }
            }
            if (tile.getNetwork() != null && !tile.getNetwork().isInvalid()) {
                tile.getNetwork().queueConnectionRemoval(tile, false);
            }
            tile.playerUUID = EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH());
            network.queueConnectionAddition(tile);
            return new PacketFeedback.FeedbackMessage(FeedbackInfo.SUCCESS);
        }
        return null;
    }

    public static NBTTagCompound getChunkLoadPacket(boolean chunkLoading) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("c", chunkLoading);
        return tag;
    }

    public static IMessage handleChunkLoadPacket(TileFluxCore tile, EntityPlayer player, NBTTagCompound tag) {
        boolean load = tag.func_74767_n("c");
        if (FluxConfig.enableChunkLoading) {
            if (load) {
                boolean p;
                tile.chunkLoading = p = FluxChunkManager.forceChunk(tile.func_145831_w(), new ChunkPos(tile.func_174877_v()));
                if (!p) {
                    return new PacketFeedback.FeedbackMessage(FeedbackInfo.HAS_LOADER);
                }
                return null;
            }
            FluxChunkManager.releaseChunk(tile.func_145831_w(), new ChunkPos(tile.func_174877_v()));
            tile.chunkLoading = false;
            return null;
        }
        tile.chunkLoading = false;
        return new PacketFeedback.FeedbackMessage(FeedbackInfo.BANNED_LOADING);
    }
}

