/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_friendslist.client.gui.friendslist;

import austeretony.alternateui.util.EnumGUIAlignment;
import austeretony.oxygen_core.client.api.ClientReference;
import austeretony.oxygen_core.client.api.OxygenHelperClient;
import austeretony.oxygen_core.client.gui.IndexedGUIButton;
import austeretony.oxygen_core.client.gui.OxygenGUITextures;
import austeretony.oxygen_core.client.gui.elements.CustomRectUtils;
import austeretony.oxygen_core.client.gui.settings.GUISettings;
import austeretony.oxygen_core.common.PlayerSharedData;
import austeretony.oxygen_core.common.api.EnumDimension;
import austeretony.oxygen_core.common.util.OxygenUtils;
import austeretony.oxygen_core.server.OxygenPlayerData;
import austeretony.oxygen_friendslist.client.gui.friendslist.FriendsListGUIScreen;
import austeretony.oxygen_friendslist.common.ListEntry;
import java.util.UUID;
import net.minecraft.client.renderer.GlStateManager;

public class FriendListEntryGUIButton
extends IndexedGUIButton<UUID> {
    private String lastActivity;
    private String dimension;
    private String note;
    private int statusIconU;
    private boolean offline;
    private boolean hasNote;

    public FriendListEntryGUIButton(ListEntry entry) {
        super((Object)entry.getPlayerUUID());
        PlayerSharedData sharedData = OxygenHelperClient.getPlayerSharedData((UUID)entry.getPlayerUUID());
        OxygenPlayerData.EnumActivityStatus activityStatus = OxygenPlayerData.EnumActivityStatus.values()[sharedData.getByte(0)];
        if (!OxygenHelperClient.isPlayerOnline((UUID)sharedData.getPlayerUUID())) {
            activityStatus = OxygenPlayerData.EnumActivityStatus.OFFLINE;
        }
        this.lastActivity = ClientReference.localize((String)"oxygen.gui.lastActivityTime", (Object[])new Object[]{OxygenUtils.getTimePassedLocalizedString((long)sharedData.getLastActivityTime())});
        this.setDisplayText(sharedData.getUsername());
        this.dimension = EnumDimension.getLocalizedNameFromId((int)sharedData.getInt(1));
        this.statusIconU = activityStatus.ordinal() * 3;
        this.offline = activityStatus == OxygenPlayerData.EnumActivityStatus.OFFLINE;
        this.hasNote = !entry.getNote().isEmpty();
        this.note = entry.getNote();
        this.setDynamicBackgroundColor(GUISettings.get().getEnabledElementColor(), GUISettings.get().getDisabledElementColor(), GUISettings.get().getHoveredElementColor());
        this.setTextDynamicColor(GUISettings.get().getEnabledTextColor(), GUISettings.get().getDisabledTextColor(), GUISettings.get().getHoveredTextColor());
        this.setTooltipScaleFactor(GUISettings.get().getTooltipScale());
    }

    public void draw(int mouseX, int mouseY) {
        if (this.isVisible()) {
            int textColor;
            int color;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.getX(), (float)this.getY(), (float)0.0f);
            int noteIconU = 0;
            if (!this.isEnabled()) {
                color = this.getDisabledBackgroundColor();
                textColor = this.getDisabledTextColor();
                noteIconU = 8;
            } else if (this.isHovered() || this.isToggled()) {
                color = this.getHoveredBackgroundColor();
                textColor = this.getHoveredTextColor();
                noteIconU = 16;
            } else {
                color = this.getEnabledBackgroundColor();
                textColor = this.getEnabledTextColor();
            }
            int third = this.getWidth() / 3;
            CustomRectUtils.drawGradientRect((double)0.0, (double)0.0, (double)third, (double)this.getHeight(), (int)0, (int)color, (EnumGUIAlignment)EnumGUIAlignment.RIGHT);
            FriendListEntryGUIButton.drawRect((int)third, (int)0, (int)(this.getWidth() - third), (int)this.getHeight(), (int)color);
            CustomRectUtils.drawGradientRect((double)(this.getWidth() - third), (double)0.0, (double)this.getWidth(), (double)this.getHeight(), (int)0, (int)color, (EnumGUIAlignment)EnumGUIAlignment.LEFT);
            int textY = (this.getHeight() - this.textHeight(this.getTextScale())) / 2 + 1;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)18.0f, (float)textY, (float)0.0f);
            GlStateManager.func_179152_a((float)this.getTextScale(), (float)this.getTextScale(), (float)0.0f);
            this.mc.field_71466_p.func_175065_a(this.getDisplayText(), 0.0f, 0.0f, textColor, this.isTextShadowEnabled());
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)100.0f, (float)textY, (float)0.0f);
            GlStateManager.func_179152_a((float)this.getTextScale(), (float)this.getTextScale(), (float)0.0f);
            this.mc.field_71466_p.func_175065_a(this.dimension, 0.0f, 0.0f, textColor, this.isTextShadowEnabled());
            GlStateManager.func_179121_F();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.mc.func_110434_K().func_110577_a(OxygenGUITextures.STATUS_ICONS);
            FriendListEntryGUIButton.drawCustomSizedTexturedRect((int)7, (int)4, (int)this.statusIconU, (int)0, (int)3, (int)3, (int)12, (int)3);
            if (this.hasNote) {
                this.mc.func_110434_K().func_110577_a(FriendsListGUIScreen.NOTE_ICONS);
                FriendListEntryGUIButton.drawCustomSizedTexturedRect((int)(this.getWidth() - 20), (int)2, (int)noteIconU, (int)0, (int)8, (int)8, (int)24, (int)8);
            }
            GlStateManager.func_179121_F();
        }
    }

    public void drawTooltip(int mouseX, int mouseY) {
        if (this.offline && mouseX >= this.getX() + 7 && mouseY >= this.getY() + 4 && mouseX < this.getX() + 10 && mouseY < this.getY() + 7) {
            this.drawAsTooltip(mouseX, mouseY, this.lastActivity);
        } else if (this.hasNote && mouseX >= this.getX() + this.getWidth() - 20 && mouseY >= this.getY() + 2 && mouseX < this.getX() + this.getWidth() - 12 && mouseY < this.getY() + 8) {
            this.drawAsTooltip(mouseX - this.textWidth(this.note, this.getTooltipScaleFactor()), mouseY, this.note);
        }
    }

    private void drawAsTooltip(int mouseX, int mouseY, String text) {
        float scale = this.getTooltipScaleFactor();
        int width = this.textWidth(text, scale) + 6;
        int height = 12;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)mouseX, (float)((float)mouseY - scale * (float)height - 2.0f), (float)0.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)0.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        FriendListEntryGUIButton.drawRect((int)0, (int)0, (int)width, (int)height, (int)GUISettings.get().getBaseGUIBackgroundColor());
        CustomRectUtils.drawRect((double)0.0, (double)0.0, (double)0.4, (double)height, (int)GUISettings.get().getAdditionalGUIBackgroundColor());
        CustomRectUtils.drawRect((double)((double)width - 0.4), (double)0.0, (double)width, (double)height, (int)GUISettings.get().getAdditionalGUIBackgroundColor());
        CustomRectUtils.drawRect((double)0.0, (double)0.0, (double)width, (double)0.4, (int)GUISettings.get().getAdditionalGUIBackgroundColor());
        CustomRectUtils.drawRect((double)0.0, (double)((double)height - 0.4), (double)width, (double)height, (int)GUISettings.get().getAdditionalGUIBackgroundColor());
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((width - this.textWidth(text, scale)) / 2), (float)((height - this.textHeight(scale)) / 2), (float)0.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)0.0f);
        this.mc.field_71466_p.func_175065_a(text, 0.0f, 0.0f, this.getEnabledTextColor(), false);
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
    }
}

