/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_friendslist.client.gui.friendslist;

import austeretony.alternateui.screen.button.GUIButton;
import austeretony.alternateui.screen.callback.AbstractGUICallback;
import austeretony.alternateui.screen.contextmenu.GUIContextMenu;
import austeretony.alternateui.screen.core.AbstractGUIScreen;
import austeretony.alternateui.screen.core.AbstractGUISection;
import austeretony.alternateui.screen.core.GUIBaseElement;
import austeretony.alternateui.screen.text.GUITextField;
import austeretony.oxygen_core.client.OxygenManagerClient;
import austeretony.oxygen_core.client.api.ClientReference;
import austeretony.oxygen_core.client.api.OxygenGUIHelper;
import austeretony.oxygen_core.client.api.OxygenHelperClient;
import austeretony.oxygen_core.client.api.PrivilegeProviderClient;
import austeretony.oxygen_core.client.gui.OxygenGUITextures;
import austeretony.oxygen_core.client.gui.elements.ActivityStatusGUIDDList;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIButton;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIButtonPanel;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIContextMenu;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIContextMenuElement;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIText;
import austeretony.oxygen_core.client.gui.elements.OxygenGUITextField;
import austeretony.oxygen_core.client.gui.elements.OxygenSorterGUIElement;
import austeretony.oxygen_core.client.gui.elements.OxygenTexturedGUIButton;
import austeretony.oxygen_core.client.gui.elements.SectionsGUIDDList;
import austeretony.oxygen_core.client.gui.settings.GUISettings;
import austeretony.oxygen_core.common.PlayerSharedData;
import austeretony.oxygen_core.server.OxygenPlayerData;
import austeretony.oxygen_friendslist.client.FriendsListManagerClient;
import austeretony.oxygen_friendslist.client.gui.friendslist.FriendListEntryGUIButton;
import austeretony.oxygen_friendslist.client.gui.friendslist.FriendsListGUIScreen;
import austeretony.oxygen_friendslist.client.gui.friendslist.friendslist.FriendListGUIFiller;
import austeretony.oxygen_friendslist.client.gui.friendslist.friendslist.callback.AddFriendGUICallback;
import austeretony.oxygen_friendslist.client.gui.friendslist.friendslist.callback.EditNoteGUICallback;
import austeretony.oxygen_friendslist.client.gui.friendslist.friendslist.callback.RemoveFriendGUICallback;
import austeretony.oxygen_friendslist.client.gui.friendslist.friendslist.callback.SettingsGUICallback;
import austeretony.oxygen_friendslist.client.gui.friendslist.friendslist.context.EditNoteContextAction;
import austeretony.oxygen_friendslist.client.gui.friendslist.friendslist.context.RemoveFriendContextAction;
import austeretony.oxygen_friendslist.client.input.FriendsListKeyHandler;
import austeretony.oxygen_friendslist.common.ListEntry;
import austeretony.oxygen_friendslist.common.config.FriendsListConfig;
import austeretony.oxygen_friendslist.common.main.EnumFriendsListPrivilege;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class FriendsListGUISection
extends AbstractGUISection {
    private final FriendsListGUIScreen screen;
    private OxygenGUIButton addFriendButton;
    private OxygenTexturedGUIButton settingsButton;
    private OxygenGUIText friendsAmountTextLabel;
    private OxygenGUIButtonPanel friendsPanel;
    private AbstractGUICallback settingsCallback;
    private AbstractGUICallback addFriendCallback;
    private AbstractGUICallback removeCallback;
    private AbstractGUICallback editNoteCallback;
    private ActivityStatusGUIDDList activityStatusDDList;
    private OxygenSorterGUIElement statusSorter;
    private OxygenSorterGUIElement usernameSorter;
    private OxygenGUITextField searchField;
    private FriendListEntryGUIButton currentEntryButton;

    public FriendsListGUISection(FriendsListGUIScreen screen) {
        super((AbstractGUIScreen)screen);
        this.screen = screen;
    }

    public void init() {
        this.addElement((GUIBaseElement)new FriendListGUIFiller(0, 0, this.getWidth(), this.getHeight()));
        this.addElement((GUIBaseElement)new OxygenGUIText(4, 5, ClientReference.localize((String)"oxygen_friendslist.gui.friendslist.title", (Object[])new Object[0]), GUISettings.get().getTitleScale(), GUISettings.get().getEnabledTextColor()));
        this.friendsAmountTextLabel = new OxygenGUIText(0, this.getHeight() - 9, "", GUISettings.get().getSubTextScale() - 0.05f, GUISettings.get().getEnabledTextColor());
        this.addElement((GUIBaseElement)this.friendsAmountTextLabel);
        this.statusSorter = new OxygenSorterGUIElement(13, 27, OxygenSorterGUIElement.EnumSorting.DOWN, ClientReference.localize((String)"oxygen.sorting.status", (Object[])new Object[0]));
        this.addElement((GUIBaseElement)this.statusSorter);
        this.statusSorter.setClickListener(sorting -> {
            this.usernameSorter.reset();
            if (sorting == OxygenSorterGUIElement.EnumSorting.DOWN) {
                this.sortPlayers(0);
            } else {
                this.sortPlayers(1);
            }
        });
        this.usernameSorter = new OxygenSorterGUIElement(19, 27, OxygenSorterGUIElement.EnumSorting.INACTIVE, ClientReference.localize((String)"oxygen.sorting.username", (Object[])new Object[0]));
        this.addElement((GUIBaseElement)this.usernameSorter);
        this.usernameSorter.setClickListener(sorting -> {
            this.statusSorter.reset();
            if (sorting == OxygenSorterGUIElement.EnumSorting.DOWN) {
                this.sortPlayers(2);
            } else {
                this.sortPlayers(3);
            }
        });
        this.friendsPanel = new OxygenGUIButtonPanel((AbstractGUIScreen)this.screen, 6, 32, this.getWidth() - 15, 10, 1, PrivilegeProviderClient.getValue((String)EnumFriendsListPrivilege.MAX_FRIENDS_AMOUNT.toString(), (int)FriendsListConfig.MAX_FRIENDS_AMOUNT.getIntValue()), 12, GUISettings.get().getPanelTextScale(), true);
        this.addElement((GUIBaseElement)this.friendsPanel);
        this.searchField = new OxygenGUITextField(90, 16, 60, 8, 24, "...", 3, false, -1L);
        this.addElement((GUIBaseElement)this.searchField);
        this.friendsPanel.initSearchField((GUITextField)this.searchField);
        this.friendsPanel.setClickListener((previous, clicked, mouseX, mouseY, mouseButton) -> {
            this.currentEntryButton = clicked;
        });
        ArrayList<Object> actions = new ArrayList<Object>(OxygenManagerClient.instance().getGUIManager().getContextActions(60));
        actions.add(new RemoveFriendContextAction(this));
        actions.add(new EditNoteContextAction(this));
        OxygenGUIContextMenuElement.ContextMenuAction[] array = new OxygenGUIContextMenuElement.ContextMenuAction[actions.size()];
        actions.toArray(array);
        this.friendsPanel.initContextMenu((GUIContextMenu)new OxygenGUIContextMenu(GUISettings.get().getContextMenuWidth(), 9, array));
        this.addElement((GUIBaseElement)new SectionsGUIDDList(this.getWidth() - 4, 5, new AbstractGUISection[]{this, this.screen.getIgnoreListSection()}));
        this.activityStatusDDList = new ActivityStatusGUIDDList(7, 16);
        this.addElement((GUIBaseElement)this.activityStatusDDList);
        this.activityStatusDDList.setActivityStatusChangeListener(status -> {
            this.statusSorter.setSorting(OxygenSorterGUIElement.EnumSorting.DOWN);
            this.usernameSorter.reset();
            this.sortPlayers(0);
        });
        this.addFriendButton = (OxygenGUIButton)new OxygenGUIButton(4, 167, 40, 10, ClientReference.localize((String)"oxygen.gui.addButton", (Object[])new Object[0])).disable();
        this.addElement((GUIBaseElement)this.addFriendButton);
        this.settingsButton = new OxygenTexturedGUIButton(this.getWidth() - 5, 0, 5, 5, OxygenGUITextures.TRIANGLE_TOP_RIGHT_CORNER_ICONS, 5, 5, ClientReference.localize((String)"oxygen.tooltip.settings", (Object[])new Object[0]));
        this.addElement((GUIBaseElement)this.settingsButton);
        this.settingsCallback = new SettingsGUICallback(this.screen, this, 140, 42).enableDefaultBackground();
        this.addFriendCallback = new AddFriendGUICallback(this.screen, this, 140, 48).enableDefaultBackground();
        this.removeCallback = new RemoveFriendGUICallback(this.screen, this, 140, 38).enableDefaultBackground();
        this.editNoteCallback = new EditNoteGUICallback(this.screen, this, 140, 48).enableDefaultBackground();
    }

    private void sortPlayers(int mode) {
        List<ListEntry> friends = FriendsListManagerClient.instance().getPlayerDataContainer().getFriends();
        if (mode == 0) {
            Collections.sort(friends, (f1, f2) -> FriendsListGUISection.getActivityStatus(f1).ordinal() - FriendsListGUISection.getActivityStatus(f2).ordinal());
        } else if (mode == 1) {
            Collections.sort(friends, (f1, f2) -> FriendsListGUISection.getActivityStatus(f2).ordinal() - FriendsListGUISection.getActivityStatus(f1).ordinal());
        } else if (mode == 2) {
            Collections.sort(friends, (f1, f2) -> FriendsListGUISection.getUsername(f1).compareTo(FriendsListGUISection.getUsername(f2)));
        } else if (mode == 3) {
            Collections.sort(friends, (f1, f2) -> FriendsListGUISection.getUsername(f2).compareTo(FriendsListGUISection.getUsername(f1)));
        }
        this.friendsPanel.reset();
        for (ListEntry entry : friends) {
            this.friendsPanel.addButton((GUIButton)new FriendListEntryGUIButton(entry));
        }
        this.searchField.reset();
        this.friendsPanel.getScroller().resetPosition();
        this.friendsPanel.getScroller().getSlider().reset();
        this.friendsAmountTextLabel.setDisplayText(friends.size() + "/" + PrivilegeProviderClient.getValue((String)EnumFriendsListPrivilege.MAX_FRIENDS_AMOUNT.toString(), (int)FriendsListConfig.MAX_FRIENDS_AMOUNT.getIntValue()));
        this.friendsAmountTextLabel.setX(this.getWidth() - 4 - this.textWidth(this.friendsAmountTextLabel.getDisplayText(), GUISettings.get().getSubTextScale() - 0.05f));
    }

    public static OxygenPlayerData.EnumActivityStatus getActivityStatus(ListEntry entry) {
        return OxygenHelperClient.getPlayerActivityStatus((PlayerSharedData)OxygenHelperClient.getPlayerSharedData((UUID)entry.getPlayerUUID()));
    }

    public static String getUsername(ListEntry entry) {
        return OxygenHelperClient.getPlayerSharedData((UUID)entry.getPlayerUUID()).getUsername();
    }

    public void handleElementClick(AbstractGUISection section, GUIBaseElement element, int mouseButton) {
        if (mouseButton == 0) {
            if (element == this.settingsButton) {
                this.settingsCallback.open();
            } else if (element == this.addFriendButton) {
                this.addFriendCallback.open();
            }
        }
    }

    public boolean keyTyped(char typedChar, int keyCode) {
        if (!this.searchField.isDragged() && !this.hasCurrentCallback()) {
            if (OxygenGUIHelper.isOxygenMenuEnabled()) {
                if (keyCode == FriendsListGUIScreen.FRIENDS_LIST_MENU_ENTRY.getIndex() + 2) {
                    this.screen.close();
                }
            } else if (keyCode == FriendsListKeyHandler.FRIENDS_LIST.func_151463_i()) {
                this.screen.close();
            }
        }
        return super.keyTyped(typedChar, keyCode);
    }

    public void sharedDataSynchronized() {
        this.activityStatusDDList.updateActivityStatus();
    }

    public void listSynchronized() {
        if (FriendsListManagerClient.instance().getPlayerDataContainer().canAddFriend()) {
            this.addFriendButton.enable();
        }
        this.statusSorter.setSorting(OxygenSorterGUIElement.EnumSorting.DOWN);
        this.usernameSorter.reset();
        this.sortPlayers(0);
    }

    public void entryAdded() {
        this.statusSorter.setSorting(OxygenSorterGUIElement.EnumSorting.DOWN);
        this.usernameSorter.reset();
        this.sortPlayers(0);
    }

    public void entryRemoved() {
        this.statusSorter.setSorting(OxygenSorterGUIElement.EnumSorting.DOWN);
        this.usernameSorter.reset();
        this.sortPlayers(0);
    }

    public ListEntry getCurrentListEntry() {
        return FriendsListManagerClient.instance().getPlayerDataContainer().getListEntryByUUID((UUID)this.currentEntryButton.index);
    }

    public void openRemoveCallback() {
        this.removeCallback.open();
    }

    public void openEditNoteCallback() {
        this.editNoteCallback.open();
    }
}

