/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_friendslist.client.gui.friendslist.ignorelist.callback;

import austeretony.alternateui.screen.callback.AbstractGUICallback;
import austeretony.alternateui.screen.core.AbstractGUIScreen;
import austeretony.alternateui.screen.core.AbstractGUISection;
import austeretony.alternateui.screen.core.GUIBaseElement;
import austeretony.oxygen_core.client.api.ClientReference;
import austeretony.oxygen_core.client.gui.elements.OxygenCallbackGUIFiller;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIButton;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIText;
import austeretony.oxygen_core.client.gui.elements.OxygenGUITextField;
import austeretony.oxygen_core.client.gui.settings.GUISettings;
import austeretony.oxygen_friendslist.client.FriendsListManagerClient;
import austeretony.oxygen_friendslist.client.gui.friendslist.FriendsListGUIScreen;
import austeretony.oxygen_friendslist.client.gui.friendslist.IgnoreListGUISection;

public class EditNoteGUICallback
extends AbstractGUICallback {
    private final FriendsListGUIScreen screen;
    private final IgnoreListGUISection section;
    private OxygenGUITextField noteField;
    private OxygenGUIButton confirmButton;
    private OxygenGUIButton cancelButton;

    public EditNoteGUICallback(FriendsListGUIScreen screen, IgnoreListGUISection section, int width, int height) {
        super((AbstractGUIScreen)screen, (AbstractGUISection)section, width, height);
        this.screen = screen;
        this.section = section;
    }

    public void init() {
        this.addElement((GUIBaseElement)new OxygenCallbackGUIFiller(0, 0, this.getWidth(), this.getHeight()));
        this.addElement((GUIBaseElement)new OxygenGUIText(4, 5, ClientReference.localize((String)"oxygen_friendslist.gui.friendslist.callback.editNote", (Object[])new Object[0]), GUISettings.get().getTextScale(), GUISettings.get().getEnabledTextColor()));
        this.addElement((GUIBaseElement)new OxygenGUIText(6, 18, ClientReference.localize((String)"oxygen.gui.note", (Object[])new Object[0]), GUISettings.get().getSubTextScale(), GUISettings.get().getEnabledTextColor()));
        this.noteField = new OxygenGUITextField(6, 25, this.getWidth() - 12, 9, 50, "", 3, false, -1L);
        this.addElement((GUIBaseElement)this.noteField);
        this.confirmButton = (OxygenGUIButton)new OxygenGUIButton(15, this.getHeight() - 12, 40, 10, ClientReference.localize((String)"oxygen.gui.confirmButton", (Object[])new Object[0])).disable();
        this.addElement((GUIBaseElement)this.confirmButton);
        this.cancelButton = new OxygenGUIButton(this.getWidth() - 55, this.getHeight() - 12, 40, 10, ClientReference.localize((String)"oxygen.gui.cancelButton", (Object[])new Object[0]));
        this.addElement((GUIBaseElement)this.cancelButton);
    }

    protected void onOpen() {
        this.noteField.setText(this.section.getCurrentListEntry().getNote());
    }

    protected void onClose() {
        this.noteField.reset();
        this.confirmButton.disable();
    }

    public boolean keyTyped(char typedChar, int keyCode) {
        boolean flag = super.keyTyped(typedChar, keyCode);
        if (this.noteField.isDragged()) {
            this.confirmButton.setEnabled(!this.noteField.getTypedText().isEmpty());
        }
        return flag;
    }

    public void handleElementClick(AbstractGUISection section, GUIBaseElement element, int mouseButton) {
        if (mouseButton == 0) {
            if (element == this.cancelButton) {
                this.close();
            } else if (element == this.confirmButton) {
                FriendsListManagerClient.instance().getPlayerDataManager().editListEntryNoteSynced(this.section.getCurrentListEntry().getPlayerUUID(), this.noteField.getTypedText());
                this.close();
            }
        }
    }
}

