/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_friendslist.common;

import austeretony.oxygen_core.common.persistent.PersistentEntry;
import austeretony.oxygen_core.common.sync.SynchronizedData;
import austeretony.oxygen_core.common.util.ByteBufUtils;
import austeretony.oxygen_core.common.util.StreamUtils;
import io.netty.buffer.ByteBuf;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;

public class ListEntry
implements PersistentEntry,
SynchronizedData {
    public static final int MAX_NOTE_LENGTH = 50;
    private long entryId;
    private EnumEntryType type;
    private UUID playerUUID;
    private String note = "";

    public ListEntry() {
    }

    public ListEntry(EnumEntryType type, UUID playerUUID) {
        this.entryId = System.currentTimeMillis();
        this.type = type;
        this.playerUUID = playerUUID;
    }

    public long getId() {
        return this.entryId;
    }

    public void setId(long entryId) {
        this.entryId = entryId;
    }

    public EnumEntryType getType() {
        return this.type;
    }

    public void setType(EnumEntryType type) {
        this.type = type;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public void setPlayerUUID(UUID playerUUID) {
        this.playerUUID = playerUUID;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public void write(BufferedOutputStream bos) throws IOException {
        StreamUtils.write((byte)((byte)this.type.ordinal()), (OutputStream)bos);
        StreamUtils.write((UUID)this.playerUUID, (OutputStream)bos);
        StreamUtils.write((long)this.entryId, (OutputStream)bos);
        StreamUtils.write((String)this.note, (OutputStream)bos);
    }

    public void read(BufferedInputStream bis) throws IOException {
        this.type = EnumEntryType.values()[StreamUtils.readByte((InputStream)bis)];
        this.playerUUID = StreamUtils.readUUID((InputStream)bis);
        this.entryId = StreamUtils.readLong((InputStream)bis);
        this.note = StreamUtils.readString((InputStream)bis);
    }

    public void write(ByteBuf buffer) {
        buffer.writeByte(this.type.ordinal());
        ByteBufUtils.writeUUID((UUID)this.playerUUID, (ByteBuf)buffer);
        buffer.writeLong(this.entryId);
        ByteBufUtils.writeString((String)this.note, (ByteBuf)buffer);
    }

    public void read(ByteBuf buffer) {
        this.type = EnumEntryType.values()[buffer.readByte()];
        this.playerUUID = ByteBufUtils.readUUID((ByteBuf)buffer);
        this.entryId = buffer.readLong();
        this.note = ByteBufUtils.readString((ByteBuf)buffer);
    }

    public static enum EnumEntryType {
        FRIEND,
        IGNORED;

    }
}

