/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_friendslist.common.network.server;

import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.network.Packet;
import austeretony.oxygen_core.common.util.ByteBufUtils;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_core.server.api.RequestsFilterHelper;
import austeretony.oxygen_friendslist.server.FriendsListManagerServer;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;

public class SPManageList
extends Packet {
    private int ordinal;
    private UUID playerUUID;

    public SPManageList() {
    }

    public SPManageList(EnumRequest request, UUID playerUUID) {
        this.ordinal = request.ordinal();
        this.playerUUID = playerUUID;
    }

    public void write(ByteBuf buffer, INetHandler netHandler) {
        ByteBufUtils.writeUUID((UUID)this.playerUUID, (ByteBuf)buffer);
        buffer.writeByte(this.ordinal);
    }

    public void read(ByteBuf buffer, INetHandler netHandler) {
        EntityPlayerMP playerMP = SPManageList.getEntityPlayerMP((INetHandler)netHandler);
        if (RequestsFilterHelper.getLock((UUID)CommonReference.getPersistentUUID((Entity)playerMP), (int)66)) {
            UUID playerUUID = ByteBufUtils.readUUID((ByteBuf)buffer);
            switch (EnumRequest.values()[buffer.readByte()]) {
                case ADD_FRIEND: {
                    OxygenHelperServer.addRoutineTask(() -> FriendsListManagerServer.instance().getPlayerDataManager().sendFriendRequest(playerMP, playerUUID));
                    break;
                }
                case REMOVE_FRIEND: {
                    OxygenHelperServer.addRoutineTask(() -> FriendsListManagerServer.instance().getPlayerDataManager().removeFriend(playerMP, playerUUID));
                    break;
                }
                case ADD_IGNORED: {
                    OxygenHelperServer.addRoutineTask(() -> FriendsListManagerServer.instance().getPlayerDataManager().addToIgnored(playerMP, playerUUID));
                    break;
                }
                case REMOVE_IGNORED: {
                    OxygenHelperServer.addRoutineTask(() -> FriendsListManagerServer.instance().getPlayerDataManager().removeIgnored(playerMP, playerUUID));
                }
            }
        }
    }

    public static enum EnumRequest {
        ADD_FRIEND,
        REMOVE_FRIEND,
        ADD_IGNORED,
        REMOVE_IGNORED;

    }
}

