/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_friendslist.server;

import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.api.notification.AbstractNotification;
import austeretony.oxygen_core.common.notification.EnumNotification;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_friendslist.common.config.FriendsListConfig;
import austeretony.oxygen_friendslist.common.main.EnumFriendsListStatusMessage;
import austeretony.oxygen_friendslist.server.FriendsListManagerServer;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class FriendRequest
extends AbstractNotification {
    public final int index;
    public final UUID senderUUID;
    public final String senderUsername;

    public FriendRequest(int index, UUID senderUUID, String senderUsername) {
        this.index = index;
        this.senderUUID = senderUUID;
        this.senderUsername = senderUsername;
    }

    public EnumNotification getType() {
        return EnumNotification.REQUEST;
    }

    public String getDescription() {
        return "oxygen.request.friendRequest";
    }

    public String[] getArguments() {
        return new String[]{this.senderUsername};
    }

    public int getIndex() {
        return this.index;
    }

    public int getExpireTimeSeconds() {
        return FriendsListConfig.FRIEND_REQUEST_EXPIRE_TIME_SECONDS.getIntValue();
    }

    public void process() {
    }

    public void accepted(EntityPlayer player) {
        FriendsListManagerServer.instance().getPlayerDataManager().addToFriendsList((EntityPlayerMP)player, this.senderUUID);
    }

    public void rejected(EntityPlayer player) {
        if (OxygenHelperServer.isPlayerOnline((UUID)this.senderUUID)) {
            OxygenHelperServer.sendStatusMessage((EntityPlayerMP)CommonReference.playerByUUID((UUID)this.senderUUID), (int)6, (int)EnumFriendsListStatusMessage.FRIEND_REQUEST_REJECTED_SENDER.ordinal());
        }
        OxygenHelperServer.sendStatusMessage((EntityPlayerMP)((EntityPlayerMP)player), (int)6, (int)EnumFriendsListStatusMessage.FRIEND_REQUEST_REJECTED_TARGET.ordinal());
    }

    public void expired() {
    }
}

