/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_friendslist.server;

import austeretony.oxygen_core.common.persistent.AbstractPersistentData;
import austeretony.oxygen_core.common.util.StreamUtils;
import austeretony.oxygen_core.server.api.PrivilegeProviderServer;
import austeretony.oxygen_friendslist.common.ListEntry;
import austeretony.oxygen_friendslist.common.config.FriendsListConfig;
import austeretony.oxygen_friendslist.common.main.EnumFriendsListPrivilege;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class FriendsListPlayerData
extends AbstractPersistentData {
    private UUID playerUUID;
    private final Map<Long, ListEntry> entries = new ConcurrentHashMap<Long, ListEntry>(10);
    public String dataPath;

    public FriendsListPlayerData(UUID playerUUID, String dataPath) {
        this.playerUUID = playerUUID;
        this.dataPath = dataPath;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public void setPlayerUUID(UUID playerUUID) {
        this.playerUUID = playerUUID;
    }

    public Set<Long> getListEntriesIds() {
        return this.entries.keySet();
    }

    public Collection<ListEntry> getListEntries() {
        return this.entries.values();
    }

    public int getFriendsAmount() {
        return (int)this.entries.values().stream().filter(e -> e.getType() == ListEntry.EnumEntryType.FRIEND).count();
    }

    public int getIgnoredAmount() {
        return (int)this.entries.values().stream().filter(e -> e.getType() == ListEntry.EnumEntryType.IGNORED).count();
    }

    public boolean canAddFriend() {
        return this.getFriendsAmount() < PrivilegeProviderServer.getValue((UUID)this.playerUUID, (String)EnumFriendsListPrivilege.MAX_FRIENDS_AMOUNT.toString(), (int)FriendsListConfig.MAX_FRIENDS_AMOUNT.getIntValue());
    }

    public boolean canAddIgnored() {
        return this.getIgnoredAmount() < PrivilegeProviderServer.getValue((UUID)this.playerUUID, (String)EnumFriendsListPrivilege.MAX_IGNORED_AMOUNT.toString(), (int)FriendsListConfig.MAX_IGNORED_AMOUNT.getIntValue());
    }

    public boolean haveEntryForUUID(UUID playerUUID) {
        for (ListEntry entry : this.entries.values()) {
            if (!entry.getPlayerUUID().equals(playerUUID)) continue;
            return true;
        }
        return false;
    }

    public ListEntry getListEntry(long entryId) {
        return this.entries.get(entryId);
    }

    public ListEntry getListEntryByUUID(UUID playerUUID) {
        for (ListEntry entry : this.entries.values()) {
            if (!entry.getPlayerUUID().equals(playerUUID)) continue;
            return entry;
        }
        return null;
    }

    public void addListEntry(ListEntry entry) {
        this.entries.put(entry.getId(), entry);
    }

    public void removeListEntry(long id) {
        this.entries.remove(id);
    }

    public void removeListEntry(UUID playerUUID) {
        Iterator<ListEntry> iterator = this.entries.values().iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getPlayerUUID().equals(playerUUID)) continue;
            iterator.remove();
        }
    }

    public boolean isIgnored(UUID playerUUID) {
        ListEntry entry = this.getListEntryByUUID(playerUUID);
        if (entry != null) {
            return entry.getType() == ListEntry.EnumEntryType.IGNORED;
        }
        return false;
    }

    public String getDisplayName() {
        return "friendslist_player_data";
    }

    public String getPath() {
        return this.dataPath;
    }

    public long getSaveDelayMinutes() {
        return FriendsListConfig.LIST_SAVE_DELAY_MINUTES.getIntValue();
    }

    public void write(BufferedOutputStream bos) throws IOException {
        StreamUtils.write((short)((short)this.entries.size()), (OutputStream)bos);
        for (ListEntry listEntry : this.entries.values()) {
            listEntry.write(bos);
        }
    }

    public void read(BufferedInputStream bis) throws IOException {
        int amount = StreamUtils.readShort((InputStream)bis);
        for (int i = 0; i < amount; ++i) {
            ListEntry entry = new ListEntry();
            entry.read(bis);
            this.addListEntry(entry);
        }
    }

    public void reset() {
        this.entries.clear();
    }
}

