/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_friendslist.server;

import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.main.EnumOxygenStatusMessage;
import austeretony.oxygen_core.common.main.OxygenMain;
import austeretony.oxygen_core.common.network.Packet;
import austeretony.oxygen_core.common.notification.Notification;
import austeretony.oxygen_core.common.persistent.PersistentData;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_core.server.api.PrivilegeProviderServer;
import austeretony.oxygen_friendslist.common.ListEntry;
import austeretony.oxygen_friendslist.common.main.EnumFriendsListPrivilege;
import austeretony.oxygen_friendslist.common.main.EnumFriendsListStatusMessage;
import austeretony.oxygen_friendslist.common.network.client.CPListEntryAction;
import austeretony.oxygen_friendslist.server.FriendRequest;
import austeretony.oxygen_friendslist.server.FriendsListManagerServer;
import austeretony.oxygen_friendslist.server.FriendsListPlayerData;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;

public class FriendsListPlayerDataManager {
    private final FriendsListManagerServer manager;

    public FriendsListPlayerDataManager(FriendsListManagerServer manager) {
        this.manager = manager;
    }

    public void onPlayerLoaded(EntityPlayerMP playerMP) {
        UUID playerUUID = CommonReference.getPersistentUUID((Entity)playerMP);
        this.manager.getPlayerDataContainer().onPlayerLoaded(playerUUID);
    }

    public void onPlayerUnloaded(EntityPlayerMP playerMP) {
        UUID playerUUID = CommonReference.getPersistentUUID((Entity)playerMP);
        this.manager.getPlayerDataContainer().onPlayerUnloaded(playerUUID);
    }

    public void sendFriendRequest(EntityPlayerMP sender, UUID targetUUID) {
        UUID senderUUID = CommonReference.getPersistentUUID((Entity)sender);
        if (!senderUUID.equals(targetUUID) && OxygenHelperServer.isPlayerOnline((UUID)targetUUID)) {
            FriendsListPlayerData senderData = this.manager.getPlayerDataContainer().getPlayerData(senderUUID);
            if (senderData.canAddFriend() && !senderData.haveEntryForUUID(targetUUID)) {
                OxygenHelperServer.sendRequest((EntityPlayerMP)sender, (EntityPlayerMP)CommonReference.playerByUUID((UUID)targetUUID), (Notification)new FriendRequest(60, senderUUID, CommonReference.getName((Entity)sender)));
            } else {
                OxygenHelperServer.sendStatusMessage((EntityPlayerMP)sender, (int)0, (int)EnumOxygenStatusMessage.REQUEST_RESET.ordinal());
            }
        }
    }

    public void addToFriendsList(EntityPlayerMP playerMP, UUID senderUUID) {
        if (OxygenHelperServer.isPlayerOnline((UUID)senderUUID)) {
            UUID targetUUID = CommonReference.getPersistentUUID((Entity)playerMP);
            EntityPlayerMP senderMP = CommonReference.playerByUUID((UUID)senderUUID);
            FriendsListPlayerData senderData = this.manager.getPlayerDataContainer().getPlayerData(senderUUID);
            FriendsListPlayerData targetData = this.manager.getPlayerDataContainer().getPlayerData(targetUUID);
            targetData.addListEntry(new ListEntry(ListEntry.EnumEntryType.FRIEND, senderUUID));
            ListEntry entry = new ListEntry(ListEntry.EnumEntryType.FRIEND, targetUUID);
            senderData.addListEntry(entry);
            OxygenMain.network().sendTo((Packet)new CPListEntryAction(CPListEntryAction.EnumAction.ADDED, entry), senderMP);
            targetData.setChanged(true);
            senderData.setChanged(true);
            OxygenHelperServer.addObservedPlayer((UUID)senderUUID, (UUID)targetUUID);
            OxygenHelperServer.addObservedPlayer((UUID)targetUUID, (UUID)senderUUID);
            OxygenHelperServer.sendStatusMessage((EntityPlayerMP)senderMP, (int)6, (int)EnumFriendsListStatusMessage.FRIEND_REQUEST_ACCEPTED_SENDER.ordinal());
            OxygenHelperServer.sendStatusMessage((EntityPlayerMP)playerMP, (int)6, (int)EnumFriendsListStatusMessage.FRIEND_REQUEST_ACCEPTED_TARGET.ordinal());
        }
    }

    public void removeFriend(EntityPlayerMP playerMP, UUID targetUUID) {
        UUID playerUUID = CommonReference.getPersistentUUID((Entity)playerMP);
        if (!playerUUID.equals(targetUUID)) {
            FriendsListPlayerData targetData;
            FriendsListPlayerData playerData = this.manager.getPlayerDataContainer().getPlayerData(playerUUID);
            if (!this.manager.getPlayerDataContainer().playerDataExist(targetUUID)) {
                this.manager.getPlayerDataContainer().createPlayerData(targetUUID);
                targetData = this.manager.getPlayerDataContainer().getPlayerData(targetUUID);
                OxygenHelperServer.loadPersistentData((PersistentData)targetData);
            } else {
                targetData = this.manager.getPlayerDataContainer().getPlayerData(targetUUID);
            }
            ListEntry entry = playerData.getListEntryByUUID(targetUUID);
            if (entry != null) {
                playerData.removeListEntry(entry.getId());
                OxygenMain.network().sendTo((Packet)new CPListEntryAction(CPListEntryAction.EnumAction.REMOVED, entry), playerMP);
                targetData.removeListEntry(playerUUID);
                playerData.setChanged(true);
                targetData.setChanged(true);
                OxygenHelperServer.removeObservedPlayer((UUID)playerUUID, (UUID)targetUUID);
                OxygenHelperServer.removeObservedPlayer((UUID)targetUUID, (UUID)playerUUID);
                OxygenHelperServer.sendStatusMessage((EntityPlayerMP)playerMP, (int)6, (int)EnumFriendsListStatusMessage.FRIEND_REMOVED.ordinal());
            }
        }
    }

    public void editListEntryNote(EntityPlayerMP playerMP, UUID targetUUID, String note) {
        FriendsListPlayerData playerData;
        ListEntry entry;
        UUID senderUUID = CommonReference.getPersistentUUID((Entity)playerMP);
        if (!senderUUID.equals(targetUUID) && (entry = (playerData = this.manager.getPlayerDataContainer().getPlayerData(senderUUID)).getListEntryByUUID(targetUUID)) != null) {
            if (note.length() > 50) {
                note = note.substring(0, 50);
            }
            playerData.removeListEntry(entry.getId());
            OxygenMain.network().sendTo((Packet)new CPListEntryAction(CPListEntryAction.EnumAction.REMOVED, entry), playerMP);
            ListEntry newEntry = new ListEntry(entry.getType(), targetUUID);
            newEntry.setNote(note);
            playerData.addListEntry(newEntry);
            OxygenMain.network().sendTo((Packet)new CPListEntryAction(CPListEntryAction.EnumAction.ADDED, newEntry), playerMP);
            playerData.setChanged(true);
            OxygenHelperServer.sendStatusMessage((EntityPlayerMP)playerMP, (int)6, (int)EnumFriendsListStatusMessage.NOTE_EDITED.ordinal());
        }
    }

    public void addToIgnored(EntityPlayerMP playerMP, UUID targetUUID) {
        UUID playerUUID = CommonReference.getPersistentUUID((Entity)playerMP);
        if (!playerUUID.equals(targetUUID) && !PrivilegeProviderServer.getValue((UUID)targetUUID, (String)EnumFriendsListPrivilege.PREVENT_IGNORE.toString(), (boolean)false) && OxygenHelperServer.isPlayerOnline((UUID)targetUUID)) {
            FriendsListPlayerData playerData = this.manager.getPlayerDataContainer().getPlayerData(playerUUID);
            if (playerData.canAddIgnored() && !playerData.haveEntryForUUID(targetUUID)) {
                ListEntry entry = new ListEntry(ListEntry.EnumEntryType.IGNORED, targetUUID);
                playerData.addListEntry(entry);
                OxygenMain.network().sendTo((Packet)new CPListEntryAction(CPListEntryAction.EnumAction.ADDED, entry), playerMP);
                playerData.setChanged(true);
                OxygenHelperServer.addObservedPlayer((UUID)playerUUID, (UUID)targetUUID);
                OxygenHelperServer.sendStatusMessage((EntityPlayerMP)playerMP, (int)6, (int)EnumFriendsListStatusMessage.ADDED_TO_IGNORED.ordinal());
            } else {
                OxygenHelperServer.sendStatusMessage((EntityPlayerMP)playerMP, (int)0, (int)EnumOxygenStatusMessage.REQUEST_RESET.ordinal());
            }
        } else {
            OxygenHelperServer.sendStatusMessage((EntityPlayerMP)playerMP, (int)0, (int)EnumOxygenStatusMessage.REQUEST_RESET.ordinal());
        }
    }

    public void removeIgnored(EntityPlayerMP playerMP, UUID targetUUID) {
        FriendsListPlayerData playerData;
        ListEntry entry;
        UUID playerUUID = CommonReference.getPersistentUUID((Entity)playerMP);
        if (!playerUUID.equals(targetUUID) && (entry = (playerData = this.manager.getPlayerDataContainer().getPlayerData(playerUUID)).getListEntryByUUID(targetUUID)) != null) {
            playerData.removeListEntry(entry.getId());
            OxygenMain.network().sendTo((Packet)new CPListEntryAction(CPListEntryAction.EnumAction.REMOVED, entry), playerMP);
            playerData.setChanged(true);
            OxygenHelperServer.removeObservedPlayer((UUID)playerUUID, (UUID)targetUUID);
            OxygenHelperServer.sendStatusMessage((EntityPlayerMP)playerMP, (int)6, (int)EnumFriendsListStatusMessage.IGNORED_REMOVED.ordinal());
        }
    }
}

