/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.tileentity;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPane;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.network.AbstractPacket;
import slimeknights.mantle.tileentity.TileInventory;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.client.model.ModelHelper;
import slimeknights.tconstruct.shared.block.BlockTable;
import slimeknights.tconstruct.shared.block.PropertyTableItem;
import slimeknights.tconstruct.tools.common.network.InventorySlotSyncPacket;

public class TileTable
extends TileInventory {
    public static final String FEET_TAG = "textureBlock";
    public static final String FACE_TAG = "facing";
    protected int displaySlot = 0;

    public TileTable() {
        super("", 0, 0);
    }

    public TileTable(String name, int inventorySize) {
        super(name, inventorySize);
    }

    public TileTable(String name, int inventorySize, int maxStackSize) {
        super(name, inventorySize, maxStackSize);
    }

    public IExtendedBlockState writeExtendedBlockState(IExtendedBlockState state) {
        ItemStack stack;
        String texture = this.getTileData().func_74779_i("texture");
        if (texture.isEmpty() && !(stack = new ItemStack(this.getTileData().func_74775_l(FEET_TAG))).func_190926_b()) {
            Block block = Block.func_149634_a((Item)stack.func_77973_b());
            texture = ModelHelper.getTextureFromBlock((Block)block, (int)stack.func_77952_i()).func_94215_i();
            this.getTileData().func_74778_a("texture", texture);
        }
        if (!texture.isEmpty()) {
            state = state.withProperty((IUnlistedProperty)BlockTable.TEXTURE, (Object)texture);
        }
        EnumFacing facing = this.getFacing();
        state = state.withProperty((IUnlistedProperty)BlockTable.FACING, (Object)facing);
        state = this.setInventoryDisplay(state);
        return state;
    }

    protected IExtendedBlockState setInventoryDisplay(IExtendedBlockState state) {
        ItemStack stack;
        PropertyTableItem.TableItem item;
        PropertyTableItem.TableItems toDisplay = new PropertyTableItem.TableItems();
        if (!this.func_70301_a(this.displaySlot).func_190926_b() && (item = TileTable.getTableItem(stack = this.func_70301_a(this.displaySlot), this.func_145831_w(), null)) != null) {
            toDisplay.items.add(item);
        }
        return state.withProperty((IUnlistedProperty)BlockTable.INVENTORY, (Object)toDisplay);
    }

    public boolean isInventoryEmpty() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public static PropertyTableItem.TableItem getTableItem(ItemStack stack, World world, EntityLivingBase entity) {
        if (stack.func_190926_b()) {
            return null;
        }
        if (!Config.renderTableItems) {
            return new PropertyTableItem.TableItem(stack, null);
        }
        IBakedModel model = ModelHelper.getBakedModelForItem(stack, world, entity);
        PropertyTableItem.TableItem item = new PropertyTableItem.TableItem(stack, model, 0.0f, -0.46875f, 0.0f, 0.8f, 1.5707964f);
        if (stack.func_77973_b() instanceof ItemBlock) {
            if (!(Block.func_149634_a((Item)stack.func_77973_b()) instanceof BlockPane)) {
                item.y = -0.3125f;
                item.r = 0.0f;
            }
            item.s = 0.375f;
        }
        return item;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = this.getTileData().func_74737_b();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.func_174877_v(), this.func_145832_p(), tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTBase facing;
        NBTTagCompound tag = pkt.func_148857_g();
        NBTBase feet = tag.func_74781_a(FEET_TAG);
        if (feet != null) {
            this.getTileData().func_74782_a(FEET_TAG, feet);
        }
        if ((facing = tag.func_74781_a(FACE_TAG)) != null) {
            this.getTileData().func_74782_a(FACE_TAG, facing);
        }
        this.func_145839_a(tag);
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void handleUpdateTag(@Nonnull NBTTagCompound tag) {
        this.func_145839_a(tag);
    }

    public void setFacing(EnumFacing face) {
        this.getTileData().func_74768_a(FACE_TAG, face.func_176745_a());
    }

    public EnumFacing getFacing() {
        return EnumFacing.func_82600_a((int)this.getTileData().func_74762_e(FACE_TAG));
    }

    public void updateTextureBlock(NBTTagCompound tag) {
        this.getTileData().func_74782_a(FEET_TAG, (NBTBase)tag);
    }

    public NBTTagCompound getTextureBlock() {
        return this.getTileData().func_74775_l(FEET_TAG);
    }

    public void func_70299_a(int slot, ItemStack itemstack) {
        if (this.func_145831_w() != null && this.func_145831_w() instanceof WorldServer && !this.func_145831_w().field_72995_K && !ItemStack.func_77989_b((ItemStack)itemstack, (ItemStack)this.func_70301_a(slot))) {
            TinkerNetwork.sendToClients((WorldServer)this.func_145831_w(), this.field_174879_c, (AbstractPacket)new InventorySlotSyncPacket(itemstack, slot, this.field_174879_c));
        }
        super.func_70299_a(slot, itemstack);
        if (this.func_145831_w() != null && this.func_145831_w().field_72995_K && Config.renderTableItems) {
            Minecraft.func_71410_x().field_71438_f.func_184376_a(null, this.field_174879_c, null, null, 0);
        }
    }
}

