/*
 * Decompiled with CFR 0.152.
 */
package mcmultipart.api.microblock;

import java.util.Optional;
import mcmultipart.api.microblock.IMicroMaterialDelegate;
import mcmultipart.api.microblock.MicroblockType;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class MicroMaterial
extends IForgeRegistryEntry.Impl<MicroMaterial> {
    protected Optional<IMicroMaterialDelegate> delegate;

    public MicroMaterial() {
        this(true);
    }

    protected MicroMaterial(boolean hasDelegate) {
        if (hasDelegate) {
            this.delegate = this instanceof IMicroMaterialDelegate ? Optional.of((IMicroMaterialDelegate)((Object)this)) : Optional.empty();
        }
    }

    public abstract String getLocalizedName();

    public abstract boolean isSolid();

    public abstract int getLightValue();

    public abstract float getHardness();

    public abstract int getCuttingStrength();

    public abstract ItemStack getStack();

    public abstract SoundType getSound(IBlockState var1, World var2, BlockPos var3, Entity var4);

    public abstract IBlockState getDefaultState();

    public abstract IBlockState getStateForPlacement(World var1, BlockPos var2, EnumFacing var3, float var4, float var5, float var6, EntityLivingBase var7, EnumHand var8);

    public abstract IBlockState getActualState(IBlockAccess var1, BlockPos var2, IBlockState var3);

    public IBlockState getExtendedState(IBlockAccess world, BlockPos pos, IBlockState state) {
        return state;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.SOLID;
    }

    public boolean cacheModels() {
        return true;
    }

    public Optional<IMicroMaterialDelegate> getDelegate(MicroblockType type) {
        return this.delegate;
    }
}

