/*
 * Decompiled with CFR 0.152.
 */
package mcmultipart.api.slot;

import mcmultipart.api.slot.EnumEdgeSlot;
import mcmultipart.api.slot.EnumSlotAccess;
import mcmultipart.api.slot.IPartSlot;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public enum EnumFaceSlot implements IPartSlot,
IPartSlot.IFaceSlot
{
    DOWN(EnumFacing.DOWN),
    UP(EnumFacing.UP),
    NORTH(EnumFacing.NORTH),
    SOUTH(EnumFacing.SOUTH),
    WEST(EnumFacing.WEST),
    EAST(EnumFacing.EAST);

    public static final EnumFaceSlot[] VALUES;
    private final ResourceLocation name = new ResourceLocation("mcmultipart", this.name().toLowerCase());
    private final EnumFacing facing;

    private EnumFaceSlot(EnumFacing facing) {
        this.facing = facing;
    }

    public ResourceLocation getRegistryName() {
        return this.name;
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public EnumFaceSlot getOpposite() {
        return VALUES[this.ordinal() ^ 1];
    }

    @Override
    public EnumSlotAccess getFaceAccess(EnumFacing face) {
        return face == this.getFacing() ? EnumSlotAccess.OVERRIDE : (face != this.getOpposite().getFacing() ? EnumSlotAccess.MERGE : EnumSlotAccess.NONE);
    }

    @Override
    public int getFaceAccessPriority(EnumFacing face) {
        return face == this.getFacing() ? 300 : (face != this.getOpposite().getFacing() ? 250 : 0);
    }

    @Override
    public EnumSlotAccess getEdgeAccess(EnumEdgeSlot edge, EnumFacing face) {
        return edge.getFace1() == face || edge.getFace2() == face ? EnumSlotAccess.OVERRIDE : EnumSlotAccess.NONE;
    }

    @Override
    public int getEdgeAccessPriority(EnumEdgeSlot edge, EnumFacing face) {
        return 200;
    }

    public static EnumFaceSlot fromFace(EnumFacing face) {
        return VALUES[face.ordinal()];
    }

    static {
        VALUES = EnumFaceSlot.values();
    }
}

