/*
 * Decompiled with CFR 0.152.
 */
package mcmultipart.capability;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class CapabilityJoiner {
    private static final Map<Capability<?>, Function<?, ?>> joiners = new IdentityHashMap();

    public static <T> void registerCapabilityJoiner(Capability<T> capability, Function<List<T>, T> joiner) {
        joiners.putIfAbsent(capability, joiner);
    }

    public static <T> T join(Capability<T> capability, List<T> list) {
        if (list.isEmpty()) {
            return null;
        }
        Function<?, ?> func = joiners.get(capability);
        return (T)(func != null ? func.apply(list) : list.get(0));
    }

    public static class JoinedItemHandler
    implements IItemHandler {
        protected final IItemHandler[] itemHandler;
        protected final int[] baseIndex;
        protected final int slotCount;

        private JoinedItemHandler(IItemHandler ... itemHandler) {
            this.itemHandler = itemHandler;
            this.baseIndex = new int[itemHandler.length];
            int index = 0;
            for (int i = 0; i < itemHandler.length; ++i) {
                this.baseIndex[i] = index += itemHandler[i].getSlots();
            }
            this.slotCount = index;
        }

        protected int getIndexForSlot(int slot) {
            if (slot < 0) {
                return -1;
            }
            for (int i = 0; i < this.baseIndex.length; ++i) {
                if (slot - this.baseIndex[i] >= 0) continue;
                return i;
            }
            return -1;
        }

        protected IItemHandler getHandlerFromIndex(int index) {
            if (index < 0 || index >= this.itemHandler.length) {
                return EmptyHandler.INSTANCE;
            }
            return this.itemHandler[index];
        }

        protected int getSlotFromIndex(int slot, int index) {
            if (index <= 0 || index >= this.baseIndex.length) {
                return slot;
            }
            return slot - this.baseIndex[index - 1];
        }

        public int getSlots() {
            return this.slotCount;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            int index = this.getIndexForSlot(slot);
            IItemHandler handler = this.getHandlerFromIndex(index);
            slot = this.getSlotFromIndex(slot, index);
            return handler.getStackInSlot(slot);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            int index = this.getIndexForSlot(slot);
            IItemHandler handler = this.getHandlerFromIndex(index);
            slot = this.getSlotFromIndex(slot, index);
            return handler.insertItem(slot, stack, simulate);
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            int index = this.getIndexForSlot(slot);
            IItemHandler handler = this.getHandlerFromIndex(index);
            slot = this.getSlotFromIndex(slot, index);
            return handler.extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            int index = this.getIndexForSlot(slot);
            IItemHandler handler = this.getHandlerFromIndex(index);
            int localSlot = this.getSlotFromIndex(slot, index);
            return handler.getSlotLimit(localSlot);
        }

        public static IItemHandler join(List<IItemHandler> inventories) {
            if (inventories.isEmpty()) {
                return EmptyHandler.INSTANCE;
            }
            if (inventories.size() == 1) {
                return inventories.get(0);
            }
            if (inventories.stream().allMatch(i -> i instanceof IItemHandlerModifiable)) {
                return new CombinedInvWrapper((IItemHandlerModifiable[])inventories.stream().map(i -> (IItemHandlerModifiable)i).toArray(IItemHandlerModifiable[]::new));
            }
            return new JoinedItemHandler(inventories.toArray(new IItemHandler[inventories.size()]));
        }
    }
}

