/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.netherex.block;

import java.util.Arrays;
import java.util.Random;
import logictechcorp.libraryex.block.BlockModSmallMushroom;
import logictechcorp.libraryex.block.property.BlockProperties;
import logictechcorp.libraryex.world.generation.trait.BiomeTraitStructure;
import logictechcorp.netherex.NetherEx;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;

public class BlockSpoulShroom
extends BlockModSmallMushroom {
    public static final PropertyEnum<EnumPart> PART = PropertyEnum.func_177709_a((String)"part", EnumPart.class);
    protected static final AxisAlignedBB MUSHROOM_AABB = new AxisAlignedBB(0.09999999403953552, 0.0, 0.09999999403953552, (double)0.9f, (double)0.8f, (double)0.9f);

    public BlockSpoulShroom() {
        super(NetherEx.getResource("spoul_shroom"), new BlockProperties(Material.field_151585_k, MapColor.field_151650_B), EnumPlantType.Nether);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(PART, (Comparable)((Object)EnumPart.SINGLE)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return MUSHROOM_AABB;
    }

    public void func_176474_b(World world, Random random, BlockPos pos, IBlockState state) {
        BlockPos posUp = pos.func_177984_a();
        IBlockState stateDown = world.func_180495_p(pos.func_177977_b());
        Block blockDown = stateDown.func_177230_c();
        if (state.func_177229_b(PART) == EnumPart.SINGLE) {
            if (world.func_175623_d(posUp) && blockDown != this) {
                world.func_175656_a(pos, state.func_177226_a(PART, (Comparable)((Object)EnumPart.DOUBLE_BOTTOM)));
                world.func_175656_a(posUp, state.func_177226_a(PART, (Comparable)((Object)EnumPart.DOUBLE_TOP)));
            }
        } else {
            world.func_175698_g(posUp);
            world.func_175698_g(pos);
            BiomeTraitStructure spoulShroom = BiomeTraitStructure.create(trait -> {
                trait.generationAttempts(1);
                trait.randomizeGenerationAttempts(true);
                trait.minimumGenerationHeight(32);
                trait.maximumGenerationHeight(108);
                trait.structures(Arrays.asList(NetherEx.getResource("spoul_shroom/spoul_shroom_01"), NetherEx.getResource("spoul_shroom/spoul_shroom_02"), NetherEx.getResource("spoul_shroom/spoul_shroom_03"), NetherEx.getResource("spoul_shroom/spoul_shroom_04"), NetherEx.getResource("spoul_shroom/spoul_shroom_05"), NetherEx.getResource("spoul_shroom/spoul_shroom_06"), NetherEx.getResource("spoul_shroom/spoul_shroom_07"), NetherEx.getResource("spoul_shroom/spoul_shroom_08"), NetherEx.getResource("spoul_shroom/spoul_shroom_09"), NetherEx.getResource("spoul_shroom/spoul_shroom_10"), NetherEx.getResource("spoul_shroom/spoul_shroom_11"), NetherEx.getResource("spoul_shroom/spoul_shroom_12")));
                trait.structureType(BiomeTraitStructure.StructureType.GROUND);
                trait.ignoredBlock(Blocks.field_150350_a);
                trait.clearancePercentage(1.0);
                trait.orientRandomly(true);
            });
            if (!spoulShroom.generate(world, pos, random)) {
                world.func_175656_a(pos, state.func_177226_a(PART, (Comparable)((Object)EnumPart.DOUBLE_BOTTOM)));
                world.func_175656_a(posUp, state.func_177226_a(PART, (Comparable)((Object)EnumPart.DOUBLE_TOP)));
            }
        }
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        IBlockState soil = world.func_180495_p(pos.func_177977_b());
        if (state.func_177229_b(PART) == EnumPart.DOUBLE_TOP && soil.func_177230_c() == this && soil.func_177229_b(PART) == EnumPart.DOUBLE_BOTTOM) {
            return false;
        }
        return !isClient && soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        IBlockState plant = plantable.getPlant(world, pos.func_177972_a(direction));
        if (plant.func_177230_c() == this) {
            if (plant.func_177229_b(PART) == EnumPart.DOUBLE_TOP && state.func_177229_b(PART) == EnumPart.DOUBLE_TOP) {
                return false;
            }
            return plant.func_177229_b(PART) == EnumPart.DOUBLE_TOP && state.func_177229_b(PART) == EnumPart.DOUBLE_BOTTOM;
        }
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(PART, (Comparable)((Object)EnumPart.fromMeta(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumPart)((Object)state.func_177229_b(PART))).ordinal();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PART});
    }

    public static enum EnumPart implements IStringSerializable
    {
        SINGLE,
        DOUBLE_TOP,
        DOUBLE_BOTTOM;


        public String func_176610_l() {
            return this.toString().toLowerCase();
        }

        public static EnumPart fromMeta(int meta) {
            if (meta < 0 || meta >= EnumPart.values().length) {
                meta = 0;
            }
            return EnumPart.values()[meta];
        }
    }
}

