/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.netherex.entity.monster;

import java.util.List;
import logictechcorp.netherex.entity.ai.controller.FloatingMovementController;
import logictechcorp.netherex.init.NetherExLootTables;
import logictechcorp.netherex.init.NetherExTextures;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityLostSoul
extends EntityCreature
implements IMob {
    private static final DataParameter<Integer> TYPE = EntityDataManager.func_187226_a(EntityLostSoul.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityLostSoul(World world) {
        super(world);
        this.func_70105_a(0.75f, 1.0f);
        this.func_189654_d(true);
        this.field_70178_ae = true;
        this.field_70728_aV = 5;
        this.field_70765_h = new FloatingMovementController((EntityLiving)this, false);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AIFlee(this, 10.0f, 3.0, 2.0));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AITaunt(this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AIScare(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0, 10));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 1, false, false, null));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(5.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TYPE, (Object)Type.NEUTRAL.ordinal());
    }

    protected PathNavigate func_175447_b(World world) {
        PathNavigateFlying navigateFlying = new PathNavigateFlying((EntityLiving)this, world);
        navigateFlying.func_192879_a(false);
        navigateFlying.func_192877_c(true);
        navigateFlying.func_192878_b(true);
        return navigateFlying;
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData data) {
        this.setRandomType();
        return super.func_180482_a(difficulty, data);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!(this.field_70170_p.field_72995_K || this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL || this.getType() != Type.MEAN && this.getType() != Type.ANGRY)) {
            this.func_70106_y();
        }
    }

    protected void func_70619_bc() {
        if (!this.func_110175_bO()) {
            this.func_175449_a(new BlockPos((Entity)this), 8);
        }
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGround, IBlockState state, BlockPos pos) {
    }

    public boolean func_70617_f_() {
        return false;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean hasEnlargedHead() {
        return false;
    }

    public boolean func_70601_bi() {
        return this.field_70146_Z.nextInt(10) == 0 && super.func_70601_bi();
    }

    public int func_70641_bl() {
        return 8;
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        String type = this.getType().toString().toLowerCase();
        return I18n.func_74838_a((String)("entity.netherex:" + type + "_lost_soul.name"));
    }

    protected ResourceLocation func_184647_J() {
        return this.getType().lootTable;
    }

    public Type getType() {
        return Type.getFromOrdinal((Integer)this.field_70180_af.func_187225_a(TYPE));
    }

    public void func_70110_aj() {
    }

    public void func_70031_b(boolean sprinting) {
    }

    public void setType(Type type) {
        this.field_70180_af.func_187227_b(TYPE, (Object)type.ordinal());
    }

    private void setRandomType() {
        this.setType(Type.getFromOrdinal(this.field_70146_Z.nextInt(Type.values().length)));
    }

    static class AIScare
    extends EntityAIBase {
        private EntityLostSoul lostSoul;

        public AIScare(EntityLostSoul lostSoul) {
            this.lostSoul = lostSoul;
            this.func_75248_a(1);
        }

        public void func_75249_e() {
        }

        public void func_75246_d() {
        }

        public void func_75251_c() {
        }

        public boolean func_75250_a() {
            return this.lostSoul.getType() == Type.ANGRY && this.lostSoul.func_70638_az() != null;
        }
    }

    static class AITaunt
    extends EntityAIBase {
        private EntityLostSoul lostSoul;

        AITaunt(EntityLostSoul lostSoul) {
            this.lostSoul = lostSoul;
            this.func_75248_a(1);
        }

        public void func_75249_e() {
        }

        public void func_75246_d() {
        }

        public void func_75251_c() {
        }

        public boolean func_75250_a() {
            return this.lostSoul.getType() == Type.MEAN && this.lostSoul.func_70638_az() != null;
        }
    }

    static class AIFlee
    extends EntityAIBase {
        private EntityLostSoul lostSoul;
        private float avoidDistance;
        private double nearSpeed;
        private double farSpeed;
        private PathNavigate navigator;
        private Path path;
        private EntityPlayer closestPlayer;

        AIFlee(EntityLostSoul lostSoul, float avoidDistance, double nearSpeed, double farSpeed) {
            this.lostSoul = lostSoul;
            this.avoidDistance = avoidDistance;
            this.nearSpeed = nearSpeed;
            this.farSpeed = farSpeed;
            this.navigator = lostSoul.field_70699_by;
            this.func_75248_a(1);
        }

        public void func_75249_e() {
            this.navigator.func_75484_a(this.path, this.farSpeed);
        }

        public void func_75246_d() {
            if (this.lostSoul.func_70068_e((Entity)this.closestPlayer) < 49.0) {
                this.lostSoul.func_70661_as().func_75489_a(this.nearSpeed);
            } else {
                this.lostSoul.func_70661_as().func_75489_a(this.farSpeed);
            }
        }

        public boolean func_75250_a() {
            if (this.lostSoul.getType() != Type.TIMID) {
                return false;
            }
            List list = this.lostSoul.field_70170_p.func_72872_a(EntityPlayer.class, this.lostSoul.func_174813_aQ().func_72314_b((double)this.avoidDistance, (double)this.avoidDistance, (double)this.avoidDistance));
            if (list.isEmpty()) {
                return false;
            }
            this.closestPlayer = (EntityPlayer)list.get(0);
            Vec3d vec3d = RandomPositionGenerator.func_75461_b((EntityCreature)this.lostSoul, (int)16, (int)7, (Vec3d)new Vec3d(this.closestPlayer.field_70165_t, this.closestPlayer.field_70163_u, this.closestPlayer.field_70161_v));
            if (vec3d == null) {
                return false;
            }
            this.path = this.navigator.func_75488_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
            return this.path != null;
        }

        public boolean func_75253_b() {
            return !this.navigator.func_75500_f();
        }

        public void func_75251_c() {
            this.closestPlayer = null;
        }
    }

    public static enum Type {
        KIND(NetherExTextures.KIND_LOST_SOUL, NetherExLootTables.KIND_LOST_SOUL),
        TIMID(NetherExTextures.TIMID_LOST_SOUL, NetherExLootTables.TIMID_LOST_SOUL),
        NEUTRAL(NetherExTextures.NEUTRAL_LOST_SOUL, NetherExLootTables.NEUTRAL_LOST_SOUL),
        MEAN(NetherExTextures.MEAN_LOST_SOUL, NetherExLootTables.MEAN_LOST_SOUL),
        ANGRY(NetherExTextures.ANGRY_LOST_SOUL, NetherExLootTables.ANGRY_LOST_SOUL);

        ResourceLocation texture;
        ResourceLocation lootTable;

        private Type(ResourceLocation texture, ResourceLocation lootTable) {
            this.texture = texture;
            this.lootTable = lootTable;
        }

        public ResourceLocation getTexture() {
            return this.texture;
        }

        public ResourceLocation getLootTable() {
            return this.lootTable;
        }

        static Type getFromOrdinal(int ordinal) {
            if (ordinal < 0 || ordinal >= Type.values().length) {
                ordinal = 0;
            }
            return Type.values()[ordinal];
        }
    }
}

