/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.netherex.handler;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import logictechcorp.netherex.NetherEx;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="netherex")
public class RemapHandler {
    private static final Map<String, String> MAPPINGS_TO_REPLACE = ImmutableMap.builder().put((Object)"nex:block_basalt", (Object)"netherex:basalt").put((Object)"nex:block_netherrack", (Object)"netherex:netherrack").put((Object)"nex:block_brick_nether", (Object)"netherex:nether_brick").put((Object)"nex:block_netherrack_path", (Object)"netherex:netherrack_path").put((Object)"nex:block_hyphae", (Object)"netherex:hyphae").put((Object)"nex:block_sand_soul_tilled", (Object)"netherex:tilled_soul_sand").put((Object)"nex:block_glass_soul", (Object)"netherex:soul_glass").put((Object)"nex:block_glass_pane_soul", (Object)"netherex:soul_glass_pane").put((Object)"nex:block_amethyst", (Object)"netherex:amethyst_block").put((Object)"nex:block_rime", (Object)"netherex:rime_block").put((Object)"nex:block_ice_frostburn", (Object)"netherex:frostburn_ice").put((Object)"nex:block_bone_sliver", (Object)"netherex:bone_sliver").put((Object)"nex:block_bone_chunk", (Object)"netherex:bone_chunk").put((Object)"nex:block_iron_worn", (Object)"netherex:worn_iron").put((Object)"nex:block_fire_blue", (Object)"netherex:blue_fire").put((Object)"nex:block_portal_nether", (Object)"netherex:nether_portal").put((Object)"nex:tile_urn_sorrow", (Object)"netherex:urn_of_sorrow").put((Object)"nex:ore_quartz", (Object)"netherex:quartz_ore").put((Object)"nex:ore_amethyst", (Object)"netherex:amethyst_ore").put((Object)"nex:ore_rime", (Object)"netherex:rime_ore").put((Object)"nex:plant_thornstalk", (Object)"netherex:thornstalk").put((Object)"nex:plant_mushroom_elder", (Object)"netherex:elder_mushroom").put((Object)"nex:plant_mushroom_elder_cap", (Object)"netherex:elder_mushroom_cap").put((Object)"nex:plant_mushroom_elder_stem", (Object)"netherex:elder_mushroom_stem").put((Object)"nex:plant_mushroom_enoki_stem", (Object)"netherex:enoki_mushroom_stem").put((Object)"nex:plant_mushroom_enoki_cap", (Object)"netherex:enoki_mushroom_cap").put((Object)"nex:fluid_ichor", (Object)"netherex:ichor").put((Object)"nex:slab_vanilla", (Object)"netherex:vanilla_slab").put((Object)"nex:slab_basalt", (Object)"netherex:basalt_slab").put((Object)"nex:slab_brick_nether", (Object)"netherex:nether_brick_slab").put((Object)"nex:slab_vanilla_double", (Object)"netherex:vanilla_slab_double").put((Object)"nex:slab_basalt_double", (Object)"netherex:basalt_slab_double").put((Object)"nex:slab_brick_nether_double", (Object)"netherex:nether_brick_slab_double").put((Object)"nex:stairs_brick_nether_red", (Object)"netherex:red_nether_brick_stairs").put((Object)"nex:stairs_basalt_normal", (Object)"netherex:basalt_stairs").put((Object)"nex:stairs_basalt_smooth", (Object)"netherex:smooth_basalt_stairs").put((Object)"nex:basalt_smooth_stairs", (Object)"netherex:smooth_basalt_stairs").put((Object)"nex:stairs_basalt_brick", (Object)"netherex:basalt_brick_stairs").put((Object)"nex:stairs_basalt_pillar", (Object)"netherex:basalt_pillar_stairs").put((Object)"nex:stairs_brick_nether_fiery", (Object)"netherex:fiery_nether_brick_stairs").put((Object)"nex:stairs_brick_nether_icy", (Object)"netherex:icy_nether_brick_stairs").put((Object)"nex:stairs_brick_nether_lively", (Object)"netherex:lively_nether_brick_stairs").put((Object)"nex:stairs_brick_nether_gloomy", (Object)"netherex:gloomy_nether_brick_stairs").put((Object)"nex:wall_vanilla", (Object)"netherex:vanilla_wall").put((Object)"nex:wall_basalt", (Object)"netherex:basalt_wall").put((Object)"nex:wall_brick_nether", (Object)"netherex:nether_brick_wall").put((Object)"nex:fence_vanilla", (Object)"netherex:vanilla_fence").put((Object)"nex:fence_basalt", (Object)"netherex:basalt_fence").put((Object)"nex:fence_brick_nether", (Object)"netherex:nether_brick_fence").put((Object)"nex:fence_gate_quartz", (Object)"netherex:quartz_fence_gate").put((Object)"nex:fence_gate_brick_nether", (Object)"netherex:nether_brick_fence_gate").put((Object)"nex:fence_gate_brick_nether_red", (Object)"netherex:red_nether_brick_fence_gate").put((Object)"nex:fence_gate_basalt_normal", (Object)"netherex:basalt_fence_gate").put((Object)"nex:fence_gate_basalt_smooth", (Object)"netherex:smooth_basalt_fence_gate").put((Object)"nex:basalt_smooth_fence_gate", (Object)"netherex:smooth_basalt_fence_gate").put((Object)"nex:fence_gate_basalt_brick", (Object)"netherex:basalt_brick_fence_gate").put((Object)"nex:fence_gate_basalt_pillar", (Object)"netherex:basalt_pillar_fence_gate").put((Object)"nex:fence_gate_brick_nether_fiery", (Object)"netherex:fiery_nether_brick_fence_gate").put((Object)"nex:fence_gate_brick_nether_icy", (Object)"netherex:icy_nether_brick_fence_gate").put((Object)"nex:fence_gate_brick_nether_lively", (Object)"netherex:lively_nether_brick_fence_gate").put((Object)"nex:fence_gate_brick_nether_gloomy", (Object)"netherex:gloomy_nether_brick_fence_gate").put((Object)"nex:item_brick_nether", (Object)"netherex:netherbrick").put((Object)"nex:item_bone_wither", (Object)"netherex:wither_bone").put((Object)"nex:item_dust_wither", (Object)"netherex:wither_dust").put((Object)"nex:item_hide_salamander", (Object)"netherex:salamander_hide").put((Object)"nex:item_crystal_amethyst", (Object)"netherex:amethyst_crystal").put((Object)"nex:item_crystal_rime", (Object)"netherex:rime_crystal").put((Object)"nex:item_crystal_rime_steel", (Object)"netherex:rime_and_steel").put((Object)"nex:item_spore", (Object)"netherex:spore").put((Object)"nex:item_fang_spider_bone", (Object)"netherex:coolmar_spider_fang").put((Object)"nex:item_tear_ghast_queen", (Object)"netherex:ghast_queen_tear").put((Object)"nex:item_boat_obsidian", (Object)"netherex:obsidian_boat").put((Object)"nex:food_meat_ghast_raw", (Object)"netherex:ghast_meat_raw").put((Object)"nex:food_meat_ghast_cooked", (Object)"netherex:ghast_meat_cooked").put((Object)"nex:food_congealed_magma_cream", (Object)"netherex:congealed_magma_cream").put((Object)"nex:food_mushroom_enoki", (Object)"netherex:enoki_mushroom").put((Object)"nex:armor_helmet_bone", (Object)"netherex:wither_bone_helmet").put((Object)"nex:armor_chestplate_bone", (Object)"netherex:wither_bone_chestplate").put((Object)"nex:armor_leggings_bone", (Object)"netherex:wither_bone_leggings").put((Object)"nex:armor_boots_bone", (Object)"netherex:wither_bone_boots").put((Object)"nex:armor_helmet_hide_salamander", (Object)"netherex:salamander_hide_helmet").put((Object)"nex:armor_chestplate_hide_salamander", (Object)"netherex:salamander_hide_chestplate").put((Object)"nex:armor_leggings_hide_salamander", (Object)"netherex:salamander_hide_leggings").put((Object)"nex:armor_boots_hide_salamander", (Object)"netherex:salamander_hide_boots").put((Object)"nex:hell", (Object)"minecraft:hell").put((Object)"nex:ruthless_sands", (Object)"netherex:ruthless_sands").put((Object)"nex:projectile_ghast_queen_fireball", (Object)"netherex:ghast_queen_fireball").put((Object)"nex:projectile_ghastling_fireball", (Object)"netherex:ghastling_fireball").put((Object)"nex:passive_pigtificate_leader", (Object)"netherex:pigtificate_leader").put((Object)"nex:passive_pigtificate", (Object)"netherex:pigtificate").put((Object)"nex:neutral_gold_golem", (Object)"netherex:gold_golem").put((Object)"nex:neutral_mogus", (Object)"netherex:mogus").put((Object)"nex:neutral_salamander", (Object)"netherex:salamander").put((Object)"nex:monster_wight", (Object)"netherex:wight").put((Object)"nex:monster_ember", (Object)"netherex:ember").put((Object)"nex:monster_nethermite", (Object)"netherex:nethermite").put((Object)"nex:monster_spinout", (Object)"netherex:spinout").put((Object)"nex:monster_spore_creeper", (Object)"netherex:spore_creeper").put((Object)"nex:monster_spore", (Object)"netherex:spore").put((Object)"nex:monster_ghastling", (Object)"netherex:ghastling").put((Object)"nex:monster_bone_spider", (Object)"netherex:coolmar_spider").put((Object)"nex:bone_spider", (Object)"netherex:coolmar_spider").put((Object)"nex:monster_brute", (Object)"netherex:brute").put((Object)"nex:boss_ghast_queen", (Object)"netherex:ghast_queen").put((Object)"nex:ambient_pigtificate", (Object)"netherex:pigtificate_ambient").put((Object)"nex:hurt_pigtificate", (Object)"netherex:pigtificate_hurt").put((Object)"nex:death_pigtificate", (Object)"netherex:pigtificate_death").put((Object)"nex:ambient_mogus", (Object)"netherex:mogus_ambient").put((Object)"nex:hurt_mogus", (Object)"netherex:mogus_hurt").put((Object)"nex:death_mogus", (Object)"netherex:mogus_death").put((Object)"nex:ambient_salamander", (Object)"netherex:salamander_ambient").put((Object)"nex:hurt_salamander", (Object)"netherex:salamander_hurt").put((Object)"nex:death_salamander", (Object)"netherex:salamander_death").put((Object)"nex:ambient_wight", (Object)"netherex:wight_ambient").put((Object)"nex:hurt_wight", (Object)"netherex:wight_hurt").put((Object)"nex:death_wight", (Object)"netherex:wight_death").put((Object)"nex:hurt_ember", (Object)"netherex:ember_hurt").put((Object)"nex:death_ember", (Object)"netherex:ember_death").put((Object)"nex:ambient_nethermite", (Object)"netherex:nethermite_ambient").put((Object)"nex:hurt_nethermite", (Object)"netherex:nethermite_hurt").put((Object)"nex:death_nethermite", (Object)"netherex:nethermite_death").put((Object)"nex:ambient_spinout", (Object)"netherex:spinout_ambient").put((Object)"nex:hurt_spinout", (Object)"netherex:spinout_hurt").put((Object)"nex:death_spinout", (Object)"netherex:spinout_death").put((Object)"nex:hurt_spore", (Object)"netherex:spore_hurt").put((Object)"nex:death_spore", (Object)"netherex:spore_death").put((Object)"nex:warn_spore", (Object)"netherex:spore_warn").put((Object)"nex:explode_spore", (Object)"netherex:spore_explode").put((Object)"nex:ambient_ghastling", (Object)"netherex:ghastling_ambient").put((Object)"nex:hurt_ghastling", (Object)"netherex:ghastling_hurt").put((Object)"nex:death_ghastling", (Object)"netherex:ghastling_death").put((Object)"nex:warn_ghastling", (Object)"netherex:ghastling_warn").put((Object)"nex:shoot_ghastling", (Object)"netherex:ghastling_shoot").put((Object)"nex:ambient_ghast_queen", (Object)"netherex:ghast_queen_ambient").put((Object)"nex:hurt_ghast_queen", (Object)"netherex:ghast_queen_hurt").put((Object)"nex:death_ghast_queen", (Object)"netherex:ghast_queen_death").put((Object)"nex:shoot_ghast_queen", (Object)"netherex:ghast_queen_shoot").put((Object)"nex:summon_ghast_queen", (Object)"netherex:ghast_queen_summon").build();

    private static void remapEntries(RegistryEvent.MissingMappings.Mapping missingMapping, IForgeRegistry registry) {
        String oldMapping = missingMapping.key.toString();
        if (MAPPINGS_TO_REPLACE.containsKey(oldMapping)) {
            String newMapping = MAPPINGS_TO_REPLACE.get(oldMapping);
            ResourceLocation replacementMapping = new ResourceLocation(newMapping);
            IForgeRegistryEntry entry = registry.getValue(replacementMapping);
            if (registry.containsKey(replacementMapping) && entry != null) {
                missingMapping.remap(entry);
                NetherEx.LOGGER.info("Remapped {} {} to {}.", (Object)registry.getRegistrySuperType().getSimpleName(), (Object)missingMapping.key, (Object)replacementMapping);
            }
        } else if (oldMapping.contains("nex")) {
            String newMapping = oldMapping.replace("nex", "netherex");
            ResourceLocation replacementMapping = new ResourceLocation(newMapping);
            IForgeRegistryEntry entry = registry.getValue(replacementMapping);
            if (registry.containsKey(replacementMapping) && entry != null) {
                missingMapping.remap(entry);
            } else {
                missingMapping.ignore();
            }
        }
    }

    @SubscribeEvent
    public static void onMissingBlockMappings(RegistryEvent.MissingMappings<Block> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            RemapHandler.remapEntries(mapping, ForgeRegistries.BLOCKS);
        }
    }

    @SubscribeEvent
    public static void onMissingItemMappings(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            RemapHandler.remapEntries(mapping, ForgeRegistries.ITEMS);
        }
    }

    @SubscribeEvent
    public static void onMissingBiomeMappings(RegistryEvent.MissingMappings<Biome> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            RemapHandler.remapEntries(mapping, ForgeRegistries.BIOMES);
        }
    }

    @SubscribeEvent
    public static void onMissingEntityMappings(RegistryEvent.MissingMappings<EntityEntry> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            RemapHandler.remapEntries(mapping, ForgeRegistries.ENTITIES);
        }
    }

    @SubscribeEvent
    public static void onMissingPotionEventMappings(RegistryEvent.MissingMappings<Potion> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            RemapHandler.remapEntries(mapping, ForgeRegistries.POTIONS);
        }
    }

    @SubscribeEvent
    public static void onMissingPotionTypeEventMappings(RegistryEvent.MissingMappings<PotionType> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            RemapHandler.remapEntries(mapping, ForgeRegistries.POTION_TYPES);
        }
    }

    @SubscribeEvent
    public static void onMissingSoundEventMappings(RegistryEvent.MissingMappings<SoundEvent> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            RemapHandler.remapEntries(mapping, ForgeRegistries.SOUND_EVENTS);
        }
    }
}

