/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.netherex.init;

import java.util.Collections;
import logictechcorp.libraryex.api.LibraryExAPI;
import logictechcorp.libraryex.api.world.biome.data.IBiomeData;
import logictechcorp.libraryex.api.world.biome.data.IBiomeDataRegistry;
import logictechcorp.libraryex.api.world.generation.GenerationStage;
import logictechcorp.libraryex.api.world.generation.trait.IBiomeTraitBuilder;
import logictechcorp.libraryex.utility.InjectionHelper;
import logictechcorp.libraryex.world.generation.trait.BiomeTraitOre;
import logictechcorp.libraryex.world.generation.trait.BiomeTraitStructure;
import logictechcorp.netherex.NetherEx;
import logictechcorp.netherex.api.NetherExAPI;
import logictechcorp.netherex.handler.ConfigHandler;
import logictechcorp.netherex.init.NetherExBlocks;
import logictechcorp.netherex.world.biome.BiomeArcticAbyss;
import logictechcorp.netherex.world.biome.BiomeFungiForest;
import logictechcorp.netherex.world.biome.BiomeRuthlessSands;
import logictechcorp.netherex.world.biome.BiomeTorridWasteland;
import logictechcorp.netherex.world.biome.data.BiomeDataBOP;
import logictechcorp.netherex.world.biome.data.BiomeDataHell;
import logictechcorp.netherex.world.generation.trait.BiomeTraitEnoki;
import logictechcorp.netherex.world.generation.trait.BiomeTraitThornstalk;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@GameRegistry.ObjectHolder(value="netherex")
public class NetherExBiomes {
    public static final BiomeRuthlessSands RUTHLESS_SANDS = (BiomeRuthlessSands)((Object)InjectionHelper.nullValue());
    public static final BiomeFungiForest FUNGI_FOREST = (BiomeFungiForest)((Object)InjectionHelper.nullValue());
    public static final BiomeTorridWasteland TORRID_WASTELAND = (BiomeTorridWasteland)((Object)InjectionHelper.nullValue());
    public static final BiomeArcticAbyss ARCTIC_ABYSS = (BiomeArcticAbyss)((Object)InjectionHelper.nullValue());

    public static void registerBiomes() {
        BiomeDictionary.addTypes((Biome)RUTHLESS_SANDS, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.NETHER, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SANDY});
        BiomeDictionary.addTypes((Biome)FUNGI_FOREST, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.NETHER, BiomeDictionary.Type.COLD, BiomeDictionary.Type.WET, BiomeDictionary.Type.MUSHROOM});
        BiomeDictionary.addTypes((Biome)TORRID_WASTELAND, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.NETHER, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.WASTELAND});
        BiomeDictionary.addTypes((Biome)ARCTIC_ABYSS, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.NETHER, BiomeDictionary.Type.COLD, BiomeDictionary.Type.WET});
        LibraryExAPI.getInstance().getBiomeTraitRegistry().registerBiomeTrait(NetherEx.getResource("thornstalk"), (IBiomeTraitBuilder)new BiomeTraitThornstalk.Builder(), BiomeTraitThornstalk.class);
        LibraryExAPI.getInstance().getBiomeTraitRegistry().registerBiomeTrait(NetherEx.getResource("enoki"), (IBiomeTraitBuilder)new BiomeTraitEnoki.Builder(), BiomeTraitEnoki.class);
        IBiomeDataRegistry biomeDataRegistry = NetherExAPI.getInstance().getBiomeDataRegistry();
        biomeDataRegistry.registerBiomeData(BiomeDataHell.INSTANCE);
        biomeDataRegistry.registerBiomeData(RUTHLESS_SANDS.getBiomeData());
        biomeDataRegistry.registerBiomeData(FUNGI_FOREST.getBiomeData());
        biomeDataRegistry.registerBiomeData(TORRID_WASTELAND.getBiomeData());
        biomeDataRegistry.registerBiomeData(ARCTIC_ABYSS.getBiomeData());
        BiomeDataHell.INSTANCE.getBiomeTraits(GenerationStage.STRUCTURE).add(BiomeTraitStructure.create(trait -> {
            trait.generationAttempts(1);
            trait.generationProbability(0.25);
            trait.minimumGenerationHeight(32);
            trait.maximumGenerationHeight(118);
            trait.structures(Collections.singletonList(NetherEx.getResource("pigtificate_village/tiny_pigtificate_village")));
            trait.structureType(BiomeTraitStructure.StructureType.GROUND);
        }));
        BiomeDataHell.INSTANCE.getBiomeTraits(GenerationStage.ORE).add(BiomeTraitOre.create(trait -> {
            trait.generationAttempts(8);
            trait.minimumGenerationHeight(10);
            trait.maximumGenerationHeight(108);
            trait.blockToSpawn(NetherExBlocks.AMETHYST_ORE.func_176223_P());
            trait.blockToReplace(Blocks.field_150424_aL.func_176223_P());
            trait.veinSize(7);
        }));
        if (NetherEx.BIOMES_O_PLENTY_LOADED && ConfigHandler.compatibilityConfig.biomesOPlenty.enableCompatibility) {
            biomeDataRegistry.registerBiomeData((IBiomeData)new BiomeDataBOP(new ResourceLocation("biomesoplenty:corrupted_sands"), 8, true, false, true));
            biomeDataRegistry.registerBiomeData((IBiomeData)new BiomeDataBOP(new ResourceLocation("biomesoplenty:fungi_forest"), 4, true, false, true));
            biomeDataRegistry.registerBiomeData((IBiomeData)new BiomeDataBOP(new ResourceLocation("biomesoplenty:phantasmagoric_inferno"), 6, true, false, true));
            biomeDataRegistry.registerBiomeData((IBiomeData)new BiomeDataBOP(new ResourceLocation("biomesoplenty:undergarden"), 4, true, false, true));
            biomeDataRegistry.registerBiomeData((IBiomeData)new BiomeDataBOP(new ResourceLocation("biomesoplenty:visceral_heap"), 4, true, false, true));
        }
    }

    @Mod.EventBusSubscriber(modid="netherex")
    public static class EventHandler {
        @SubscribeEvent
        public static void onRegisterBiomes(RegistryEvent.Register<Biome> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new Biome[]{new BiomeRuthlessSands(), new BiomeFungiForest(), new BiomeTorridWasteland(), new BiomeArcticAbyss()});
        }
    }
}

