/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.netherex.tileentity;

import logictechcorp.libraryex.utility.ExperienceHelper;
import logictechcorp.netherex.block.BlockPossessedSoulSand;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileEntityPossessedSoulSand
extends TileEntity {
    private final int maxExperience = ExperienceHelper.getExperienceForLevel((int)30);
    private int experience = 0;

    public void consumeExperience(EntityPlayer player) {
        if (!this.field_145850_b.field_72995_K) {
            if (player.field_71075_bZ.field_75098_d) {
                return;
            }
            if (this.experience < this.maxExperience) {
                int playerExperience = ExperienceHelper.getPlayerExperience((EntityPlayer)player);
                if (playerExperience <= 0) {
                    return;
                }
                int drainAmount = Math.min(5, playerExperience);
                if (this.experience + drainAmount > this.maxExperience) {
                    drainAmount = this.maxExperience - this.experience;
                }
                ExperienceHelper.adjustPlayerExperience((EntityPlayer)player, (int)(-drainAmount));
                this.experience += drainAmount;
            }
            if (this.experience <= this.maxExperience) {
                this.increaseEyeGlow();
            }
        }
    }

    public void expelExperience() {
        if (!this.field_145850_b.field_72995_K) {
            while (this.experience > 0) {
                int experienceFragment = EntityXPOrb.func_70527_a((int)this.experience);
                this.experience -= experienceFragment;
                this.field_145850_b.func_72838_d((Entity)new EntityXPOrb(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, experienceFragment));
            }
        }
    }

    private void increaseEyeGlow() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        int experienceLevel = ExperienceHelper.getLevelForExperience((int)this.experience) / 2;
        if (state.func_177230_c() == this.func_145838_q()) {
            if ((experienceLevel == 2 || experienceLevel == 3) && (Integer)state.func_177229_b((IProperty)BlockPossessedSoulSand.STAGE) < 1) {
                this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)BlockPossessedSoulSand.STAGE, (Comparable)Integer.valueOf(1)));
            } else if ((experienceLevel == 4 || experienceLevel == 5) && (Integer)state.func_177229_b((IProperty)BlockPossessedSoulSand.STAGE) < 2) {
                this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)BlockPossessedSoulSand.STAGE, (Comparable)Integer.valueOf(2)));
            } else if ((experienceLevel == 6 || experienceLevel == 7) && (Integer)state.func_177229_b((IProperty)BlockPossessedSoulSand.STAGE) < 3) {
                this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)BlockPossessedSoulSand.STAGE, (Comparable)Integer.valueOf(3)));
            } else if ((experienceLevel == 8 || experienceLevel == 9) && (Integer)state.func_177229_b((IProperty)BlockPossessedSoulSand.STAGE) < 4) {
                this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)BlockPossessedSoulSand.STAGE, (Comparable)Integer.valueOf(4)));
            } else if ((experienceLevel == 10 || experienceLevel == 11) && (Integer)state.func_177229_b((IProperty)BlockPossessedSoulSand.STAGE) < 5) {
                this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)BlockPossessedSoulSand.STAGE, (Comparable)Integer.valueOf(5)));
            } else if ((experienceLevel == 12 || experienceLevel == 13) && (Integer)state.func_177229_b((IProperty)BlockPossessedSoulSand.STAGE) < 6) {
                this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)BlockPossessedSoulSand.STAGE, (Comparable)Integer.valueOf(6)));
            } else if ((experienceLevel == 14 || experienceLevel == 15) && (Integer)state.func_177229_b((IProperty)BlockPossessedSoulSand.STAGE) < 7) {
                this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)BlockPossessedSoulSand.STAGE, (Comparable)Integer.valueOf(7)));
            }
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.experience = compound.func_74762_e("Experience");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("Experience", this.experience);
        return compound;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189515_b(new NBTTagCompound()));
    }

    public int getExperience() {
        return this.experience;
    }
}

