/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.netherex.village;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.electronwill.nightconfig.json.JsonFormat;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import logictechcorp.libraryex.LibraryEx;
import logictechcorp.libraryex.trade.Trade;
import logictechcorp.libraryex.utility.FileHelper;
import logictechcorp.netherex.NetherEx;
import logictechcorp.netherex.init.NetherExRegistries;
import logictechcorp.netherex.village.PigtificateProfession;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.FileUtils;

public final class PigtificateTradeConfigManager {
    private PigtificateTradeConfigManager() {
    }

    public static void readTradeConfigs() {
        Path path = new File(LibraryEx.CONFIG_DIRECTORY, "netherex/trades").toPath();
        NetherEx.LOGGER.info("Reading Pigtificate trade configs from disk.");
        try {
            Files.createDirectories(path, new FileAttribute[0]);
            Iterator pathIter = Files.walk(path, new FileVisitOption[0]).iterator();
            while (pathIter.hasNext()) {
                Path configPath = (Path)pathIter.next();
                File configFile = configPath.toFile();
                if (FileHelper.getFileExtension((File)configFile).equals("json")) {
                    List tradeConfigs;
                    PigtificateProfession.Career career;
                    String fileText = FileUtils.readFileToString((File)configFile, (Charset)Charset.defaultCharset()).trim();
                    if (fileText.isEmpty() || !fileText.startsWith("{") || !fileText.endsWith("}")) {
                        String filePath = configFile.getPath();
                        String fileBackupPath = filePath + "_backup";
                        Files.move(configFile.toPath(), Paths.get(fileBackupPath, new String[0]), new CopyOption[0]);
                        NetherEx.LOGGER.warn("The trade config at {} was invalid and was backed up as {}.", (Object)filePath, (Object)fileBackupPath);
                        continue;
                    }
                    FileConfig config = FileConfig.builder((File)configFile, (ConfigFormat)JsonFormat.fancyInstance()).preserveInsertionOrder().build();
                    config.load();
                    PigtificateProfession profession = (PigtificateProfession)NetherExRegistries.PIGTIFICATE_PROFESSIONS.getValue(new ResourceLocation((String)config.get("profession")));
                    if (profession != null && (career = (PigtificateProfession.Career)profession.getCareer(new ResourceLocation((String)config.get("career")))) != null && (tradeConfigs = (List)config.getOrElse("trades", new ArrayList())).size() > 0) {
                        for (Config tradeConfig : tradeConfigs) {
                            career.addTrade(new Trade(tradeConfig));
                        }
                    }
                    config.save();
                    config.close();
                    continue;
                }
                if (configFile.isDirectory() || FileHelper.getFileExtension((File)configFile).equals("json_backup")) continue;
                NetherEx.LOGGER.warn("Skipping file located at {}, as it is not a json file.", (Object)configPath.toString());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeTradeConfigs() {
        try {
            NetherEx.LOGGER.info("Writing Pigtificate trade configs to disk.");
            for (PigtificateProfession profession : NetherExRegistries.PIGTIFICATE_PROFESSIONS.getValuesCollection()) {
                for (PigtificateProfession.Career career : profession.getCareers()) {
                    List trades = career.getTrades();
                    File configFile = new File(LibraryEx.CONFIG_DIRECTORY, "netherex/trades/" + career.getName().func_110624_b() + "/" + career.getName().func_110623_a() + ".json");
                    Files.createDirectories(configFile.getParentFile().toPath(), new FileAttribute[0]);
                    FileConfig tradeConfig = FileConfig.of((File)configFile);
                    tradeConfig.set("profession", (Object)profession.getName().toString());
                    tradeConfig.set("career", (Object)career.getName().toString());
                    tradeConfig.add("trades", trades.stream().map(Trade::getAsConfig).collect(Collectors.toList()));
                    tradeConfig.save();
                    tradeConfig.close();
                    trades.forEach(arg_0 -> ((PigtificateProfession.Career)career).removeTrade(arg_0));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

