/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.netherex.village;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import logictechcorp.netherex.village.PigtificateVillage;
import logictechcorp.netherex.village.PigtificateVillageFenceGateInfo;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;

public class PigtificateVillageData
extends WorldSavedData {
    private WeakReference<World> world;
    private final List<BlockPos> pigtificatePositions = new ArrayList<BlockPos>();
    private final List<PigtificateVillageFenceGateInfo> newFenceGates = new ArrayList<PigtificateVillageFenceGateInfo>();
    private final List<PigtificateVillage> villages = new ArrayList<PigtificateVillage>();
    private int tickCounter;

    public PigtificateVillageData(String name) {
        super(name);
    }

    public PigtificateVillageData(World world) {
        super(PigtificateVillageData.getDataId(world));
        this.world = new WeakReference<World>(world);
        this.func_76185_a();
    }

    public void setWorld(World world) {
        if (this.world != null && this.world.get() == world) {
            return;
        }
        this.world = new WeakReference<World>(world);
        for (PigtificateVillage village : this.villages) {
            village.setWorld(world);
        }
    }

    public void addPigtificate(BlockPos pos) {
        if (this.pigtificatePositions.size() <= 64 && !this.positionInList(pos)) {
            this.pigtificatePositions.add(pos);
        }
    }

    public void tick() {
        ++this.tickCounter;
        for (PigtificateVillage village : this.villages) {
            village.tick(this.tickCounter);
        }
        this.removeAnnihilatedVillages();
        this.dropOldestVillagerPosition();
        this.updateVillages();
        if (this.tickCounter % 400 == 0) {
            this.func_76185_a();
        }
    }

    private void removeAnnihilatedVillages() {
        Iterator<PigtificateVillage> iter = this.villages.iterator();
        while (iter.hasNext()) {
            PigtificateVillage village = iter.next();
            if (!village.isAnnihilated()) continue;
            iter.remove();
            this.func_76185_a();
        }
    }

    public List<PigtificateVillage> getVillages() {
        return this.villages;
    }

    public PigtificateVillage getNearestVillage(BlockPos fenceGateBlock, int radius) {
        PigtificateVillage village = null;
        double maxDistance = 3.4028234663852886E38;
        for (PigtificateVillage pigtificateVillage : this.villages) {
            float f;
            double fenceGateDistance = pigtificateVillage.getCenter().func_177951_i((Vec3i)fenceGateBlock);
            if (!(fenceGateDistance < maxDistance) || !(fenceGateDistance <= (double)((f = (float)(radius + pigtificateVillage.getRadius())) * f))) continue;
            village = pigtificateVillage;
            maxDistance = fenceGateDistance;
        }
        return village;
    }

    private void dropOldestVillagerPosition() {
        if (!this.pigtificatePositions.isEmpty()) {
            this.addFenceGatesAround(this.pigtificatePositions.remove(0));
        }
    }

    private void updateVillages() {
        for (PigtificateVillageFenceGateInfo fenceGateInfo : this.newFenceGates) {
            PigtificateVillage village = this.getNearestVillage(fenceGateInfo.getPos(), 32);
            if (village == null) {
                village = new PigtificateVillage((World)this.world.get());
                this.villages.add(village);
                this.func_76185_a();
            }
            village.addFenceGateInfo(fenceGateInfo);
        }
        this.newFenceGates.clear();
    }

    private void addFenceGatesAround(BlockPos central) {
        for (int x = -16; x < 16; ++x) {
            for (int y = -4; y < 4; ++y) {
                for (int z = -16; z < 16; ++z) {
                    BlockPos blockpos = central.func_177982_a(x, y, z);
                    EnumFacing inside = this.getInside(blockpos);
                    if (inside == null) continue;
                    PigtificateVillageFenceGateInfo fenceGateInfo = this.checkFenceGateExistence(blockpos);
                    if (fenceGateInfo == null) {
                        this.addNewFenceGateInfo(blockpos, inside);
                        continue;
                    }
                    fenceGateInfo.setLastActivityTime(this.tickCounter);
                }
            }
        }
    }

    private PigtificateVillageFenceGateInfo checkFenceGateExistence(BlockPos fenceGateBlock) {
        for (PigtificateVillageFenceGateInfo fenceGateInfo : this.newFenceGates) {
            if (fenceGateInfo.getPos().func_177958_n() != fenceGateBlock.func_177958_n() || fenceGateInfo.getPos().func_177952_p() != fenceGateBlock.func_177952_p() || Math.abs(fenceGateInfo.getPos().func_177956_o() - fenceGateBlock.func_177956_o()) > 1) continue;
            return fenceGateInfo;
        }
        for (PigtificateVillage village : this.villages) {
            PigtificateVillageFenceGateInfo fenceGateInfo = village.getExistingFenceGate(fenceGateBlock);
            if (fenceGateInfo == null) continue;
            return fenceGateInfo;
        }
        return null;
    }

    private void addNewFenceGateInfo(BlockPos fenceGateBlock, EnumFacing facing) {
        this.newFenceGates.add(new PigtificateVillageFenceGateInfo(fenceGateBlock, facing, this.tickCounter));
    }

    private boolean positionInList(BlockPos pos) {
        for (BlockPos blockPos : this.pigtificatePositions) {
            if (!blockPos.equals((Object)pos)) continue;
            return true;
        }
        return false;
    }

    private EnumFacing getInside(BlockPos fenceGatePos) {
        IBlockState fenceGateState;
        World world = (World)this.world.get();
        if (world != null && (fenceGateState = world.func_180495_p(fenceGatePos)).func_177230_c() instanceof BlockFenceGate) {
            return (EnumFacing)fenceGateState.func_177229_b((IProperty)BlockFenceGate.field_185512_D);
        }
        return null;
    }

    public void func_76184_a(NBTTagCompound compound) {
        this.tickCounter = compound.func_74762_e("Tick");
        NBTTagList list = compound.func_150295_c("PigtificateVillages", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound data = list.func_150305_b(i);
            PigtificateVillage village = new PigtificateVillage();
            village.readVillageDataFromNBT(data);
            this.villages.add(village);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        compound.func_74768_a("Tick", this.tickCounter);
        NBTTagList list = new NBTTagList();
        for (PigtificateVillage village : this.villages) {
            NBTTagCompound villageData = new NBTTagCompound();
            village.writeVillageDataToNBT(villageData);
            list.func_74742_a((NBTBase)villageData);
        }
        compound.func_74782_a("PigtificateVillages", (NBTBase)list);
        return compound;
    }

    public static String getDataId(World world) {
        return "nex_pigtificate_villages" + world.field_73011_w.func_186058_p().func_186067_c();
    }
}

