/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.netherex.world.biome;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.electronwill.nightconfig.json.JsonFormat;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import logictechcorp.libraryex.LibraryEx;
import logictechcorp.libraryex.api.world.biome.data.IBiomeData;
import logictechcorp.libraryex.api.world.biome.data.IBiomeDataRegistry;
import logictechcorp.libraryex.utility.FileHelper;
import logictechcorp.libraryex.world.biome.data.BiomeData;
import logictechcorp.netherex.NetherEx;
import logictechcorp.netherex.api.NetherExAPI;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.io.FileUtils;

public final class NetherBiomeDataConfigManager {
    private NetherBiomeDataConfigManager() {
    }

    public static void readBiomeDataConfigs() {
        Path path = new File(LibraryEx.CONFIG_DIRECTORY, "netherex/biomes").toPath();
        NetherEx.LOGGER.info("Reading Nether biome data configs from disk.");
        try {
            Files.createDirectories(path, new FileAttribute[0]);
            Iterator pathIter = Files.walk(path, new FileVisitOption[0]).iterator();
            while (pathIter.hasNext()) {
                File configFile = ((Path)pathIter.next()).toFile();
                if (FileHelper.getFileExtension((File)configFile).equals("json")) {
                    String fileText = FileUtils.readFileToString((File)configFile, (Charset)Charset.defaultCharset()).trim();
                    if (fileText.isEmpty() || !fileText.startsWith("{") || !fileText.endsWith("}")) {
                        String filePath = configFile.getPath();
                        String fileBackupPath = filePath + "_backup";
                        Files.move(configFile.toPath(), Paths.get(fileBackupPath, new String[0]), new CopyOption[0]);
                        NetherEx.LOGGER.warn("The biome config at {} was invalid and was backed up as {}.", (Object)filePath, (Object)fileBackupPath);
                        continue;
                    }
                    FileConfig config = FileConfig.builder((File)configFile, (ConfigFormat)JsonFormat.fancyInstance()).preserveInsertionOrder().build();
                    config.load();
                    Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation((String)config.get("biome")));
                    if (biome != null) {
                        IBiomeDataRegistry biomeDataRegistry = NetherExAPI.getInstance().getBiomeDataRegistry();
                        Object biomeData = biomeDataRegistry.hasBiomeData(biome) ? biomeDataRegistry.getBiomeData(biome) : new BiomeData(biome.getRegistryName(), 10, true, false, true);
                        biomeData.readFromConfig(biomeDataRegistry, (Config)config);
                        biomeDataRegistry.registerBiomeData(biomeData);
                    }
                    config.save();
                    config.close();
                    continue;
                }
                if (configFile.isDirectory() || FileHelper.getFileExtension((File)configFile).equals("json_backup")) continue;
                NetherEx.LOGGER.warn("Skipping file located at, {}, as it is not a json file.", (Object)configFile.getPath());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeBiomeDataConfigs() {
        NetherEx.LOGGER.info("Writing Nether biome data configs to disk.");
        IBiomeDataRegistry biomeDataRegistry = NetherExAPI.getInstance().getBiomeDataRegistry();
        for (IBiomeData biomeData : biomeDataRegistry.getBiomeData().values()) {
            File configFile = new File(LibraryEx.CONFIG_DIRECTORY, "netherex/biomes/" + biomeData.getBiome().getRegistryName().toString().replace(":", "/") + ".json");
            FileConfig config = FileConfig.builder((File)configFile, (ConfigFormat)JsonFormat.fancyInstance()).preserveInsertionOrder().build();
            if (!configFile.exists()) {
                try {
                    Files.createDirectories(configFile.getParentFile().toPath(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                config.load();
            }
            biomeData.writeToConfig((Config)config);
            config.save();
            config.close();
        }
    }
}

