/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.netherex.world.biome;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import logictechcorp.libraryex.api.world.biome.data.IBiomeData;
import logictechcorp.libraryex.api.world.biome.data.IBiomeDataRegistry;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeManager;

public final class NetherExBiomeDataRegistry
implements IBiomeDataRegistry {
    public static final IBiomeDataRegistry INSTANCE = new NetherExBiomeDataRegistry();
    private final Map<ResourceLocation, IBiomeData> biomeData = new HashMap<ResourceLocation, IBiomeData>();
    private final Map<ResourceLocation, BiomeManager.BiomeEntry> biomeEntries = new ConcurrentHashMap<ResourceLocation, BiomeManager.BiomeEntry>();

    private NetherExBiomeDataRegistry() {
    }

    public void registerBiomeData(IBiomeData biomeData) {
        if (biomeData != null && biomeData.getBiome() != null) {
            Biome biome = biomeData.getBiome();
            ResourceLocation biomeRegistryName = biome.getRegistryName();
            if (!this.biomeData.containsKey(biomeRegistryName)) {
                this.biomeData.put(biomeRegistryName, biomeData);
            }
            if (!biomeData.isSubBiome()) {
                if (biomeData.isEnabled()) {
                    this.biomeEntries.put(biomeRegistryName, new BiomeManager.BiomeEntry(biome, biomeData.getGenerationWeight()));
                } else {
                    this.biomeEntries.remove(biomeRegistryName);
                }
            }
        }
    }

    public void unregisterBiomeData(Biome biome) {
        if (biome != null) {
            ResourceLocation biomeRegistryName = biome.getRegistryName();
            this.biomeData.remove(biomeRegistryName);
            this.biomeEntries.remove(biomeRegistryName);
        }
    }

    public boolean hasBiomeData(Biome biome) {
        return this.biomeData.containsKey(biome.getRegistryName());
    }

    public IBiomeData getBiomeData(Biome biome) {
        return this.biomeData.get(biome.getRegistryName());
    }

    public Map<ResourceLocation, IBiomeData> getBiomeData() {
        return Collections.unmodifiableMap(this.biomeData);
    }

    public Map<ResourceLocation, BiomeManager.BiomeEntry> getBiomeEntries() {
        return Collections.unmodifiableMap(this.biomeEntries);
    }
}

