/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.netherex.world.biome.data;

import logictechcorp.libraryex.api.world.biome.BiomeBlockType;
import logictechcorp.libraryex.api.world.biome.data.IBiomeData;
import logictechcorp.libraryex.api.world.generation.GenerationStage;
import logictechcorp.libraryex.api.world.generation.trait.IBiomeTrait;
import logictechcorp.libraryex.world.biome.data.BiomeData;
import logictechcorp.libraryex.world.generation.trait.BiomeTraitCluster;
import logictechcorp.libraryex.world.generation.trait.BiomeTraitFluid;
import logictechcorp.libraryex.world.generation.trait.BiomeTraitOre;
import logictechcorp.libraryex.world.generation.trait.BiomeTraitScatter;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;

public final class BiomeDataHell
extends BiomeData {
    public static final IBiomeData INSTANCE = new BiomeDataHell();

    private BiomeDataHell() {
        super(Biomes.field_76778_j, 10, true, false, true);
        this.addBiomeBlock(BiomeBlockType.SURFACE_BLOCK, Blocks.field_150424_aL.func_176223_P());
        this.addBiomeBlock(BiomeBlockType.SUBSURFACE_BLOCK, Blocks.field_150424_aL.func_176223_P());
        this.addBiomeBlock(BiomeBlockType.CAVE_CEILING_BLOCK, Blocks.field_150424_aL.func_176223_P());
        this.addBiomeBlock(BiomeBlockType.CAVE_WALL_BLOCK, Blocks.field_150424_aL.func_176223_P());
        this.addBiomeBlock(BiomeBlockType.CAVE_FLOOR_BLOCK, Blocks.field_150424_aL.func_176223_P());
        this.addBiomeBlock(BiomeBlockType.FLUID_BLOCK, Blocks.field_150353_l.func_176223_P());
        this.addBiomeTrait(GenerationStage.DECORATION, (IBiomeTrait)BiomeTraitFluid.create(trait -> {
            trait.generationAttempts(8);
            trait.minimumGenerationHeight(4);
            trait.maximumGenerationHeight(124);
            trait.blockToSpawn(Blocks.field_150356_k.func_176223_P());
            trait.blockToTarget(Blocks.field_150424_aL.func_176223_P());
            trait.generateFalling(false);
        }));
        this.addBiomeTrait(GenerationStage.DECORATION, (IBiomeTrait)BiomeTraitScatter.create(trait -> {
            trait.generationAttempts(10);
            trait.randomizeGenerationAttempts(true);
            trait.minimumGenerationHeight(4);
            trait.maximumGenerationHeight(124);
            trait.blockToSpawn(Blocks.field_150480_ab.func_176223_P());
            trait.blockToTarget(Blocks.field_150424_aL.func_176223_P());
            trait.placement(BiomeTraitScatter.Placement.ON_GROUND);
        }));
        this.addBiomeTrait(GenerationStage.DECORATION, (IBiomeTrait)BiomeTraitCluster.create(trait -> {
            trait.generationAttempts(10);
            trait.randomizeGenerationAttempts(true);
            trait.minimumGenerationHeight(4);
            trait.maximumGenerationHeight(124);
            trait.blockToAttachTo(Blocks.field_150424_aL.func_176223_P());
            trait.direction(EnumFacing.DOWN);
        }));
        this.addBiomeTrait(GenerationStage.DECORATION, (IBiomeTrait)BiomeTraitCluster.create(trait -> {
            trait.generationAttempts(10);
            trait.minimumGenerationHeight(1);
            trait.maximumGenerationHeight(128);
            trait.blockToAttachTo(Blocks.field_150424_aL.func_176223_P());
            trait.direction(EnumFacing.DOWN);
        }));
        this.addBiomeTrait(GenerationStage.DECORATION, (IBiomeTrait)BiomeTraitFluid.create(trait -> {
            trait.generationAttempts(16);
            trait.minimumGenerationHeight(10);
            trait.maximumGenerationHeight(118);
            trait.blockToSpawn(Blocks.field_150356_k.func_176223_P());
            trait.blockToTarget(Blocks.field_150424_aL.func_176223_P());
            trait.generateFalling(true);
        }));
        this.addBiomeTrait(GenerationStage.PLANT_DECORATION, (IBiomeTrait)BiomeTraitScatter.create(trait -> {
            trait.generationAttempts(1);
            trait.generationProbability(0.25);
            trait.minimumGenerationHeight(1);
            trait.maximumGenerationHeight(128);
            trait.blockToSpawn(Blocks.field_150338_P.func_176223_P());
            trait.blockToTarget(Blocks.field_150424_aL.func_176223_P());
            trait.placement(BiomeTraitScatter.Placement.ON_GROUND);
        }));
        this.addBiomeTrait(GenerationStage.PLANT_DECORATION, (IBiomeTrait)BiomeTraitScatter.create(trait -> {
            trait.generationAttempts(1);
            trait.generationProbability(0.25);
            trait.minimumGenerationHeight(1);
            trait.maximumGenerationHeight(128);
            trait.blockToSpawn(Blocks.field_150337_Q.func_176223_P());
            trait.blockToTarget(Blocks.field_150424_aL.func_176223_P());
            trait.placement(BiomeTraitScatter.Placement.ON_GROUND);
        }));
        this.addBiomeTrait(GenerationStage.ORE, (IBiomeTrait)BiomeTraitOre.create(trait -> {
            trait.generationAttempts(16);
            trait.minimumGenerationHeight(10);
            trait.maximumGenerationHeight(108);
            trait.blockToSpawn(Blocks.field_150449_bY.func_176223_P());
            trait.blockToReplace(Blocks.field_150424_aL.func_176223_P());
            trait.veinSize(14);
        }));
        this.addBiomeTrait(GenerationStage.ORE, (IBiomeTrait)BiomeTraitOre.create(trait -> {
            trait.generationAttempts(4);
            trait.minimumGenerationHeight(28);
            trait.maximumGenerationHeight(38);
            trait.blockToSpawn(Blocks.field_189877_df.func_176223_P());
            trait.blockToReplace(Blocks.field_150424_aL.func_176223_P());
            trait.veinSize(32);
        }));
    }
}

