/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.netherex.world.biome.design;

import java.util.Random;
import logictechcorp.libraryex.api.world.biome.BiomeBlockType;
import logictechcorp.libraryex.api.world.biome.data.IBiomeData;
import logictechcorp.netherex.api.NetherExAPI;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraftforge.event.ForgeEventFactory;

public class BiomeStyler {
    public static void styleBiome(World world, IChunkGenerator generator, ChunkPrimer primer, int chunkX, int chunkZ, NoiseGeneratorPerlin terrainNoiseGen, double[] terrainNoise, Biome[] biomes, Random random) {
        if (!ForgeEventFactory.onReplaceBiomeBlocks((IChunkGenerator)generator, (int)chunkX, (int)chunkZ, (ChunkPrimer)primer, (World)world)) {
            return;
        }
        terrainNoise = terrainNoiseGen.func_151599_a(terrainNoise, (double)(chunkX * 16), (double)(chunkZ * 16), 16, 16, 0.0625, 0.0625, 1.0);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                IBiomeData biomeData = NetherExAPI.getInstance().getBiomeDataRegistry().getBiomeData(biomes[x + z * 16]);
                if (biomeData == null) continue;
                Biome biome = biomeData.getBiome();
                ResourceLocation biomeRegistryName = biome.getRegistryName();
                if (!biomeRegistryName.func_110624_b().equalsIgnoreCase("biomesoplenty")) {
                    IBlockState surfaceBlock = biomeData.getBiomeBlock(BiomeBlockType.SURFACE_BLOCK);
                    IBlockState subsurfaceBlock = biomeData.getBiomeBlock(BiomeBlockType.SUBSURFACE_BLOCK);
                    IBlockState caveCeilingBlock = biomeData.getBiomeBlock(BiomeBlockType.CAVE_CEILING_BLOCK);
                    IBlockState wallBlock = biomeData.getBiomeBlock(BiomeBlockType.CAVE_WALL_BLOCK);
                    IBlockState caveFloorBlock = biomeData.getBiomeBlock(BiomeBlockType.CAVE_FLOOR_BLOCK);
                    IBlockState fluidBlock = biomeData.getBiomeBlock(BiomeBlockType.FLUID_BLOCK);
                    int localX = chunkX * 16 + x & 0xF;
                    int localZ = chunkZ * 16 + z & 0xF;
                    boolean wasLastBlockSolid = true;
                    for (int localY = 127; localY >= 0; --localY) {
                        IBlockState state;
                        int blocksToSkip = 0;
                        IBlockState checkState = primer.func_177856_a(localX, localY, localZ);
                        if (checkState.func_177230_c() == Blocks.field_150424_aL) {
                            primer.func_177855_a(localX, localY, localZ, wallBlock);
                            if (!wasLastBlockSolid) {
                                primer.func_177855_a(localX, localY, localZ, surfaceBlock);
                                for (int floorOffset = 1; floorOffset <= 3 && localY - floorOffset >= 0; ++floorOffset) {
                                    state = primer.func_177856_a(localX, localY - floorOffset, localZ);
                                    blocksToSkip = floorOffset;
                                    if (state.func_177230_c() != Blocks.field_150424_aL) break;
                                    primer.func_177855_a(localX, localY - floorOffset, localZ, subsurfaceBlock);
                                }
                            }
                            wasLastBlockSolid = true;
                        } else if (checkState.func_177230_c() == Blocks.field_150350_a) {
                            if (wasLastBlockSolid) {
                                if (localY + 1 < 128) {
                                    primer.func_177855_a(localX, localY + 1, localZ, caveFloorBlock);
                                }
                                for (int roofOffset = 2; roofOffset <= 4 && localY + roofOffset <= 127 && ((state = primer.func_177856_a(localX, localY + roofOffset, localZ)).func_177230_c() == Blocks.field_150424_aL || state == wallBlock); ++roofOffset) {
                                    primer.func_177855_a(localX, localY + roofOffset, localZ, caveCeilingBlock);
                                }
                            }
                            wasLastBlockSolid = false;
                        } else if (checkState == Blocks.field_150353_l.func_176223_P()) {
                            primer.func_177855_a(localX, localY, localZ, fluidBlock);
                            wasLastBlockSolid = false;
                        }
                        localY -= blocksToSkip;
                    }
                    continue;
                }
                biome.func_180622_a(world, random, primer, chunkX * 16 + x, chunkZ * 16 + z, terrainNoise[x + z * 16]);
            }
        }
    }
}

