/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalinnovation.item;

import cofh.core.item.ItemMultiRF;
import cofh.core.util.helpers.EnergyHelper;
import cofh.core.util.helpers.MathHelper;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TLinkedHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public abstract class ItemMultiRFTool
extends ItemMultiRF {
    protected final TLinkedHashSet<String> toolClasses = new TLinkedHashSet();
    protected final Set<String> immutableClasses = Collections.unmodifiableSet(this.toolClasses);
    protected THashSet<Block> effectiveBlocks = new THashSet();
    protected THashSet<Material> effectiveMaterials = new THashSet();
    protected int energyPerUse = 200;
    public static final int CAPACITY_BASE = 40000;
    public static final int XFER_BASE = 1000;

    public ItemMultiRFTool(String modName) {
        super(modName);
        this.func_77627_a(true);
        this.func_77625_d(1);
        this.setNoRepair();
    }

    public ItemStack setDefaultTag(ItemStack stack, int energy) {
        EnergyHelper.setDefaultEnergyTag((ItemStack)stack, (int)energy);
        stack.func_77978_p().func_74768_a("Mode", this.getNumModes(stack) - 1);
        return stack;
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        return this.getHarvestLevel(stack) >= state.func_177230_c().getHarvestLevel(state) && this.func_150893_a(stack, state) > 1.0f;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        this.useEnergy(stack, 2, true);
        return true;
    }

    public int getHarvestLevel(ItemStack stack, String toolClass, @Nullable EntityPlayer player, @Nullable IBlockState blockState) {
        if (!this.getToolClasses(stack).contains(toolClass)) {
            return -1;
        }
        return this.getHarvestLevel(stack);
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return this.toolClasses.isEmpty() ? super.getToolClasses(stack) : this.immutableClasses;
    }

    protected boolean harvestBlock(World world, BlockPos pos, EntityPlayer player) {
        if (world.func_175623_d(pos)) {
            return false;
        }
        EntityPlayerMP playerMP = null;
        if (player instanceof EntityPlayerMP) {
            playerMP = (EntityPlayerMP)player;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!this.toolClasses.contains((Object)state.func_177230_c().getHarvestTool(state)) && !this.canHarvestBlock(state, player.func_184614_ca())) {
            return false;
        }
        if (!ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)player, (IBlockAccess)world, (BlockPos)pos)) {
            return false;
        }
        int xpToDrop = 0;
        if (playerMP != null && (xpToDrop = ForgeHooks.onBlockBreakEvent((World)world, (GameType)playerMP.field_71134_c.func_73081_b(), (EntityPlayerMP)playerMP, (BlockPos)pos)) == -1) {
            return false;
        }
        if (!world.field_72995_K) {
            if (block.removedByPlayer(state, world, pos, player, !player.field_71075_bZ.field_75098_d)) {
                block.func_176206_d(world, pos, state);
                if (!player.field_71075_bZ.field_75098_d) {
                    block.func_180657_a(world, player, pos, state, world.func_175625_s(pos), player.func_184614_ca());
                    if (xpToDrop > 0) {
                        block.func_180637_b(world, pos, xpToDrop);
                    }
                }
            }
            playerMP.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
        } else {
            if (block.removedByPlayer(state, world, pos, player, !player.field_71075_bZ.field_75098_d)) {
                block.func_176206_d(world, pos, state);
            }
            Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new CPacketPlayerDigging(CPacketPlayerDigging.Action.START_DESTROY_BLOCK, pos, Minecraft.func_71410_x().field_71476_x.field_178784_b));
        }
        return true;
    }

    protected int getHarvestLevel(ItemStack stack) {
        return -1;
    }

    protected int useEnergy(ItemStack stack, int count, boolean simulate) {
        if (ItemMultiRFTool.isCreative((ItemStack)stack)) {
            return 0;
        }
        int unbreakingLevel = MathHelper.clamp((int)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)stack), (int)0, (int)10);
        if (MathHelper.RANDOM.nextInt(2 + unbreakingLevel) >= 2) {
            return 0;
        }
        return this.extractEnergy(stack, count * this.energyPerUse, simulate);
    }

    protected int getTintIndex(ItemStack stack) {
        return 3;
    }

    protected void setActive(ItemStack stack, EntityLivingBase living) {
        stack.func_77978_p().func_74772_a("Active", living.field_70170_p.func_82737_E() + 20L);
    }

    protected int breakTunnel2(EntityPlayer player, World world, BlockPos pos, RayTraceResult traceResult, float refStrength) {
        float maxStrength = refStrength / 8.0f;
        switch (traceResult.field_178784_b) {
            case DOWN: 
            case UP: {
                break;
            }
            default: {
                BlockPos adjPos = new BlockPos((Vec3i)pos.func_177977_b());
                IBlockState adjState = world.func_180495_p(adjPos);
                float strength = adjState.func_185903_a(player, world, adjPos);
                if (!(strength > 0.0f) || !(strength >= maxStrength) || !this.harvestBlock(world, adjPos, player)) break;
                return 1;
            }
        }
        return 0;
    }

    protected int breakTunnel3(EntityPlayer player, World world, BlockPos pos, RayTraceResult traceResult, float refStrength) {
        float maxStrength = refStrength / 8.0f;
        int count = 0;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        switch (traceResult.field_178784_b) {
            case DOWN: 
            case UP: {
                int facing = MathHelper.floor((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
                if (facing % 2 == 0) {
                    BlockPos adjPos = new BlockPos(x, y, z - 1);
                    IBlockState adjState = world.func_180495_p(adjPos);
                    float strength = adjState.func_185903_a(player, world, adjPos);
                    if (strength > 0.0f && strength >= maxStrength && this.harvestBlock(world, adjPos, player)) {
                        ++count;
                    }
                    if (!((strength = (adjState = world.func_180495_p(adjPos = new BlockPos(x, y, z + 1))).func_185903_a(player, world, adjPos)) > 0.0f) || !(strength >= maxStrength) || !this.harvestBlock(world, adjPos, player)) break;
                    ++count;
                    break;
                }
                BlockPos adjPos = new BlockPos(x - 1, y, z);
                IBlockState adjState = world.func_180495_p(adjPos);
                float strength = adjState.func_185903_a(player, world, adjPos);
                if (strength > 0.0f && strength >= maxStrength && this.harvestBlock(world, adjPos, player)) {
                    ++count;
                }
                if (!((strength = (adjState = world.func_180495_p(adjPos = new BlockPos(x + 1, y, z))).func_185903_a(player, world, adjPos)) > 0.0f) || !(strength >= maxStrength) || !this.harvestBlock(world, adjPos, player)) break;
                ++count;
                break;
            }
            default: {
                BlockPos adjPos = new BlockPos(x, y - 1, z);
                IBlockState adjState = world.func_180495_p(adjPos);
                float strength = adjState.func_185903_a(player, world, adjPos);
                if (strength > 0.0f && strength >= maxStrength && this.harvestBlock(world, adjPos, player)) {
                    ++count;
                }
                if (!((strength = (adjState = world.func_180495_p(adjPos = new BlockPos(x, y + 1, z))).func_185903_a(player, world, adjPos)) > 0.0f) || !(strength >= maxStrength) || !this.harvestBlock(world, adjPos, player)) break;
                ++count;
            }
        }
        return count;
    }

    protected int breakArea3(EntityPlayer player, World world, BlockPos pos, RayTraceResult traceResult, float refStrength) {
        float maxStrength = refStrength / 8.0f;
        int count = 0;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        int radius = 1;
        switch (traceResult.field_178784_b) {
            case DOWN: 
            case UP: {
                for (int i = x - radius; i <= x + radius; ++i) {
                    for (int k = z - radius; k <= z + radius; ++k) {
                        BlockPos adjPos;
                        IBlockState adjState;
                        float strength;
                        if (i == x && k == z || !((strength = (adjState = world.func_180495_p(adjPos = new BlockPos(i, y, k))).func_185903_a(player, world, adjPos)) > 0.0f) || !(strength >= maxStrength) || !this.harvestBlock(world, adjPos, player)) continue;
                        ++count;
                    }
                }
                break;
            }
            case NORTH: 
            case SOUTH: {
                for (int i = x - radius; i <= x + radius; ++i) {
                    for (int j = y - radius; j <= y + radius; ++j) {
                        BlockPos adjPos;
                        IBlockState adjState;
                        float strength;
                        if (i == x && j == y || !((strength = (adjState = world.func_180495_p(adjPos = new BlockPos(i, j, z))).func_185903_a(player, world, adjPos)) > 0.0f) || !(strength >= maxStrength) || !this.harvestBlock(world, adjPos, player)) continue;
                        ++count;
                    }
                }
                break;
            }
            default: {
                for (int j = y - radius; j <= y + radius; ++j) {
                    for (int k = z - radius; k <= z + radius; ++k) {
                        BlockPos adjPos;
                        IBlockState adjState;
                        float strength;
                        if (j == y && k == z || !((strength = (adjState = world.func_180495_p(adjPos = new BlockPos(x, j, k))).func_185903_a(player, world, adjPos)) > 0.0f) || !(strength >= maxStrength) || !this.harvestBlock(world, adjPos, player)) continue;
                        ++count;
                    }
                }
            }
        }
        return count;
    }

    protected int breakCube3(EntityPlayer player, World world, BlockPos pos, RayTraceResult traceResult, float refStrength) {
        int depth;
        float maxStrength = refStrength / 8.0f;
        int count = 0;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        int radius = 1;
        int depth_min = depth = 2;
        int depth_max = 0;
        switch (traceResult.field_178784_b) {
            case DOWN: {
                depth_min = 0;
                depth_max = depth;
            }
            case UP: {
                for (int i = x - radius; i <= x + radius; ++i) {
                    for (int j = y - depth_min; j <= y + depth_max; ++j) {
                        for (int k = z - radius; k <= z + radius; ++k) {
                            BlockPos adjPos;
                            IBlockState adjState;
                            float strength;
                            if (i == x && j == y && k == z || !((strength = (adjState = world.func_180495_p(adjPos = new BlockPos(i, j, k))).func_185903_a(player, world, adjPos)) > 0.0f) || !(strength >= maxStrength) || !this.harvestBlock(world, adjPos, player)) continue;
                            ++count;
                        }
                    }
                }
                break;
            }
            case NORTH: {
                depth_min = 0;
                depth_max = depth;
            }
            case SOUTH: {
                for (int i = x - radius; i <= x + radius; ++i) {
                    for (int j = y - radius; j <= y + radius; ++j) {
                        for (int k = z - depth_min; k <= z + depth_max; ++k) {
                            BlockPos adjPos;
                            IBlockState adjState;
                            float strength;
                            if (i == x && j == y && k == z || !((strength = (adjState = world.func_180495_p(adjPos = new BlockPos(i, j, k))).func_185903_a(player, world, adjPos)) > 0.0f) || !(strength >= maxStrength) || !this.harvestBlock(world, adjPos, player)) continue;
                            ++count;
                        }
                    }
                }
                break;
            }
            case WEST: {
                depth_min = 0;
                depth_max = depth;
            }
            case EAST: {
                for (int i = x - depth_min; i <= x + depth_max; ++i) {
                    for (int j = y - radius; j <= y + radius; ++j) {
                        for (int k = z - radius; k <= z + radius; ++k) {
                            BlockPos adjPos;
                            IBlockState adjState;
                            float strength;
                            if (i == x && j == y && k == z || !((strength = (adjState = world.func_180495_p(adjPos = new BlockPos(i, j, k))).func_185903_a(player, world, adjPos)) > 0.0f) || !(strength >= maxStrength) || !this.harvestBlock(world, adjPos, player)) continue;
                            ++count;
                        }
                    }
                }
                break;
            }
        }
        return count;
    }

    protected int breakArea5(EntityPlayer player, World world, BlockPos pos, RayTraceResult traceResult, float refStrength) {
        float maxStrength = refStrength / 8.0f;
        int count = 0;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        int radius = 2;
        switch (traceResult.field_178784_b) {
            case DOWN: 
            case UP: {
                for (int i = x - radius; i <= x + radius; ++i) {
                    for (int k = z - radius; k <= z + radius; ++k) {
                        BlockPos adjPos = new BlockPos(i, y, k);
                        IBlockState adjState = world.func_180495_p(adjPos);
                        float strength = adjState.func_185903_a(player, world, adjPos);
                        if (!(strength > 0.0f) || !(strength >= maxStrength) || !this.harvestBlock(world, adjPos, player)) continue;
                        ++count;
                    }
                }
                break;
            }
            case NORTH: 
            case SOUTH: {
                int posY = y++;
                for (int i = x - radius; i <= x + radius; ++i) {
                    for (int j = y - radius; j <= y + radius; ++j) {
                        BlockPos adjPos;
                        IBlockState adjState;
                        float strength;
                        if (i == x && j == posY || !((strength = (adjState = world.func_180495_p(adjPos = new BlockPos(i, j, z))).func_185903_a(player, world, adjPos)) > 0.0f) || !(strength >= maxStrength) || !this.harvestBlock(world, adjPos, player)) continue;
                        ++count;
                    }
                }
                break;
            }
            default: {
                int posY = y++;
                for (int j = y - radius; j <= y + radius; ++j) {
                    for (int k = z - radius; k <= z + radius; ++k) {
                        BlockPos adjPos;
                        IBlockState adjState;
                        float strength;
                        if (j == posY && k == z || !((strength = (adjState = world.func_180495_p(adjPos = new BlockPos(x, j, k))).func_185903_a(player, world, adjPos)) > 0.0f) || !(strength >= maxStrength) || !this.harvestBlock(world, adjPos, player)) continue;
                        ++count;
                    }
                }
            }
        }
        return count;
    }

    protected void getAOEBlocksTunnel2(ItemStack stack, World world, BlockPos pos, RayTraceResult traceResult, ArrayList<BlockPos> area) {
        switch (traceResult.field_178784_b) {
            case DOWN: 
            case UP: {
                break;
            }
            default: {
                BlockPos harvestPos = new BlockPos((Vec3i)pos.func_177977_b());
                if (!this.canHarvestBlock(world.func_180495_p(harvestPos), stack)) break;
                area.add(harvestPos);
            }
        }
    }

    protected void getAOEBlocksTunnel3(ItemStack stack, World world, EntityPlayer player, BlockPos pos, RayTraceResult traceResult, ArrayList<BlockPos> area) {
        BlockPos harvestPos;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        switch (traceResult.field_178784_b) {
            case DOWN: 
            case UP: {
                int facing = MathHelper.floor((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
                if (facing % 2 == 0) {
                    harvestPos = new BlockPos(x, y, z - 1);
                    if (this.canHarvestBlock(world.func_180495_p(harvestPos), stack)) {
                        area.add(harvestPos);
                    }
                    if (!this.canHarvestBlock(world.func_180495_p(harvestPos = new BlockPos(x, y, z + 1)), stack)) break;
                    area.add(harvestPos);
                    break;
                }
                harvestPos = new BlockPos(x - 1, y, z);
                if (this.canHarvestBlock(world.func_180495_p(harvestPos), stack)) {
                    area.add(harvestPos);
                }
                if (!this.canHarvestBlock(world.func_180495_p(harvestPos = new BlockPos(x + 1, y, z)), stack)) break;
                area.add(harvestPos);
            }
        }
        harvestPos = new BlockPos(x, y - 1, z);
        if (this.canHarvestBlock(world.func_180495_p(harvestPos), stack)) {
            area.add(harvestPos);
        }
        if (this.canHarvestBlock(world.func_180495_p(harvestPos = new BlockPos(x, y + 1, z)), stack)) {
            area.add(harvestPos);
        }
    }

    protected void getAOEBlocksArea3(ItemStack stack, World world, BlockPos pos, RayTraceResult traceResult, ArrayList<BlockPos> area) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        int radius = 1;
        switch (traceResult.field_178784_b) {
            case DOWN: 
            case UP: {
                for (int i = x - radius; i <= x + radius; ++i) {
                    for (int k = z - radius; k <= z + radius; ++k) {
                        BlockPos harvestPos;
                        if (i == x && k == z || !this.canHarvestBlock(world.func_180495_p(harvestPos = new BlockPos(i, y, k)), stack)) continue;
                        area.add(harvestPos);
                    }
                }
                break;
            }
            case NORTH: 
            case SOUTH: {
                for (int i = x - radius; i <= x + radius; ++i) {
                    for (int j = y - radius; j <= y + radius; ++j) {
                        BlockPos harvestPos;
                        if (i == x && j == y || !this.canHarvestBlock(world.func_180495_p(harvestPos = new BlockPos(i, j, z)), stack)) continue;
                        area.add(harvestPos);
                    }
                }
                break;
            }
            default: {
                for (int j = y - radius; j <= y + radius; ++j) {
                    for (int k = z - radius; k <= z + radius; ++k) {
                        BlockPos harvestPos;
                        if (j == y && k == z || !this.canHarvestBlock(world.func_180495_p(harvestPos = new BlockPos(x, j, k)), stack)) continue;
                        area.add(harvestPos);
                    }
                }
            }
        }
    }

    protected void getAOEBlocksCube3(ItemStack stack, World world, BlockPos pos, RayTraceResult traceResult, ArrayList<BlockPos> area) {
        int depth;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        int radius = 1;
        int depth_min = depth = 2;
        int depth_max = 0;
        switch (traceResult.field_178784_b) {
            case DOWN: {
                depth_min = 0;
                depth_max = depth;
            }
            case UP: {
                for (int i = x - radius; i <= x + radius; ++i) {
                    for (int j = y - depth_min; j <= y + depth_max; ++j) {
                        for (int k = z - radius; k <= z + radius; ++k) {
                            BlockPos harvestPos;
                            if (i == x && j == y && k == z || !this.canHarvestBlock(world.func_180495_p(harvestPos = new BlockPos(i, j, k)), stack)) continue;
                            area.add(harvestPos);
                        }
                    }
                }
                break;
            }
            case NORTH: {
                depth_min = 0;
                depth_max = depth;
            }
            case SOUTH: {
                for (int i = x - radius; i <= x + radius; ++i) {
                    for (int j = y - radius; j <= y + radius; ++j) {
                        for (int k = z - depth_min; k <= z + depth_max; ++k) {
                            BlockPos harvestPos;
                            if (i == x && j == y && k == z || !this.canHarvestBlock(world.func_180495_p(harvestPos = new BlockPos(i, j, k)), stack)) continue;
                            area.add(harvestPos);
                        }
                    }
                }
                break;
            }
            case WEST: {
                depth_min = 0;
                depth_max = depth;
            }
            case EAST: {
                for (int i = x - depth_min; i <= x + depth_max; ++i) {
                    for (int j = y - radius; j <= y + radius; ++j) {
                        for (int k = z - radius; k <= z + radius; ++k) {
                            BlockPos harvestPos;
                            if (i == x && j == y && k == z || !this.canHarvestBlock(world.func_180495_p(harvestPos = new BlockPos(i, j, k)), stack)) continue;
                            area.add(harvestPos);
                        }
                    }
                }
                break;
            }
        }
    }

    protected void getAOEBlocksArea5(ItemStack stack, World world, BlockPos pos, RayTraceResult traceResult, ArrayList<BlockPos> area) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        int radius = 2;
        switch (traceResult.field_178784_b) {
            case DOWN: 
            case UP: {
                for (int i = x - radius; i <= x + radius; ++i) {
                    for (int k = z - radius; k <= z + radius; ++k) {
                        BlockPos harvestPos;
                        if (i == x && k == z || !this.canHarvestBlock(world.func_180495_p(harvestPos = new BlockPos(i, y, k)), stack)) continue;
                        area.add(harvestPos);
                    }
                }
                break;
            }
            case NORTH: 
            case SOUTH: {
                int posY = y++;
                for (int i = x - radius; i <= x + radius; ++i) {
                    for (int j = y - radius; j <= y + radius; ++j) {
                        BlockPos harvestPos;
                        if (i == x && j == posY || !this.canHarvestBlock(world.func_180495_p(harvestPos = new BlockPos(i, j, z)), stack)) continue;
                        area.add(harvestPos);
                    }
                }
                break;
            }
            default: {
                int posY = y++;
                for (int j = y - radius; j <= y + radius; ++j) {
                    for (int k = z - radius; k <= z + radius; ++k) {
                        BlockPos harvestPos;
                        if (j == posY && k == z || !this.canHarvestBlock(world.func_180495_p(harvestPos = new BlockPos(x, j, k)), stack)) continue;
                        area.add(harvestPos);
                    }
                }
            }
        }
    }

    protected void getAOEBlocksCross1(ItemStack stack, World world, BlockPos pos, RayTraceResult traceResult, ArrayList<BlockPos> area) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        switch (traceResult.field_178784_b) {
            case DOWN: 
            case UP: {
                BlockPos harvestPos = new BlockPos(x - 1, y, z);
                if (this.canHarvestBlock(world.func_180495_p(harvestPos), stack)) {
                    area.add(harvestPos);
                }
                if (this.canHarvestBlock(world.func_180495_p(harvestPos = new BlockPos(x + 1, y, z)), stack)) {
                    area.add(harvestPos);
                }
                if (this.canHarvestBlock(world.func_180495_p(harvestPos = new BlockPos(x, y, z - 1)), stack)) {
                    area.add(harvestPos);
                }
                if (!this.canHarvestBlock(world.func_180495_p(harvestPos = new BlockPos(x, y, z + 1)), stack)) break;
                area.add(harvestPos);
                break;
            }
            case NORTH: 
            case SOUTH: {
                BlockPos harvestPos = new BlockPos(x - 1, y, z);
                if (this.canHarvestBlock(world.func_180495_p(harvestPos), stack)) {
                    area.add(harvestPos);
                }
                if (this.canHarvestBlock(world.func_180495_p(harvestPos = new BlockPos(x + 1, y, z)), stack)) {
                    area.add(harvestPos);
                }
                if (this.canHarvestBlock(world.func_180495_p(harvestPos = new BlockPos(x, y - 1, z)), stack)) {
                    area.add(harvestPos);
                }
                if (!this.canHarvestBlock(world.func_180495_p(harvestPos = new BlockPos(x, y + 1, z)), stack)) break;
                area.add(harvestPos);
                break;
            }
            default: {
                BlockPos harvestPos = new BlockPos(x, y - 1, z);
                if (this.canHarvestBlock(world.func_180495_p(harvestPos), stack)) {
                    area.add(harvestPos);
                }
                if (this.canHarvestBlock(world.func_180495_p(harvestPos = new BlockPos(x, y + 1, z)), stack)) {
                    area.add(harvestPos);
                }
                if (this.canHarvestBlock(world.func_180495_p(harvestPos = new BlockPos(x, y, z - 1)), stack)) {
                    area.add(harvestPos);
                }
                if (!this.canHarvestBlock(world.func_180495_p(harvestPos = new BlockPos(x, y, z + 1)), stack)) break;
                area.add(harvestPos);
            }
        }
    }
}

